/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DelegatingOps<T> {
    private final RegistryInfoLookup lookupProvider;

    public static <T> RegistryOps<T> create(DynamicOps<T> p_256342_, HolderLookup.Provider p_255950_) {
        return RegistryOps.create(p_256342_, new HolderLookupAdapter(p_255950_));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> p_256278_, RegistryInfoLookup p_256479_) {
        return new RegistryOps<T>(p_256278_, p_256479_);
    }

    public static <T> Dynamic<T> injectRegistryContext(Dynamic<T> p_323625_, HolderLookup.Provider p_324054_) {
        return new Dynamic(p_324054_.createSerializationContext(p_323625_.getOps()), p_323625_.getValue());
    }

    protected RegistryOps(DynamicOps<T> p_256313_, RegistryInfoLookup p_255799_) {
        super(p_256313_);
        this.lookupProvider = p_255799_;
    }

    protected RegistryOps(RegistryOps<T> other) {
        super(other);
        this.lookupProvider = other.lookupProvider;
    }

    public <U> RegistryOps<U> withParent(DynamicOps<U> p_330654_) {
        return p_330654_ == this.delegate ? this : new RegistryOps<U>(p_330654_, this.lookupProvider);
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends Registry<? extends E>> p_255757_) {
        return this.lookupProvider.lookup(p_255757_).map(RegistryInfo::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends Registry<? extends E>> p_256031_) {
        return this.lookupProvider.lookup(p_256031_).map(RegistryInfo::getter);
    }

    public boolean equals(Object p_341917_) {
        if (this == p_341917_) {
            return true;
        }
        if (p_341917_ != null && ((Object)((Object)this)).getClass() == p_341917_.getClass()) {
            RegistryOps registryops = (RegistryOps)((Object)p_341917_);
            return this.delegate.equals((Object)registryops.delegate) && this.lookupProvider.equals(registryops.lookupProvider);
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.lookupProvider.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends Registry<? extends E>> p_206833_) {
        return ExtraCodecs.retrieveContext(p_274811_ -> {
            DataResult dataResult;
            if (p_274811_ instanceof RegistryOps) {
                RegistryOps registryops = (RegistryOps)((Object)p_274811_);
                dataResult = registryops.lookupProvider.lookup(p_206833_).map(p_255527_ -> DataResult.success(p_255527_.getter(), (Lifecycle)p_255527_.elementsLifecycle())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(p_206833_)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(p_255526_ -> null);
    }

    public static <E> MapCodec<HolderLookup.RegistryLookup<E>> retrieveRegistryLookup(ResourceKey<? extends Registry<? extends E>> resourceKey) {
        return ExtraCodecs.retrieveContext(ops -> {
            if (!(ops instanceof RegistryOps)) {
                return DataResult.error(() -> "Not a registry ops");
            }
            RegistryOps registryOps = (RegistryOps)((Object)ops);
            return registryOps.lookupProvider.lookup(resourceKey).map(registryInfo -> {
                HolderOwner patt0$temp = registryInfo.owner();
                if (!(patt0$temp instanceof HolderLookup.RegistryLookup)) {
                    return DataResult.error(() -> "Found holder getter but was not a registry lookup for " + String.valueOf(resourceKey));
                }
                HolderLookup.RegistryLookup registryLookup = (HolderLookup.RegistryLookup)patt0$temp;
                return DataResult.success((Object)registryLookup, (Lifecycle)registryInfo.elementsLifecycle());
            }).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(resourceKey)));
        });
    }

    public static <E, O> RecordCodecBuilder<O, Holder.Reference<E>> retrieveElement(ResourceKey<E> p_256347_) {
        ResourceKey resourcekey = ResourceKey.createRegistryKey(p_256347_.registry());
        return ExtraCodecs.retrieveContext(p_274808_ -> {
            DataResult dataResult;
            if (p_274808_ instanceof RegistryOps) {
                RegistryOps registryops = (RegistryOps)((Object)p_274808_);
                dataResult = registryops.lookupProvider.lookup(resourcekey).flatMap(p_255518_ -> p_255518_.getter().get(p_256347_)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(p_256347_)));
            } else {
                dataResult = DataResult.error(() -> "Not a registry ops");
            }
            return dataResult;
        }).forGetter(p_255524_ -> null);
    }

    static final class HolderLookupAdapter
    implements RegistryInfoLookup {
        private final HolderLookup.Provider lookupProvider;
        private final Map<ResourceKey<? extends Registry<?>>, Optional<? extends RegistryInfo<?>>> lookups = new ConcurrentHashMap();

        public HolderLookupAdapter(HolderLookup.Provider p_341886_) {
            this.lookupProvider = p_341886_;
        }

        public <E> Optional<RegistryInfo<E>> lookup(ResourceKey<? extends Registry<? extends E>> p_341913_) {
            return this.lookups.computeIfAbsent(p_341913_, this::createLookup);
        }

        private Optional<RegistryInfo<Object>> createLookup(ResourceKey<? extends Registry<?>> p_341910_) {
            return this.lookupProvider.lookup(p_341910_).map(RegistryInfo::fromRegistryLookup);
        }

        public boolean equals(Object p_341924_) {
            if (this == p_341924_) {
                return true;
            }
            if (p_341924_ instanceof HolderLookupAdapter) {
                HolderLookupAdapter registryops$holderlookupadapter = (HolderLookupAdapter)p_341924_;
                if (this.lookupProvider.equals(registryops$holderlookupadapter.lookupProvider)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.lookupProvider.hashCode();
        }
    }

    public static interface RegistryInfoLookup {
        public <T> Optional<RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var1);
    }

    public record RegistryInfo<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
        public static <T> RegistryInfo<T> fromRegistryLookup(HolderLookup.RegistryLookup<T> p_326797_) {
            return new RegistryInfo<T>(p_326797_, p_326797_, p_326797_.registryLifecycle());
        }
    }
}

