/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class ShapeListImpl
extends ObjectSelectionList<Entry>
implements IShapeList {
    private Runnable update;

    public ShapeListImpl(Minecraft minecraft, int left, int right, int top, int bottom, int slotHeight, Runnable update) {
        super(minecraft, right - left, bottom - top, top, slotHeight);
        this.setX(left);
        this.update = update;
        for (int shapeSetId = 0; shapeSetId < BuildGuide.stateManager.getState().shapeSets.size(); ++shapeSetId) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(shapeSetId));
            if (shapeSetId != BuildGuide.stateManager.getState().getShapeSetIndex()) continue;
            this.setSelected((Entry)this.children().get(this.children().size() - 1));
        }
    }

    @Override
    public void setYPosition(int y) {
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    @Override
    public void addEntry(int shapeSetId) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(shapeSetId));
        this.setSelected((Entry)this.children().get(shapeSetId));
    }

    public boolean removeEntry(Entry entry) {
        for (Entry e : this.children()) {
            if (e.getShapeSetId() <= entry.getShapeSetId()) continue;
            e.setShapeSetId(e.getShapeSetId() - 1);
        }
        if (this.children().size() > entry.getShapeSetId() + 1) {
            this.setSelected((Entry)this.children().get(entry.getShapeSetId() + 1));
        } else if (this.children().size() > 1) {
            this.setSelected((Entry)this.children().get(entry.getShapeSetId() - 1));
        }
        return super.removeEntry((AbstractSelectionList.Entry)entry);
    }

    @Override
    public boolean removeEntry(IShapeList.IEntry entry) {
        return this.removeEntry((Entry)entry);
    }

    public void setSelected(@Nullable Entry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            BuildGuide.stateManager.getState().setShapeSetIndex(entry.getShapeSetId());
        }
        this.update.run();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), 0x33000000);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int colourOuter, int colourInner) {
        int left = this.getX() + (this.width - width) / 2;
        int right = this.getX() + (this.width + width) / 2;
        this.boundedFill(guiGraphics, left, top - 2, right, top + height + 2, this.getX(), this.getY(), this.getRight(), this.getBottom(), colourOuter);
        this.boundedFill(guiGraphics, left + 1, top - 1, right - 1, top + height + 1, this.getX(), this.getY(), this.getRight(), this.getBottom(), colourInner);
    }

    private void boundedFill(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int boundLeft, int boundTop, int boundRight, int boundBottom, int colour) {
        if (left < boundRight && top < boundBottom && right > boundLeft && bottom > boundTop) {
            guiGraphics.fill(Math.max(left, boundLeft), Math.max(top, boundTop), Math.min(right, boundRight), Math.min(bottom, boundBottom), colour);
        }
    }

    public int getRowWidth() {
        return this.width - 12;
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    public final class Entry
    extends ObjectSelectionList.Entry<Entry>
    implements IShapeList.IEntry {
        private int shapeSetId;

        public Entry(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            guiGraphics.drawString(Minecraft.getInstance().font, BuildGuide.screenHandler.getFormattedShapeName(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId)), x + 5, y + 4, BuildGuide.screenHandler.getShapeProgressColour(BuildGuide.stateManager.getState().shapeSets.get(this.shapeSetId).getShape()), true);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            ShapeListImpl.this.setSelected(this);
            return false;
        }

        @Override
        public void setShapeSetId(int shapeSetId) {
            this.shapeSetId = shapeSetId;
        }

        @Override
        public int getShapeSetId() {
            return this.shapeSetId;
        }

        public Component getNarration() {
            return Component.literal((String)"");
        }
    }
}

