/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.forge.screen.widget;

import brentmaas.buildguide.common.screen.AbstractScreenHandler;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.network.chat.Component;

public class CheckboxRunnableButtonImpl
implements ICheckboxRunnableButton {
    protected final ICheckboxRunnableButton.IPressable onPress;
    private int x;
    private int y;
    private AbstractScreenHandler.Translatable title;
    private boolean checked;
    public Checkbox checkbox;

    public CheckboxRunnableButtonImpl(int x, int y, int width, int height, AbstractScreenHandler.Translatable title, boolean checked, boolean drawTitle, ICheckboxRunnableButton.IPressable onPress) {
        this.x = x;
        this.y = y;
        this.title = title;
        this.checked = checked;
        this.onPress = onPress;
    }

    public void initCheckboxIfNull() {
        if (this.checkbox == null) {
            this.checkbox = Checkbox.builder((Component)Component.translatable((String)this.title.getTranslationKey(), (Object[])this.title.getValues()), (Font)Minecraft.getInstance().font).pos(this.x, this.y).onValueChange((cb, selected) -> this.onPress()).selected(this.checked).build();
        }
    }

    @Override
    public void onPress() {
        this.onPress.onPress();
    }

    @Override
    public void setChecked(boolean checked) {
        this.initCheckboxIfNull();
        if (this.checkbox.selected() != checked) {
            this.checkbox.onPress();
        }
    }

    @Override
    public boolean isCheckboxSelected() {
        this.initCheckboxIfNull();
        return this.checkbox.selected();
    }

    @Override
    public void setActive(boolean active) {
        this.initCheckboxIfNull();
        this.checkbox.active = active;
    }

    @Override
    public void setYPosition(int y) {
        this.initCheckboxIfNull();
        this.checkbox.setY(y);
    }

    @Override
    public void setVisibility(boolean visible) {
        this.initCheckboxIfNull();
        this.checkbox.visible = visible;
    }
}

