/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Config {
    private File configFile;
    public ArrayList<ConfigElement<?>> configElements = new ArrayList();
    public ConfigElement<Boolean> asyncEnabled = new BooleanConfigElement(this, "asyncEnabled", true, "Enable asynchronous (multithreaded) shape generation.");
    public ConfigElement<Boolean> shapeListRandomColorsDefaultEnabled = new BooleanConfigElement(this, "shapeListRandomColorsDefaultEnabled", false, "Enable random colors for new shapes added to the shape list by default.");
    public ConfigElement<Boolean> persistenceEnabled = new BooleanConfigElement(this, "persistenceEnabled", false, "Allow shapes to be saved to a file so they can be restored after restarting the client.");
    public ConfigElement<Boolean> debugGenerationTimingsEnabled = new BooleanConfigElement(this, "debugGenerationTimingsEnabled", false, "Enable debug output telling you how long it took for a shape to generate.");

    public Config(File configFolder) {
        this.configFile = new File(configFolder, "buildguide.cfg");
        this.configElements.add(this.asyncEnabled);
        this.configElements.add(this.shapeListRandomColorsDefaultEnabled);
        this.configElements.add(this.persistenceEnabled);
        this.configElements.add(this.debugGenerationTimingsEnabled);
        if (!this.configFile.exists()) {
            this.write();
        } else {
            this.load();
        }
    }

    public void write() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));
            for (ConfigElement<?> element : this.configElements) {
                if (element.comment != null) {
                    writer.write("# " + element.comment + "\n");
                }
                writer.write(element.key + " = " + String.valueOf(element.value) + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            String line;
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                String[] split = line.split(" = ", 2);
                if (split.length < 2) {
                    BuildGuide.logHandler.errorOrHigher("Invalid config line: '" + line + "'");
                    continue;
                }
                keys.add(split[0]);
                values.add(split[1]);
            }
            reader.close();
            Object[] present = new Boolean[this.configElements.size()];
            Arrays.fill(present, (Object)false);
            block5: for (int i = 0; i < keys.size(); ++i) {
                for (int j = 0; j < this.configElements.size(); ++j) {
                    if (!((String)keys.get(i)).equals(this.configElements.get((int)j).key)) continue;
                    try {
                        this.configElements.get(j).setValue((String)values.get(i));
                    }
                    catch (Exception e) {
                        BuildGuide.logHandler.errorOrHigher("Could not read value '" + (String)values.get(i) + "' for config '" + (String)keys.get(j) + "', keeping '" + String.valueOf(this.configElements.get((int)j).value) + "'");
                    }
                    present[j] = true;
                    continue block5;
                }
            }
            if (Arrays.asList(present).contains(false)) {
                this.write();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class BooleanConfigElement
    extends ConfigElement<Boolean> {
        public BooleanConfigElement(Config this$0, String key, Boolean defaultValue) {
            super(this$0, key, defaultValue);
        }

        public BooleanConfigElement(Config this$0, String key, Boolean defaultValue, String comment) {
            super(this$0, key, defaultValue, comment);
        }

        @Override
        public void setValue(String value) {
            this.value = Boolean.parseBoolean(value);
        }
    }

    public abstract class ConfigElement<T> {
        public String key;
        public T value;
        private T defaultValue;
        public String comment;

        public ConfigElement(Config this$0, String key, T defaultValue) {
            this(this$0, key, defaultValue, null);
        }

        public ConfigElement(Config this$0, String key, T defaultValue, String comment) {
            this.key = key;
            this.value = defaultValue;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public abstract void setValue(String var1);
    }
}

