/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.inventory;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.crafting.ShapelessCraftingInput;
import com.blakebr0.cucumber.inventory.CanExtractFunction;
import com.blakebr0.cucumber.inventory.CanInsertFunction;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.RecipeInventory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class BaseItemStackHandler
extends ItemStackHandler {
    private static final Codec<ItemStack> ITEM_STACK_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)builder, ItemStack::new)));
    private final OnContentsChangedFunction onContentsChanged;
    private final Map<Integer, Integer> slotSizeMap;
    private CanInsertFunction canInsert = null;
    private CanExtractFunction canExtract = null;
    private int maxStackSize = 64;
    private int[] outputSlots = null;

    protected BaseItemStackHandler(int size, OnContentsChangedFunction onContentsChanged) {
        super(size);
        this.onContentsChanged = onContentsChanged;
        this.slotSizeMap = new HashMap<Integer, Integer>();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.insertItem(slot, stack, simulate, false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, boolean container) {
        if (!container && this.outputSlots != null && ArrayUtils.contains((int[])this.outputSlots, (int)slot)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.extractItem(slot, amount, simulate, false);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean container) {
        if (!container) {
            if (this.canExtract != null && !this.canExtract.apply(slot)) {
                return ItemStack.EMPTY;
            }
            if (this.outputSlots != null && !ArrayUtils.contains((int[])this.outputSlots, (int)slot)) {
                return ItemStack.EMPTY;
            }
        }
        return super.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.slotSizeMap.containsKey(slot) ? this.slotSizeMap.get(slot) : this.maxStackSize;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.canInsert == null || this.canInsert.apply(slot, stack);
    }

    protected void onContentsChanged(int slot) {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.apply(slot);
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider lookup) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag item = new CompoundTag();
            item.putInt("Slot", i);
            items.add((Object)DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)stack, ITEM_STACK_CODEC, (HolderLookup.Provider)lookup, (Tag)item));
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)items);
        nbt.putInt("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider lookup, CompoundTag nbt) {
        int size = nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stacks.size();
        this.setSize(Math.max(size, this.stacks.size()));
        ListTag items = nbt.getList("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.getCompound(i);
            int slot = item.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ITEM_STACK_CODEC.parse((DynamicOps)lookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)item).resultOrPartial(error -> Cucumber.LOGGER.error("Tried to load invalid item: '{}'", error)).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public int[] getOutputSlots() {
        return this.outputSlots;
    }

    public void setDefaultSlotLimit(int size) {
        this.maxStackSize = size;
    }

    public void addSlotLimit(int slot, int size) {
        if (size > 64 && size % 64 != 0) {
            throw new IllegalArgumentException("Slot limits above 64 must be a multiple of 64");
        }
        this.slotSizeMap.put(slot, size);
    }

    public void setCanInsert(CanInsertFunction canInsert) {
        this.canInsert = canInsert;
    }

    public void setCanExtract(CanExtractFunction canExtract) {
        this.canExtract = canExtract;
    }

    public void setOutputSlots(int ... slots) {
        this.outputSlots = slots;
    }

    public RecipeInventory toRecipeInventory() {
        return this.toRecipeInventory(0, this.stacks.size());
    }

    public RecipeInventory toRecipeInventory(int start, int size) {
        return new RecipeInventory((IItemHandlerModifiable)this, start, size);
    }

    public CraftingInput toCraftingInput(int width, int height) {
        return CraftingInput.of((int)width, (int)height, (List)this.stacks);
    }

    public CraftingInput toShapelessCraftingInput() {
        return new ShapelessCraftingInput((List<ItemStack>)this.stacks);
    }

    public CraftingInput toCraftingInput(int width, int height, int startIndex, int endIndex) {
        return CraftingInput.of((int)width, (int)height, (List)this.stacks.subList(startIndex, endIndex));
    }

    public CraftingInput toShapelessCraftingInput(int startIndex, int endIndex) {
        return new ShapelessCraftingInput(this.stacks.subList(startIndex, endIndex));
    }

    public BaseItemStackHandler copy() {
        BaseItemStackHandler newInventory = new BaseItemStackHandler(this.getSlots(), this.onContentsChanged);
        newInventory.setDefaultSlotLimit(this.maxStackSize);
        newInventory.setCanInsert(this.canInsert);
        newInventory.setCanExtract(this.canExtract);
        newInventory.setOutputSlots(this.outputSlots);
        this.slotSizeMap.forEach(newInventory::addSlotLimit);
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            newInventory.setStackInSlot(i, stack.copy());
        }
        return newInventory;
    }

    public static BaseItemStackHandler create(int size) {
        return BaseItemStackHandler.create(size, builder -> {});
    }

    public static BaseItemStackHandler create(int size, Consumer<BaseItemStackHandler> builder) {
        return BaseItemStackHandler.create(size, null, builder);
    }

    public static BaseItemStackHandler create(int size, OnContentsChangedFunction onContentsChanged, Consumer<BaseItemStackHandler> builder) {
        BaseItemStackHandler handler = new BaseItemStackHandler(size, onContentsChanged);
        builder.accept(handler);
        return handler;
    }
}

