/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;

public class EntityTickList {
    private Int2ObjectMap<Entity> active = new Int2ObjectLinkedOpenHashMap();
    private Int2ObjectMap<Entity> passive = new Int2ObjectLinkedOpenHashMap();
    @Nullable
    private Int2ObjectMap<Entity> iterated;

    private void ensureActiveIsNotIterated() {
        if (this.iterated == this.active) {
            this.passive.clear();
            for (Int2ObjectMap.Entry $$0 : Int2ObjectMaps.fastIterable(this.active)) {
                this.passive.put($$0.getIntKey(), (Object)((Entity)$$0.getValue()));
            }
            Int2ObjectMap<Entity> $$1 = this.active;
            this.active = this.passive;
            this.passive = $$1;
        }
    }

    public void add(Entity p_156909_) {
        this.ensureActiveIsNotIterated();
        this.active.put(p_156909_.getId(), (Object)p_156909_);
    }

    public void remove(Entity p_156913_) {
        this.ensureActiveIsNotIterated();
        this.active.remove(p_156913_.getId());
    }

    public boolean contains(Entity p_156915_) {
        return this.active.containsKey(p_156915_.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<Entity> p_156911_) {
        if (this.iterated != null) {
            throw new UnsupportedOperationException("Only one concurrent iteration supported");
        }
        this.iterated = this.active;
        try {
            for (Entity $$1 : this.active.values()) {
                p_156911_.accept($$1);
            }
        }
        finally {
            this.iterated = null;
        }
    }
}

