/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ConcretePowderBlock
extends FallingBlock {
    public static final MapCodec<ConcretePowderBlock> CODEC = RecordCodecBuilder.mapCodec(p_344654_ -> p_344654_.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("concrete").forGetter(p_304618_ -> p_304618_.concrete), ConcretePowderBlock.propertiesCodec()).apply((Applicative)p_344654_, ConcretePowderBlock::new));
    private final Block concrete;

    public MapCodec<ConcretePowderBlock> codec() {
        return CODEC;
    }

    public ConcretePowderBlock(Block p_52060_, BlockBehaviour.Properties p_52061_) {
        super(p_52061_);
        this.concrete = p_52060_;
    }

    @Override
    public void onLand(Level p_52068_, BlockPos p_52069_, BlockState p_52070_, BlockState p_52071_, FallingBlockEntity p_52072_) {
        if (ConcretePowderBlock.shouldSolidify(p_52068_, p_52069_, p_52071_)) {
            p_52068_.setBlock(p_52069_, this.concrete.defaultBlockState(), 3);
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_52063_) {
        BlockState $$3;
        BlockPos $$2;
        Level $$1 = p_52063_.getLevel();
        if (ConcretePowderBlock.shouldSolidify($$1, $$2 = p_52063_.getClickedPos(), $$3 = $$1.getBlockState($$2))) {
            return this.concrete.defaultBlockState();
        }
        return super.getStateForPlacement(p_52063_);
    }

    private static boolean shouldSolidify(BlockGetter p_52081_, BlockPos p_52082_, BlockState p_52083_) {
        return ConcretePowderBlock.canSolidify(p_52083_) || ConcretePowderBlock.touchesLiquid(p_52081_, p_52082_);
    }

    private static boolean touchesLiquid(BlockGetter p_52065_, BlockPos p_52066_) {
        boolean $$2 = false;
        BlockPos.MutableBlockPos $$3 = p_52066_.mutable();
        for (Direction $$4 : Direction.values()) {
            BlockState $$5 = p_52065_.getBlockState($$3);
            if ($$4 == Direction.DOWN && !ConcretePowderBlock.canSolidify($$5)) continue;
            $$3.setWithOffset((Vec3i)p_52066_, $$4);
            $$5 = p_52065_.getBlockState($$3);
            if (!ConcretePowderBlock.canSolidify($$5) || $$5.isFaceSturdy(p_52065_, p_52066_, $$4.getOpposite())) continue;
            $$2 = true;
            break;
        }
        return $$2;
    }

    private static boolean canSolidify(BlockState p_52089_) {
        return p_52089_.getFluidState().is(FluidTags.WATER);
    }

    @Override
    protected BlockState updateShape(BlockState p_52074_, Direction p_52075_, BlockState p_52076_, LevelAccessor p_52077_, BlockPos p_52078_, BlockPos p_52079_) {
        if (ConcretePowderBlock.touchesLiquid(p_52077_, p_52078_)) {
            return this.concrete.defaultBlockState();
        }
        return super.updateShape(p_52074_, p_52075_, p_52076_, p_52077_, p_52078_, p_52079_);
    }

    @Override
    public int getDustColor(BlockState p_52085_, BlockGetter p_52086_, BlockPos p_52087_) {
        return p_52085_.getMapColor((BlockGetter)p_52086_, (BlockPos)p_52087_).col;
    }
}

