/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public abstract class BaseSpawner {
    public static final String SPAWN_DATA_TAG = "SpawnData";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int EVENT_SPAWN = 1;
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.empty();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(EntityType<?> p_253682_, @Nullable Level p_254041_, RandomSource p_254221_, BlockPos p_254050_) {
        this.getOrCreateNextSpawnData(p_254041_, p_254221_, p_254050_).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(p_253682_).toString());
    }

    private boolean isNearPlayer(Level p_151344_, BlockPos p_151345_) {
        return p_151344_.hasNearbyAlivePlayer((double)p_151345_.getX() + 0.5, (double)p_151345_.getY() + 0.5, (double)p_151345_.getZ() + 0.5, this.requiredPlayerRange);
    }

    public void clientTick(Level p_151320_, BlockPos p_151321_) {
        if (!this.isNearPlayer(p_151320_, p_151321_)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource $$2 = p_151320_.getRandom();
            double $$3 = (double)p_151321_.getX() + $$2.nextDouble();
            double $$4 = (double)p_151321_.getY() + $$2.nextDouble();
            double $$5 = (double)p_151321_.getZ() + $$2.nextDouble();
            p_151320_.addParticle(ParticleTypes.SMOKE, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            p_151320_.addParticle(ParticleTypes.FLAME, $$3, $$4, $$5, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel p_151312_, BlockPos p_151313_) {
        if (!this.isNearPlayer(p_151312_, p_151313_)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.delay(p_151312_, p_151313_);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean $$2 = false;
        RandomSource $$3 = p_151312_.getRandom();
        SpawnData $$4 = this.getOrCreateNextSpawnData(p_151312_, $$3, p_151313_);
        for (int $$5 = 0; $$5 < this.spawnCount; ++$$5) {
            SpawnData.CustomSpawnRules $$14;
            double $$12;
            CompoundTag $$6 = $$4.getEntityToSpawn();
            Optional<EntityType<?>> $$7 = EntityType.by($$6);
            if ($$7.isEmpty()) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            ListTag $$8 = $$6.getList("Pos", 6);
            int $$9 = $$8.size();
            double $$10 = $$9 >= 1 ? $$8.getDouble(0) : (double)p_151313_.getX() + ($$3.nextDouble() - $$3.nextDouble()) * (double)this.spawnRange + 0.5;
            double $$11 = $$9 >= 2 ? $$8.getDouble(1) : (double)(p_151313_.getY() + $$3.nextInt(3) - 1);
            double d = $$12 = $$9 >= 3 ? $$8.getDouble(2) : (double)p_151313_.getZ() + ($$3.nextDouble() - $$3.nextDouble()) * (double)this.spawnRange + 0.5;
            if (!p_151312_.noCollision($$7.get().getSpawnAABB($$10, $$11, $$12))) continue;
            BlockPos $$13 = BlockPos.containing($$10, $$11, $$12);
            if (!$$4.getCustomSpawnRules().isPresent() ? !SpawnPlacements.checkSpawnRules($$7.get(), p_151312_, MobSpawnType.SPAWNER, $$13, p_151312_.getRandom()) : !$$7.get().getCategory().isFriendly() && p_151312_.getDifficulty() == Difficulty.PEACEFUL || !($$14 = $$4.getCustomSpawnRules().get()).isValidPosition($$13, p_151312_)) continue;
            Entity $$15 = EntityType.loadEntityRecursive($$6, p_151312_, p_151310_ -> {
                p_151310_.moveTo($$10, $$11, $$12, p_151310_.getYRot(), p_151310_.getXRot());
                return p_151310_;
            });
            if ($$15 == null) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            int $$16 = p_151312_.getEntities(EntityTypeTest.forExactClass($$15.getClass()), new AABB(p_151313_.getX(), p_151313_.getY(), p_151313_.getZ(), p_151313_.getX() + 1, p_151313_.getY() + 1, p_151313_.getZ() + 1).inflate(this.spawnRange), EntitySelector.NO_SPECTATORS).size();
            if ($$16 >= this.maxNearbyEntities) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            $$15.moveTo($$15.getX(), $$15.getY(), $$15.getZ(), $$3.nextFloat() * 360.0f, 0.0f);
            if ($$15 instanceof Mob) {
                boolean $$18;
                Mob $$17 = (Mob)$$15;
                if ($$4.getCustomSpawnRules().isEmpty() && !$$17.checkSpawnRules(p_151312_, MobSpawnType.SPAWNER) || !$$17.checkSpawnObstruction(p_151312_)) continue;
                boolean bl = $$18 = $$4.getEntityToSpawn().size() == 1 && $$4.getEntityToSpawn().contains("id", 8);
                if ($$18) {
                    ((Mob)$$15).finalizeSpawn(p_151312_, p_151312_.getCurrentDifficultyAt($$15.blockPosition()), MobSpawnType.SPAWNER, null);
                }
                $$4.getEquipment().ifPresent($$17::equip);
            }
            if (!p_151312_.tryAddFreshEntityWithPassengers($$15)) {
                this.delay(p_151312_, p_151313_);
                return;
            }
            p_151312_.levelEvent(2004, p_151313_, 0);
            p_151312_.gameEvent($$15, GameEvent.ENTITY_PLACE, $$13);
            if ($$15 instanceof Mob) {
                ((Mob)$$15).spawnAnim();
            }
            $$2 = true;
        }
        if ($$2) {
            this.delay(p_151312_, p_151313_);
        }
    }

    private void delay(Level p_151351_, BlockPos p_151352_) {
        RandomSource $$2 = p_151351_.random;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + $$2.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.getRandom($$2).ifPresent(p_337965_ -> this.setNextSpawnData(p_151351_, p_151352_, (SpawnData)p_337965_.data()));
        this.broadcastEvent(p_151351_, p_151352_, 1);
    }

    public void load(@Nullable Level p_151329_, BlockPos p_151330_, CompoundTag p_151331_) {
        boolean $$5;
        this.spawnDelay = p_151331_.getShort("Delay");
        boolean $$3 = p_151331_.contains(SPAWN_DATA_TAG, 10);
        if ($$3) {
            SpawnData $$4 = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_151331_.getCompound(SPAWN_DATA_TAG)).resultOrPartial(p_186391_ -> LOGGER.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new);
            this.setNextSpawnData(p_151329_, p_151330_, $$4);
        }
        if ($$5 = p_151331_.contains("SpawnPotentials", 9)) {
            ListTag $$6 = p_151331_.getList("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$6).resultOrPartial(p_186388_ -> LOGGER.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::empty);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.single(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData());
        }
        if (p_151331_.contains("MinSpawnDelay", 99)) {
            this.minSpawnDelay = p_151331_.getShort("MinSpawnDelay");
            this.maxSpawnDelay = p_151331_.getShort("MaxSpawnDelay");
            this.spawnCount = p_151331_.getShort("SpawnCount");
        }
        if (p_151331_.contains("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = p_151331_.getShort("MaxNearbyEntities");
            this.requiredPlayerRange = p_151331_.getShort("RequiredPlayerRange");
        }
        if (p_151331_.contains("SpawnRange", 99)) {
            this.spawnRange = p_151331_.getShort("SpawnRange");
        }
        this.displayEntity = null;
    }

    public CompoundTag save(CompoundTag p_186382_) {
        p_186382_.putShort("Delay", (short)this.spawnDelay);
        p_186382_.putShort("MinSpawnDelay", (short)this.minSpawnDelay);
        p_186382_.putShort("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_186382_.putShort("SpawnCount", (short)this.spawnCount);
        p_186382_.putShort("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_186382_.putShort("RequiredPlayerRange", (short)this.requiredPlayerRange);
        p_186382_.putShort("SpawnRange", (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            p_186382_.put(SPAWN_DATA_TAG, (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawnData).getOrThrow(p_337966_ -> new IllegalStateException("Invalid SpawnData: " + p_337966_)));
        }
        p_186382_.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.spawnPotentials).getOrThrow());
        return p_186382_;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level p_254323_, BlockPos p_254313_) {
        if (this.displayEntity == null) {
            CompoundTag $$2 = this.getOrCreateNextSpawnData(p_254323_, p_254323_.getRandom(), p_254313_).getEntityToSpawn();
            if (!$$2.contains("id", 8)) {
                return null;
            }
            this.displayEntity = EntityType.loadEntityRecursive($$2, p_254323_, Function.identity());
            if ($$2.size() != 1 || this.displayEntity instanceof Mob) {
                // empty if block
            }
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(Level p_151317_, int p_151318_) {
        if (p_151318_ == 1) {
            if (p_151317_.isClientSide) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable Level p_151325_, BlockPos p_151326_, SpawnData p_151327_) {
        this.nextSpawnData = p_151327_;
    }

    private SpawnData getOrCreateNextSpawnData(@Nullable Level p_254503_, RandomSource p_253892_, BlockPos p_254487_) {
        if (this.nextSpawnData != null) {
            return this.nextSpawnData;
        }
        this.setNextSpawnData(p_254503_, p_254487_, this.spawnPotentials.getRandom(p_253892_).map(WeightedEntry.Wrapper::data).orElseGet(SpawnData::new));
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getoSpin() {
        return this.oSpin;
    }
}

