/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartCommandBlock;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractMinecart
extends VehicleEntity {
    private static final Vec3 LOWERED_PASSENGER_ATTACHMENT = new Vec3(0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_DISPLAY_OFFSET = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_ID_CUSTOM_DISPLAY = SynchedEntityData.defineId(AbstractMinecart.class, EntityDataSerializers.BOOLEAN);
    private static final ImmutableMap<Pose, ImmutableList<Integer>> POSE_DISMOUNT_HEIGHTS = ImmutableMap.of((Object)((Object)Pose.STANDING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.CROUCHING), (Object)ImmutableList.of((Object)0, (Object)1, (Object)-1), (Object)((Object)Pose.SWIMMING), (Object)ImmutableList.of((Object)0, (Object)1));
    protected static final float WATER_SLOWDOWN_FACTOR = 0.95f;
    private boolean flipped;
    private boolean onRails;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Vec3 targetDeltaMovement = Vec3.ZERO;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = Util.make(Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i $$1 = Direction.WEST.getNormal();
        Vec3i $$2 = Direction.EAST.getNormal();
        Vec3i $$3 = Direction.NORTH.getNormal();
        Vec3i $$4 = Direction.SOUTH.getNormal();
        Vec3i $$5 = $$1.below();
        Vec3i $$6 = $$2.below();
        Vec3i $$7 = $$3.below();
        Vec3i $$8 = $$4.below();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)$$3, (Object)$$4));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)$$1, (Object)$$2));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)$$5, (Object)$$2));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)$$1, (Object)$$6));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)$$3, (Object)$$8));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)$$7, (Object)$$4));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)$$4, (Object)$$2));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)$$4, (Object)$$1));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)$$3, (Object)$$1));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)$$3, (Object)$$2));
    });

    protected AbstractMinecart(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.blocksBuilding = true;
    }

    protected AbstractMinecart(EntityType<?> p_38090_, Level p_38091_, double p_38092_, double p_38093_, double p_38094_) {
        this(p_38090_, p_38091_);
        this.setPos(p_38092_, p_38093_, p_38094_);
        this.xo = p_38092_;
        this.yo = p_38093_;
        this.zo = p_38094_;
    }

    public static AbstractMinecart createMinecart(ServerLevel p_305794_, double p_38121_, double p_38122_, double p_38123_, Type p_38124_, ItemStack p_305892_, @Nullable Player p_306203_) {
        AbstractMinecart $$7 = switch (p_38124_.ordinal()) {
            case 1 -> new MinecartChest(p_305794_, p_38121_, p_38122_, p_38123_);
            case 2 -> new MinecartFurnace(p_305794_, p_38121_, p_38122_, p_38123_);
            case 3 -> new MinecartTNT(p_305794_, p_38121_, p_38122_, p_38123_);
            case 4 -> new MinecartSpawner(p_305794_, p_38121_, p_38122_, p_38123_);
            case 5 -> new MinecartHopper(p_305794_, p_38121_, p_38122_, p_38123_);
            case 6 -> new MinecartCommandBlock(p_305794_, p_38121_, p_38122_, p_38123_);
            default -> new Minecart(p_305794_, p_38121_, p_38122_, p_38123_);
        };
        EntityType.createDefaultStackConfig(p_305794_, p_305892_, p_306203_).accept((MinecartChest)$$7);
        return $$7;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326247_) {
        super.defineSynchedData(p_326247_);
        p_326247_.define(DATA_ID_DISPLAY_BLOCK, Block.getId(Blocks.AIR.defaultBlockState()));
        p_326247_.define(DATA_ID_DISPLAY_OFFSET, 6);
        p_326247_.define(DATA_ID_CUSTOM_DISPLAY, false);
    }

    @Override
    public boolean canCollideWith(Entity p_38168_) {
        return Boat.canVehicleCollide(this, p_38168_);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis p_38132_, BlockUtil.FoundRectangle p_38133_) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(p_38132_, p_38133_));
    }

    @Override
    protected Vec3 getPassengerAttachmentPoint(Entity p_294753_, EntityDimensions p_295251_, float p_296054_) {
        boolean $$3;
        boolean bl = $$3 = p_294753_ instanceof Villager || p_294753_ instanceof WanderingTrader;
        if ($$3) {
            return LOWERED_PASSENGER_ATTACHMENT;
        }
        return super.getPassengerAttachmentPoint(p_294753_, p_295251_, p_296054_);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity p_38145_) {
        Direction $$1 = this.getMotionDirection();
        if ($$1.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(p_38145_);
        }
        int[][] $$2 = DismountHelper.offsetsForDirection($$1);
        BlockPos $$3 = this.blockPosition();
        BlockPos.MutableBlockPos $$4 = new BlockPos.MutableBlockPos();
        ImmutableList<Pose> $$5 = p_38145_.getDismountPoses();
        for (Pose $$6 : $$5) {
            EntityDimensions $$7 = p_38145_.getDimensions($$6);
            float $$8 = Math.min($$7.width(), 1.0f) / 2.0f;
            UnmodifiableIterator unmodifiableIterator = ((ImmutableList)POSE_DISMOUNT_HEIGHTS.get((Object)$$6)).iterator();
            while (unmodifiableIterator.hasNext()) {
                int $$9 = (Integer)unmodifiableIterator.next();
                for (int[] $$10 : $$2) {
                    $$4.set($$3.getX() + $$10[0], $$3.getY() + $$9, $$3.getZ() + $$10[1]);
                    double $$11 = this.level().getBlockFloorHeight(DismountHelper.nonClimbableShape(this.level(), $$4), () -> DismountHelper.nonClimbableShape(this.level(), (BlockPos)$$4.below()));
                    if (!DismountHelper.isBlockFloorValid($$11)) continue;
                    AABB $$12 = new AABB(-$$8, 0.0, -$$8, $$8, $$7.height(), $$8);
                    Vec3 $$13 = Vec3.upFromBottomCenterOf($$4, $$11);
                    if (!DismountHelper.canDismountTo(this.level(), p_38145_, $$12.move($$13))) continue;
                    p_38145_.setPose($$6);
                    return $$13;
                }
            }
        }
        double $$14 = this.getBoundingBox().maxY;
        $$4.set((double)$$3.getX(), $$14, (double)$$3.getZ());
        for (Pose $$15 : $$5) {
            int $$17;
            double $$18;
            double $$16 = p_38145_.getDimensions($$15).height();
            if (!($$14 + $$16 <= ($$18 = DismountHelper.findCeilingFrom($$4, $$17 = Mth.ceil($$14 - (double)$$4.getY() + $$16), p_352844_ -> this.level().getBlockState((BlockPos)p_352844_).getCollisionShape(this.level(), (BlockPos)p_352844_))))) continue;
            p_38145_.setPose($$15);
            break;
        }
        return super.getDismountLocationForPassenger(p_38145_);
    }

    @Override
    protected float getBlockSpeedFactor() {
        BlockState $$0 = this.level().getBlockState(this.blockPosition());
        if ($$0.is(BlockTags.RAILS)) {
            return 1.0f;
        }
        return super.getBlockSpeedFactor();
    }

    @Override
    public void animateHurt(float p_265349_) {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    private static Pair<Vec3i, Vec3i> exits(RailShape p_38126_) {
        return EXITS.get(p_38126_);
    }

    @Override
    public Direction getMotionDirection() {
        return this.flipped ? this.getDirection().getOpposite().getClockWise() : this.getDirection().getClockWise();
    }

    @Override
    protected double getDefaultGravity() {
        return this.isInWater() ? 0.005 : 0.04;
    }

    @Override
    public void tick() {
        double $$7;
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.checkBelowWorld();
        this.handlePortal();
        if (this.level().isClientSide) {
            if (this.lerpSteps > 0) {
                this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
                --this.lerpSteps;
            } else {
                this.reapplyPosition();
                this.setRot(this.getYRot(), this.getXRot());
            }
            return;
        }
        this.applyGravity();
        int $$0 = Mth.floor(this.getX());
        int $$1 = Mth.floor(this.getY());
        int $$2 = Mth.floor(this.getZ());
        if (this.level().getBlockState(new BlockPos($$0, $$1 - 1, $$2)).is(BlockTags.RAILS)) {
            --$$1;
        }
        BlockPos $$3 = new BlockPos($$0, $$1, $$2);
        BlockState $$4 = this.level().getBlockState($$3);
        this.onRails = BaseRailBlock.isRail($$4);
        if (this.onRails) {
            this.moveAlongTrack($$3, $$4);
            if ($$4.is(Blocks.ACTIVATOR_RAIL)) {
                this.activateMinecart($$0, $$1, $$2, $$4.getValue(PoweredRailBlock.POWERED));
            }
        } else {
            this.comeOffTrack();
        }
        this.checkInsideBlocks();
        this.setXRot(0.0f);
        double $$5 = this.xo - this.getX();
        double $$6 = this.zo - this.getZ();
        if ($$5 * $$5 + $$6 * $$6 > 0.001) {
            this.setYRot((float)(Mth.atan2($$6, $$5) * 180.0 / Math.PI));
            if (this.flipped) {
                this.setYRot(this.getYRot() + 180.0f);
            }
        }
        if (($$7 = (double)Mth.wrapDegrees(this.getYRot() - this.yRotO)) < -170.0 || $$7 >= 170.0) {
            this.setYRot(this.getYRot() + 180.0f);
            this.flipped = !this.flipped;
        }
        this.setRot(this.getYRot(), this.getXRot());
        if (this.getMinecartType() == Type.RIDEABLE && this.getDeltaMovement().horizontalDistanceSqr() > 0.01) {
            List<Entity> $$8 = this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f), EntitySelector.pushableBy(this));
            if (!$$8.isEmpty()) {
                for (Entity $$9 : $$8) {
                    if ($$9 instanceof Player || $$9 instanceof IronGolem || $$9 instanceof AbstractMinecart || this.isVehicle() || $$9.isPassenger()) {
                        $$9.push(this);
                        continue;
                    }
                    $$9.startRiding(this);
                }
            }
        } else {
            for (Entity $$10 : this.level().getEntities(this, this.getBoundingBox().inflate(0.2f, 0.0, 0.2f))) {
                if (this.hasPassenger($$10) || !$$10.isPushable() || !($$10 instanceof AbstractMinecart)) continue;
                $$10.push(this);
            }
        }
        this.updateInWaterStateAndDoFluidPushing();
        if (this.isInLava()) {
            this.lavaHurt();
            this.fallDistance *= 0.5f;
        }
        this.firstTick = false;
    }

    protected double getMaxSpeed() {
        return (this.isInWater() ? 4.0 : 8.0) / 20.0;
    }

    public void activateMinecart(int p_38111_, int p_38112_, int p_38113_, boolean p_38114_) {
    }

    protected void comeOffTrack() {
        double $$0 = this.getMaxSpeed();
        Vec3 $$1 = this.getDeltaMovement();
        this.setDeltaMovement(Mth.clamp($$1.x, -$$0, $$0), $$1.y, Mth.clamp($$1.z, -$$0, $$0));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        }
    }

    protected void moveAlongTrack(BlockPos p_38156_, BlockState p_38157_) {
        double $$32;
        this.resetFallDistance();
        double $$2 = this.getX();
        double $$3 = this.getY();
        double $$4 = this.getZ();
        Vec3 $$5 = this.getPos($$2, $$3, $$4);
        $$3 = p_38156_.getY();
        boolean $$6 = false;
        boolean $$7 = false;
        if (p_38157_.is(Blocks.POWERED_RAIL)) {
            $$6 = p_38157_.getValue(PoweredRailBlock.POWERED);
            $$7 = !$$6;
        }
        double $$8 = 0.0078125;
        if (this.isInWater()) {
            $$8 *= 0.2;
        }
        Vec3 $$9 = this.getDeltaMovement();
        RailShape $$10 = p_38157_.getValue(((BaseRailBlock)p_38157_.getBlock()).getShapeProperty());
        switch ($$10) {
            case ASCENDING_EAST: {
                this.setDeltaMovement($$9.add(-$$8, 0.0, 0.0));
                $$3 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.setDeltaMovement($$9.add($$8, 0.0, 0.0));
                $$3 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.setDeltaMovement($$9.add(0.0, 0.0, $$8));
                $$3 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.setDeltaMovement($$9.add(0.0, 0.0, -$$8));
                $$3 += 1.0;
            }
        }
        $$9 = this.getDeltaMovement();
        Pair<Vec3i, Vec3i> $$11 = AbstractMinecart.exits($$10);
        Vec3i $$12 = (Vec3i)$$11.getFirst();
        Vec3i $$13 = (Vec3i)$$11.getSecond();
        double $$14 = $$13.getX() - $$12.getX();
        double $$15 = $$13.getZ() - $$12.getZ();
        double $$16 = Math.sqrt($$14 * $$14 + $$15 * $$15);
        double $$17 = $$9.x * $$14 + $$9.z * $$15;
        if ($$17 < 0.0) {
            $$14 = -$$14;
            $$15 = -$$15;
        }
        double $$18 = Math.min(2.0, $$9.horizontalDistance());
        $$9 = new Vec3($$18 * $$14 / $$16, $$9.y, $$18 * $$15 / $$16);
        this.setDeltaMovement($$9);
        Entity $$19 = this.getFirstPassenger();
        if ($$19 instanceof Player) {
            Vec3 $$20 = $$19.getDeltaMovement();
            double $$21 = $$20.horizontalDistanceSqr();
            double $$22 = this.getDeltaMovement().horizontalDistanceSqr();
            if ($$21 > 1.0E-4 && $$22 < 0.01) {
                this.setDeltaMovement(this.getDeltaMovement().add($$20.x * 0.1, 0.0, $$20.z * 0.1));
                $$7 = false;
            }
        }
        if ($$7) {
            double $$23 = this.getDeltaMovement().horizontalDistance();
            if ($$23 < 0.03) {
                this.setDeltaMovement(Vec3.ZERO);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.0, 0.5));
            }
        }
        double $$24 = (double)p_38156_.getX() + 0.5 + (double)$$12.getX() * 0.5;
        double $$25 = (double)p_38156_.getZ() + 0.5 + (double)$$12.getZ() * 0.5;
        double $$26 = (double)p_38156_.getX() + 0.5 + (double)$$13.getX() * 0.5;
        double $$27 = (double)p_38156_.getZ() + 0.5 + (double)$$13.getZ() * 0.5;
        $$14 = $$26 - $$24;
        $$15 = $$27 - $$25;
        if ($$14 == 0.0) {
            double $$28 = $$4 - (double)p_38156_.getZ();
        } else if ($$15 == 0.0) {
            double $$29 = $$2 - (double)p_38156_.getX();
        } else {
            double $$30 = $$2 - $$24;
            double $$31 = $$4 - $$25;
            $$32 = ($$30 * $$14 + $$31 * $$15) * 2.0;
        }
        $$2 = $$24 + $$14 * $$32;
        $$4 = $$25 + $$15 * $$32;
        this.setPos($$2, $$3, $$4);
        double $$33 = this.isVehicle() ? 0.75 : 1.0;
        double $$34 = this.getMaxSpeed();
        $$9 = this.getDeltaMovement();
        this.move(MoverType.SELF, new Vec3(Mth.clamp($$33 * $$9.x, -$$34, $$34), 0.0, Mth.clamp($$33 * $$9.z, -$$34, $$34)));
        if ($$12.getY() != 0 && Mth.floor(this.getX()) - p_38156_.getX() == $$12.getX() && Mth.floor(this.getZ()) - p_38156_.getZ() == $$12.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)$$12.getY(), this.getZ());
        } else if ($$13.getY() != 0 && Mth.floor(this.getX()) - p_38156_.getX() == $$13.getX() && Mth.floor(this.getZ()) - p_38156_.getZ() == $$13.getZ()) {
            this.setPos(this.getX(), this.getY() + (double)$$13.getY(), this.getZ());
        }
        this.applyNaturalSlowdown();
        Vec3 $$35 = this.getPos(this.getX(), this.getY(), this.getZ());
        if ($$35 != null && $$5 != null) {
            double $$36 = ($$5.y - $$35.y) * 0.05;
            Vec3 $$37 = this.getDeltaMovement();
            double $$38 = $$37.horizontalDistance();
            if ($$38 > 0.0) {
                this.setDeltaMovement($$37.multiply(($$38 + $$36) / $$38, 1.0, ($$38 + $$36) / $$38));
            }
            this.setPos(this.getX(), $$35.y, this.getZ());
        }
        int $$39 = Mth.floor(this.getX());
        int $$40 = Mth.floor(this.getZ());
        if ($$39 != p_38156_.getX() || $$40 != p_38156_.getZ()) {
            Vec3 $$41 = this.getDeltaMovement();
            double $$42 = $$41.horizontalDistance();
            this.setDeltaMovement($$42 * (double)($$39 - p_38156_.getX()), $$41.y, $$42 * (double)($$40 - p_38156_.getZ()));
        }
        if ($$6) {
            Vec3 $$43 = this.getDeltaMovement();
            double $$44 = $$43.horizontalDistance();
            if ($$44 > 0.01) {
                double $$45 = 0.06;
                this.setDeltaMovement($$43.add($$43.x / $$44 * 0.06, 0.0, $$43.z / $$44 * 0.06));
            } else {
                Vec3 $$46 = this.getDeltaMovement();
                double $$47 = $$46.x;
                double $$48 = $$46.z;
                if ($$10 == RailShape.EAST_WEST) {
                    if (this.isRedstoneConductor(p_38156_.west())) {
                        $$47 = 0.02;
                    } else if (this.isRedstoneConductor(p_38156_.east())) {
                        $$47 = -0.02;
                    }
                } else if ($$10 == RailShape.NORTH_SOUTH) {
                    if (this.isRedstoneConductor(p_38156_.north())) {
                        $$48 = 0.02;
                    } else if (this.isRedstoneConductor(p_38156_.south())) {
                        $$48 = -0.02;
                    }
                } else {
                    return;
                }
                this.setDeltaMovement($$47, $$46.y, $$48);
            }
        }
    }

    @Override
    public boolean isOnRails() {
        return this.onRails;
    }

    private boolean isRedstoneConductor(BlockPos p_38130_) {
        return this.level().getBlockState(p_38130_).isRedstoneConductor(this.level(), p_38130_);
    }

    protected void applyNaturalSlowdown() {
        double $$0 = this.isVehicle() ? 0.997 : 0.96;
        Vec3 $$1 = this.getDeltaMovement();
        $$1 = $$1.multiply($$0, 0.0, $$0);
        if (this.isInWater()) {
            $$1 = $$1.scale(0.95f);
        }
        this.setDeltaMovement($$1);
    }

    @Nullable
    public Vec3 getPosOffs(double p_38097_, double p_38098_, double p_38099_, double p_38100_) {
        BlockState $$7;
        int $$4 = Mth.floor(p_38097_);
        int $$5 = Mth.floor(p_38098_);
        int $$6 = Mth.floor(p_38099_);
        if (this.level().getBlockState(new BlockPos($$4, $$5 - 1, $$6)).is(BlockTags.RAILS)) {
            --$$5;
        }
        if (BaseRailBlock.isRail($$7 = this.level().getBlockState(new BlockPos($$4, $$5, $$6)))) {
            RailShape $$8 = $$7.getValue(((BaseRailBlock)$$7.getBlock()).getShapeProperty());
            p_38098_ = $$5;
            if ($$8.isAscending()) {
                p_38098_ = $$5 + 1;
            }
            Pair<Vec3i, Vec3i> $$9 = AbstractMinecart.exits($$8);
            Vec3i $$10 = (Vec3i)$$9.getFirst();
            Vec3i $$11 = (Vec3i)$$9.getSecond();
            double $$12 = $$11.getX() - $$10.getX();
            double $$13 = $$11.getZ() - $$10.getZ();
            double $$14 = Math.sqrt($$12 * $$12 + $$13 * $$13);
            if ($$10.getY() != 0 && Mth.floor(p_38097_ += ($$12 /= $$14) * p_38100_) - $$4 == $$10.getX() && Mth.floor(p_38099_ += ($$13 /= $$14) * p_38100_) - $$6 == $$10.getZ()) {
                p_38098_ += (double)$$10.getY();
            } else if ($$11.getY() != 0 && Mth.floor(p_38097_) - $$4 == $$11.getX() && Mth.floor(p_38099_) - $$6 == $$11.getZ()) {
                p_38098_ += (double)$$11.getY();
            }
            return this.getPos(p_38097_, p_38098_, p_38099_);
        }
        return null;
    }

    @Nullable
    public Vec3 getPos(double p_38180_, double p_38181_, double p_38182_) {
        BlockState $$6;
        int $$3 = Mth.floor(p_38180_);
        int $$4 = Mth.floor(p_38181_);
        int $$5 = Mth.floor(p_38182_);
        if (this.level().getBlockState(new BlockPos($$3, $$4 - 1, $$5)).is(BlockTags.RAILS)) {
            --$$4;
        }
        if (BaseRailBlock.isRail($$6 = this.level().getBlockState(new BlockPos($$3, $$4, $$5)))) {
            double $$24;
            RailShape $$7 = $$6.getValue(((BaseRailBlock)$$6.getBlock()).getShapeProperty());
            Pair<Vec3i, Vec3i> $$8 = AbstractMinecart.exits($$7);
            Vec3i $$9 = (Vec3i)$$8.getFirst();
            Vec3i $$10 = (Vec3i)$$8.getSecond();
            double $$11 = (double)$$3 + 0.5 + (double)$$9.getX() * 0.5;
            double $$12 = (double)$$4 + 0.0625 + (double)$$9.getY() * 0.5;
            double $$13 = (double)$$5 + 0.5 + (double)$$9.getZ() * 0.5;
            double $$14 = (double)$$3 + 0.5 + (double)$$10.getX() * 0.5;
            double $$15 = (double)$$4 + 0.0625 + (double)$$10.getY() * 0.5;
            double $$16 = (double)$$5 + 0.5 + (double)$$10.getZ() * 0.5;
            double $$17 = $$14 - $$11;
            double $$18 = ($$15 - $$12) * 2.0;
            double $$19 = $$16 - $$13;
            if ($$17 == 0.0) {
                double $$20 = p_38182_ - (double)$$5;
            } else if ($$19 == 0.0) {
                double $$21 = p_38180_ - (double)$$3;
            } else {
                double $$22 = p_38180_ - $$11;
                double $$23 = p_38182_ - $$13;
                $$24 = ($$22 * $$17 + $$23 * $$19) * 2.0;
            }
            p_38180_ = $$11 + $$17 * $$24;
            p_38181_ = $$12 + $$18 * $$24;
            p_38182_ = $$13 + $$19 * $$24;
            if ($$18 < 0.0) {
                p_38181_ += 1.0;
            } else if ($$18 > 0.0) {
                p_38181_ += 0.5;
            }
            return new Vec3(p_38180_, p_38181_, p_38182_);
        }
        return null;
    }

    @Override
    public AABB getBoundingBoxForCulling() {
        AABB $$0 = this.getBoundingBox();
        if (this.hasCustomDisplay()) {
            return $$0.inflate((double)Math.abs(this.getDisplayOffset()) / 16.0);
        }
        return $$0;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag p_38137_) {
        if (p_38137_.getBoolean("CustomDisplayTile")) {
            this.setDisplayBlockState(NbtUtils.readBlockState(this.level().holderLookup(Registries.BLOCK), p_38137_.getCompound("DisplayState")));
            this.setDisplayOffset(p_38137_.getInt("DisplayOffset"));
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag p_38151_) {
        if (this.hasCustomDisplay()) {
            p_38151_.putBoolean("CustomDisplayTile", true);
            p_38151_.put("DisplayState", NbtUtils.writeBlockState(this.getDisplayBlockState()));
            p_38151_.putInt("DisplayOffset", this.getDisplayOffset());
        }
    }

    @Override
    public void push(Entity p_38165_) {
        double $$2;
        if (this.level().isClientSide) {
            return;
        }
        if (p_38165_.noPhysics || this.noPhysics) {
            return;
        }
        if (this.hasPassenger(p_38165_)) {
            return;
        }
        double $$1 = p_38165_.getX() - this.getX();
        double $$3 = $$1 * $$1 + ($$2 = p_38165_.getZ() - this.getZ()) * $$2;
        if ($$3 >= (double)1.0E-4f) {
            $$3 = Math.sqrt($$3);
            $$1 /= $$3;
            $$2 /= $$3;
            double $$4 = 1.0 / $$3;
            if ($$4 > 1.0) {
                $$4 = 1.0;
            }
            $$1 *= $$4;
            $$2 *= $$4;
            $$1 *= (double)0.1f;
            $$2 *= (double)0.1f;
            $$1 *= 0.5;
            $$2 *= 0.5;
            if (p_38165_ instanceof AbstractMinecart) {
                Vec3 $$8;
                double $$6;
                double $$5 = p_38165_.getX() - this.getX();
                Vec3 $$7 = new Vec3($$5, 0.0, $$6 = p_38165_.getZ() - this.getZ()).normalize();
                double $$9 = Math.abs($$7.dot($$8 = new Vec3(Mth.cos(this.getYRot() * ((float)Math.PI / 180)), 0.0, Mth.sin(this.getYRot() * ((float)Math.PI / 180))).normalize()));
                if ($$9 < (double)0.8f) {
                    return;
                }
                Vec3 $$10 = this.getDeltaMovement();
                Vec3 $$11 = p_38165_.getDeltaMovement();
                if (((AbstractMinecart)p_38165_).getMinecartType() == Type.FURNACE && this.getMinecartType() != Type.FURNACE) {
                    this.setDeltaMovement($$10.multiply(0.2, 1.0, 0.2));
                    this.push($$11.x - $$1, 0.0, $$11.z - $$2);
                    p_38165_.setDeltaMovement($$11.multiply(0.95, 1.0, 0.95));
                } else if (((AbstractMinecart)p_38165_).getMinecartType() != Type.FURNACE && this.getMinecartType() == Type.FURNACE) {
                    p_38165_.setDeltaMovement($$11.multiply(0.2, 1.0, 0.2));
                    p_38165_.push($$10.x + $$1, 0.0, $$10.z + $$2);
                    this.setDeltaMovement($$10.multiply(0.95, 1.0, 0.95));
                } else {
                    double $$12 = ($$11.x + $$10.x) / 2.0;
                    double $$13 = ($$11.z + $$10.z) / 2.0;
                    this.setDeltaMovement($$10.multiply(0.2, 1.0, 0.2));
                    this.push($$12 - $$1, 0.0, $$13 - $$2);
                    p_38165_.setDeltaMovement($$11.multiply(0.2, 1.0, 0.2));
                    p_38165_.push($$12 + $$1, 0.0, $$13 + $$2);
                }
            } else {
                this.push(-$$1, 0.0, -$$2);
                p_38165_.push($$1 / 4.0, 0.0, $$2 / 4.0);
            }
        }
    }

    @Override
    public void lerpTo(double p_38102_, double p_38103_, double p_38104_, float p_38105_, float p_38106_, int p_38107_) {
        this.lerpX = p_38102_;
        this.lerpY = p_38103_;
        this.lerpZ = p_38104_;
        this.lerpYRot = p_38105_;
        this.lerpXRot = p_38106_;
        this.lerpSteps = p_38107_ + 2;
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    @Override
    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    @Override
    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    @Override
    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    @Override
    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    @Override
    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @Override
    public void lerpMotion(double p_38171_, double p_38172_, double p_38173_) {
        this.targetDeltaMovement = new Vec3(p_38171_, p_38172_, p_38173_);
        this.setDeltaMovement(this.targetDeltaMovement);
    }

    public abstract Type getMinecartType();

    public BlockState getDisplayBlockState() {
        if (!this.hasCustomDisplay()) {
            return this.getDefaultDisplayBlockState();
        }
        return Block.stateById(this.getEntityData().get(DATA_ID_DISPLAY_BLOCK));
    }

    public BlockState getDefaultDisplayBlockState() {
        return Blocks.AIR.defaultBlockState();
    }

    public int getDisplayOffset() {
        if (!this.hasCustomDisplay()) {
            return this.getDefaultDisplayOffset();
        }
        return this.getEntityData().get(DATA_ID_DISPLAY_OFFSET);
    }

    public int getDefaultDisplayOffset() {
        return 6;
    }

    public void setDisplayBlockState(BlockState p_38147_) {
        this.getEntityData().set(DATA_ID_DISPLAY_BLOCK, Block.getId(p_38147_));
        this.setCustomDisplay(true);
    }

    public void setDisplayOffset(int p_38175_) {
        this.getEntityData().set(DATA_ID_DISPLAY_OFFSET, p_38175_);
        this.setCustomDisplay(true);
    }

    public boolean hasCustomDisplay() {
        return this.getEntityData().get(DATA_ID_CUSTOM_DISPLAY);
    }

    public void setCustomDisplay(boolean p_38139_) {
        this.getEntityData().set(DATA_ID_CUSTOM_DISPLAY, p_38139_);
    }

    @Override
    public ItemStack getPickResult() {
        Item $$5;
        switch (this.getMinecartType().ordinal()) {
            case 2: {
                Item $$0 = Items.FURNACE_MINECART;
                break;
            }
            case 1: {
                Item $$1 = Items.CHEST_MINECART;
                break;
            }
            case 3: {
                Item $$2 = Items.TNT_MINECART;
                break;
            }
            case 5: {
                Item $$3 = Items.HOPPER_MINECART;
                break;
            }
            case 6: {
                Item $$4 = Items.COMMAND_BLOCK_MINECART;
                break;
            }
            default: {
                $$5 = Items.MINECART;
            }
        }
        return new ItemStack($$5);
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

