/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class ThrowableProjectile
extends Projectile {
    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super((EntityType<? extends Projectile>)p_37466_, p_37467_);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> p_37456_, double p_37457_, double p_37458_, double p_37459_, Level p_37460_) {
        this(p_37456_, p_37460_);
        this.setPos(p_37457_, p_37458_, p_37459_);
    }

    protected ThrowableProjectile(EntityType<? extends ThrowableProjectile> p_37462_, LivingEntity p_37463_, Level p_37464_) {
        this(p_37462_, p_37463_.getX(), p_37463_.getEyeY() - (double)0.1f, p_37463_.getZ(), p_37464_);
        this.setOwner(p_37463_);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double p_37470_) {
        double $$1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN($$1)) {
            $$1 = 4.0;
        }
        return p_37470_ < ($$1 *= 64.0) * $$1;
    }

    @Override
    public boolean canUsePortal(boolean p_352918_) {
        return true;
    }

    @Override
    public void tick() {
        float $$8;
        super.tick();
        HitResult $$0 = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity);
        if ($$0.getType() != HitResult.Type.MISS) {
            this.hitTargetOrDeflectSelf($$0);
        }
        this.checkInsideBlocks();
        Vec3 $$1 = this.getDeltaMovement();
        double $$2 = this.getX() + $$1.x;
        double $$3 = this.getY() + $$1.y;
        double $$4 = this.getZ() + $$1.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int $$5 = 0; $$5 < 4; ++$$5) {
                float $$6 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, $$2 - $$1.x * 0.25, $$3 - $$1.y * 0.25, $$4 - $$1.z * 0.25, $$1.x, $$1.y, $$1.z);
            }
            float $$7 = 0.8f;
        } else {
            $$8 = 0.99f;
        }
        this.setDeltaMovement($$1.scale($$8));
        this.applyGravity();
        this.setPos($$2, $$3, $$4);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.03;
    }
}

