/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.players.StoredUserEntry;

public class ServerOpListEntry
extends StoredUserEntry<GameProfile> {
    private final int level;
    private final boolean bypassesPlayerLimit;

    public ServerOpListEntry(GameProfile p_11360_, int p_11361_, boolean p_11362_) {
        super(p_11360_);
        this.level = p_11361_;
        this.bypassesPlayerLimit = p_11362_;
    }

    public ServerOpListEntry(JsonObject p_11358_) {
        super(ServerOpListEntry.createGameProfile(p_11358_));
        this.level = p_11358_.has("level") ? p_11358_.get("level").getAsInt() : 0;
        this.bypassesPlayerLimit = p_11358_.has("bypassesPlayerLimit") && p_11358_.get("bypassesPlayerLimit").getAsBoolean();
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getBypassesPlayerLimit() {
        return this.bypassesPlayerLimit;
    }

    @Override
    protected void serialize(JsonObject p_11365_) {
        if (this.getUser() == null) {
            return;
        }
        p_11365_.addProperty("uuid", ((GameProfile)this.getUser()).getId().toString());
        p_11365_.addProperty("name", ((GameProfile)this.getUser()).getName());
        p_11365_.addProperty("level", (Number)this.level);
        p_11365_.addProperty("bypassesPlayerLimit", Boolean.valueOf(this.bypassesPlayerLimit));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static GameProfile createGameProfile(JsonObject p_11368_) {
        void $$4;
        if (!p_11368_.has("uuid") || !p_11368_.has("name")) {
            return null;
        }
        String $$1 = p_11368_.get("uuid").getAsString();
        try {
            UUID $$2 = UUID.fromString($$1);
        }
        catch (Throwable $$3) {
            return null;
        }
        return new GameProfile((UUID)$$4, p_11368_.get("name").getAsString());
    }
}

