/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;

public interface BundlerInfo {
    public static final int BUNDLE_SIZE_LIMIT = 4096;

    public static <T extends PacketListener, P extends BundlePacket<? super T>> BundlerInfo createForPacket(final PacketType<P> p_320816_, final Function<Iterable<Packet<? super T>>, P> p_265627_, final BundleDelimiterPacket<? super T> p_265373_) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> p_265538_, Consumer<Packet<?>> p_265064_) {
                if (p_265538_.type() == p_320816_) {
                    BundlePacket $$2 = (BundlePacket)p_265538_;
                    p_265064_.accept(p_265373_);
                    $$2.subPackets().forEach(p_265064_);
                    p_265064_.accept(p_265373_);
                } else {
                    p_265064_.accept(p_265538_);
                }
            }

            @Override
            @Nullable
            public Bundler startPacketBundling(Packet<?> p_265749_) {
                if (p_265749_ == p_265373_) {
                    return new Bundler(){
                        private final List<Packet<? super T>> bundlePackets = new ArrayList();

                        @Override
                        @Nullable
                        public Packet<?> addPacket(Packet<?> p_320276_) {
                            if (p_320276_ == p_265373_) {
                                return (Packet)p_265627_.apply(this.bundlePackets);
                            }
                            Packet<?> $$1 = p_320276_;
                            if (this.bundlePackets.size() >= 4096) {
                                throw new IllegalStateException("Too many packets in a bundle");
                            }
                            this.bundlePackets.add($$1);
                            return null;
                        }
                    };
                }
                return null;
            }
        };
    }

    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    @Nullable
    public Bundler startPacketBundling(Packet<?> var1);

    public static interface Bundler {
        @Nullable
        public Packet<?> addPacket(Packet<?> var1);
    }
}

