/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.PackOutput;
import net.minecraft.server.Bootstrap;
import org.slf4j.Logger;

public class DataGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path rootOutputFolder;
    private final PackOutput vanillaPackOutput;
    final Set<String> allProviderIds = new HashSet<String>();
    final Map<String, DataProvider> providersToRun = new LinkedHashMap<String, DataProvider>();
    private final WorldVersion version;
    private final boolean alwaysGenerate;

    public DataGenerator(Path p_251724_, WorldVersion p_250554_, boolean p_251323_) {
        this.rootOutputFolder = p_251724_;
        this.vanillaPackOutput = new PackOutput(this.rootOutputFolder);
        this.version = p_250554_;
        this.alwaysGenerate = p_251323_;
    }

    public void run() throws IOException {
        HashCache $$0 = new HashCache(this.rootOutputFolder, this.allProviderIds, this.version);
        Stopwatch $$1 = Stopwatch.createStarted();
        Stopwatch $$2 = Stopwatch.createUnstarted();
        this.providersToRun.forEach((p_254418_, p_253750_) -> {
            if (!this.alwaysGenerate && !$$0.shouldRunInThisVersion((String)p_254418_)) {
                LOGGER.debug("Generator {} already run for version {}", p_254418_, (Object)this.version.getName());
                return;
            }
            LOGGER.info("Starting provider: {}", p_254418_);
            $$2.start();
            $$0.applyUpdate($$0.generateUpdate((String)p_254418_, p_253750_::run).join());
            $$2.stop();
            LOGGER.info("{} finished after {} ms", p_254418_, (Object)$$2.elapsed(TimeUnit.MILLISECONDS));
            $$2.reset();
        });
        LOGGER.info("All providers took: {} ms", (Object)$$1.elapsed(TimeUnit.MILLISECONDS));
        $$0.purgeStaleAndWrite();
    }

    public PackGenerator getVanillaPack(boolean p_254422_) {
        return new PackGenerator(p_254422_, "vanilla", this.vanillaPackOutput);
    }

    public PackGenerator getBuiltinDatapack(boolean p_253826_, String p_254134_) {
        Path $$2 = this.vanillaPackOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("minecraft").resolve("datapacks").resolve(p_254134_);
        return new PackGenerator(p_253826_, p_254134_, new PackOutput($$2));
    }

    static {
        Bootstrap.bootStrap();
    }

    public class PackGenerator {
        private final boolean toRun;
        private final String providerPrefix;
        private final PackOutput output;

        PackGenerator(boolean p_253884_, String p_254544_, PackOutput p_254363_) {
            this.toRun = p_253884_;
            this.providerPrefix = p_254544_;
            this.output = p_254363_;
        }

        public <T extends DataProvider> T addProvider(DataProvider.Factory<T> p_254382_) {
            T $$1 = p_254382_.create(this.output);
            String $$2 = this.providerPrefix + "/" + $$1.getName();
            if (!DataGenerator.this.allProviderIds.add($$2)) {
                throw new IllegalStateException("Duplicate provider: " + $$2);
            }
            if (this.toRun) {
                DataGenerator.this.providersToRun.put($$2, (DataProvider)$$1);
            }
            return $$1;
        }
    }
}

