/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType ERROR_UNKNOWN_TAG = new Dynamic2CommandExceptionType((p_304107_, p_304108_) -> Component.translatableEscape("argument.resource_tag.not_found", p_304107_, p_304108_));
    private static final Dynamic3CommandExceptionType ERROR_INVALID_TAG_TYPE = new Dynamic3CommandExceptionType((p_304109_, p_304110_, p_304111_) -> Component.translatableEscape("argument.resource_tag.invalid_type", p_304109_, p_304110_, p_304111_));
    private final HolderLookup<T> registryLookup;
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceOrTagArgument(CommandBuildContext p_249382_, ResourceKey<? extends Registry<T>> p_251209_) {
        this.registryKey = p_251209_;
        this.registryLookup = p_249382_.lookupOrThrow(p_251209_);
    }

    public static <T> ResourceOrTagArgument<T> resourceOrTag(CommandBuildContext p_251101_, ResourceKey<? extends Registry<T>> p_248888_) {
        return new ResourceOrTagArgument<T>(p_251101_, p_248888_);
    }

    public static <T> Result<T> getResourceOrTag(CommandContext<CommandSourceStack> p_249001_, String p_251520_, ResourceKey<Registry<T>> p_250370_) throws CommandSyntaxException {
        Result $$3 = (Result)p_249001_.getArgument(p_251520_, Result.class);
        Optional<Result<T>> $$4 = $$3.cast(p_250370_);
        return $$4.orElseThrow(() -> (CommandSyntaxException)((Object)((Object)$$3.unwrap().map(p_252340_ -> {
            ResourceKey $$2 = p_252340_.key();
            return ResourceArgument.ERROR_INVALID_RESOURCE_TYPE.create((Object)$$2.location(), (Object)$$2.registry(), (Object)p_250370_.location());
        }, p_250301_ -> {
            TagKey $$2 = p_250301_.key();
            return ERROR_INVALID_TAG_TYPE.create((Object)$$2.location(), $$2.registry(), (Object)p_250370_.location());
        }))));
    }

    public Result<T> parse(StringReader p_250860_) throws CommandSyntaxException {
        if (p_250860_.canRead() && p_250860_.peek() == '#') {
            int $$1 = p_250860_.getCursor();
            try {
                p_250860_.skip();
                ResourceLocation $$2 = ResourceLocation.read(p_250860_);
                TagKey $$3 = TagKey.create(this.registryKey, $$2);
                HolderSet.Named $$4 = this.registryLookup.get($$3).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)p_250860_, (Object)$$2, (Object)this.registryKey.location()));
                return new TagResult($$4);
            }
            catch (CommandSyntaxException $$5) {
                p_250860_.setCursor($$1);
                throw $$5;
            }
        }
        ResourceLocation $$6 = ResourceLocation.read(p_250860_);
        ResourceKey $$7 = ResourceKey.create(this.registryKey, $$6);
        Holder.Reference $$8 = this.registryLookup.get($$7).orElseThrow(() -> ResourceArgument.ERROR_UNKNOWN_RESOURCE.createWithContext((ImmutableStringReader)p_250860_, (Object)$$6, (Object)this.registryKey.location()));
        return new ResourceResult($$8);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_250223_, SuggestionsBuilder p_252354_) {
        SharedSuggestionProvider.suggestResource(this.registryLookup.listTagIds().map(TagKey::location), p_252354_, "#");
        return SharedSuggestionProvider.suggestResource(this.registryLookup.listElementIds().map(ResourceKey::location), p_252354_);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static interface Result<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap();

        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> var1);

        public String asPrintable();
    }

    record TagResult<T>(HolderSet.Named<T> tag) implements Result<T>
    {
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.right(this.tag);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> p_250945_) {
            return this.tag.key().isFor(p_250945_) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> p_252187_) {
            return this.tag.contains(p_252187_);
        }

        @Override
        public String asPrintable() {
            return "#" + String.valueOf(this.tag.key().location());
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    record ResourceResult<T>(Holder.Reference<T> value) implements Result<T>
    {
        @Override
        public Either<Holder.Reference<T>, HolderSet.Named<T>> unwrap() {
            return Either.left(this.value);
        }

        @Override
        public <E> Optional<Result<E>> cast(ResourceKey<? extends Registry<E>> p_250007_) {
            return this.value.key().isFor(p_250007_) ? Optional.of(this) : Optional.empty();
        }

        @Override
        public boolean test(Holder<T> p_249230_) {
            return p_249230_.equals(this.value);
        }

        @Override
        public String asPrintable() {
            return this.value.key().location().toString();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Holder)object);
        }
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, Template> {
        @Override
        public void serializeToNetwork(Template p_250419_, FriendlyByteBuf p_249726_) {
            p_249726_.writeResourceKey(p_250419_.registryKey);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf p_250205_) {
            return new Template(p_250205_.readRegistryKey());
        }

        @Override
        public void serializeToJson(Template p_251957_, JsonObject p_249067_) {
            p_249067_.addProperty("registry", p_251957_.registryKey.location().toString());
        }

        @Override
        public Template unpack(ResourceOrTagArgument<T> p_252206_) {
            return new Template(p_252206_.registryKey);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey<? extends Registry<T>> p_250107_) {
                this.registryKey = p_250107_;
            }

            @Override
            public ResourceOrTagArgument<T> instantiate(CommandBuildContext p_251386_) {
                return new ResourceOrTagArgument(p_251386_, this.registryKey);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

