/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.levelgen.structure.Structure;

public record LocationPredicate(Optional<PositionPredicate> position, Optional<HolderSet<Biome>> biomes, Optional<HolderSet<Structure>> structures, Optional<ResourceKey<Level>> dimension, Optional<Boolean> smokey, Optional<LightPredicate> light, Optional<BlockPredicate> block, Optional<FluidPredicate> fluid, Optional<Boolean> canSeeSky) {
    public static final Codec<LocationPredicate> CODEC = RecordCodecBuilder.create(p_297907_ -> p_297907_.group((App)PositionPredicate.CODEC.optionalFieldOf("position").forGetter(LocationPredicate::position), (App)RegistryCodecs.homogeneousList(Registries.BIOME).optionalFieldOf("biomes").forGetter(LocationPredicate::biomes), (App)RegistryCodecs.homogeneousList(Registries.STRUCTURE).optionalFieldOf("structures").forGetter(LocationPredicate::structures), (App)ResourceKey.codec(Registries.DIMENSION).optionalFieldOf("dimension").forGetter(LocationPredicate::dimension), (App)Codec.BOOL.optionalFieldOf("smokey").forGetter(LocationPredicate::smokey), (App)LightPredicate.CODEC.optionalFieldOf("light").forGetter(LocationPredicate::light), (App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(LocationPredicate::block), (App)FluidPredicate.CODEC.optionalFieldOf("fluid").forGetter(LocationPredicate::fluid), (App)Codec.BOOL.optionalFieldOf("can_see_sky").forGetter(LocationPredicate::canSeeSky)).apply((Applicative)p_297907_, LocationPredicate::new));

    public boolean matches(ServerLevel p_52618_, double p_52619_, double p_52620_, double p_52621_) {
        if (this.position.isPresent() && !this.position.get().matches(p_52619_, p_52620_, p_52621_)) {
            return false;
        }
        if (this.dimension.isPresent() && this.dimension.get() != p_52618_.dimension()) {
            return false;
        }
        BlockPos $$4 = BlockPos.containing(p_52619_, p_52620_, p_52621_);
        boolean $$5 = p_52618_.isLoaded($$4);
        if (!(!this.biomes.isPresent() || $$5 && this.biomes.get().contains(p_52618_.getBiome($$4)))) {
            return false;
        }
        if (!(!this.structures.isPresent() || $$5 && p_52618_.structureManager().getStructureWithPieceAt($$4, this.structures.get()).isValid())) {
            return false;
        }
        if (this.smokey.isPresent() && (!$$5 || this.smokey.get() != CampfireBlock.isSmokeyPos(p_52618_, $$4))) {
            return false;
        }
        if (this.light.isPresent() && !this.light.get().matches(p_52618_, $$4)) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().matches(p_52618_, $$4)) {
            return false;
        }
        if (this.fluid.isPresent() && !this.fluid.get().matches(p_52618_, $$4)) {
            return false;
        }
        return !this.canSeeSky.isPresent() || this.canSeeSky.get().booleanValue() == p_52618_.canSeeSky($$4);
    }

    record PositionPredicate(MinMaxBounds.Doubles x, MinMaxBounds.Doubles y, MinMaxBounds.Doubles z) {
        public static final Codec<PositionPredicate> CODEC = RecordCodecBuilder.create(p_337379_ -> p_337379_.group((App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("x", (Object)MinMaxBounds.Doubles.ANY).forGetter(PositionPredicate::x), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("y", (Object)MinMaxBounds.Doubles.ANY).forGetter(PositionPredicate::y), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("z", (Object)MinMaxBounds.Doubles.ANY).forGetter(PositionPredicate::z)).apply((Applicative)p_337379_, PositionPredicate::new));

        static Optional<PositionPredicate> of(MinMaxBounds.Doubles p_298771_, MinMaxBounds.Doubles p_298418_, MinMaxBounds.Doubles p_299133_) {
            if (p_298771_.isAny() && p_298418_.isAny() && p_299133_.isAny()) {
                return Optional.empty();
            }
            return Optional.of(new PositionPredicate(p_298771_, p_298418_, p_299133_));
        }

        public boolean matches(double p_298782_, double p_299123_, double p_298955_) {
            return this.x.matches(p_298782_) && this.y.matches(p_299123_) && this.z.matches(p_298955_);
        }
    }

    public static class Builder {
        private MinMaxBounds.Doubles x = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles y = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles z = MinMaxBounds.Doubles.ANY;
        private Optional<HolderSet<Biome>> biomes = Optional.empty();
        private Optional<HolderSet<Structure>> structures = Optional.empty();
        private Optional<ResourceKey<Level>> dimension = Optional.empty();
        private Optional<Boolean> smokey = Optional.empty();
        private Optional<LightPredicate> light = Optional.empty();
        private Optional<BlockPredicate> block = Optional.empty();
        private Optional<FluidPredicate> fluid = Optional.empty();
        private Optional<Boolean> canSeeSky = Optional.empty();

        public static Builder location() {
            return new Builder();
        }

        public static Builder inBiome(Holder<Biome> p_332168_) {
            return Builder.location().setBiomes(HolderSet.direct(p_332168_));
        }

        public static Builder inDimension(ResourceKey<Level> p_298871_) {
            return Builder.location().setDimension(p_298871_);
        }

        public static Builder inStructure(Holder<Structure> p_330610_) {
            return Builder.location().setStructures(HolderSet.direct(p_330610_));
        }

        public static Builder atYLocation(MinMaxBounds.Doubles p_298783_) {
            return Builder.location().setY(p_298783_);
        }

        public Builder setX(MinMaxBounds.Doubles p_153971_) {
            this.x = p_153971_;
            return this;
        }

        public Builder setY(MinMaxBounds.Doubles p_153975_) {
            this.y = p_153975_;
            return this;
        }

        public Builder setZ(MinMaxBounds.Doubles p_153979_) {
            this.z = p_153979_;
            return this;
        }

        public Builder setBiomes(HolderSet<Biome> p_330686_) {
            this.biomes = Optional.of(p_330686_);
            return this;
        }

        public Builder setStructures(HolderSet<Structure> p_332189_) {
            this.structures = Optional.of(p_332189_);
            return this;
        }

        public Builder setDimension(ResourceKey<Level> p_153977_) {
            this.dimension = Optional.of(p_153977_);
            return this;
        }

        public Builder setLight(LightPredicate.Builder p_298888_) {
            this.light = Optional.of(p_298888_.build());
            return this;
        }

        public Builder setBlock(BlockPredicate.Builder p_298335_) {
            this.block = Optional.of(p_298335_.build());
            return this;
        }

        public Builder setFluid(FluidPredicate.Builder p_299307_) {
            this.fluid = Optional.of(p_299307_.build());
            return this;
        }

        public Builder setSmokey(boolean p_299155_) {
            this.smokey = Optional.of(p_299155_);
            return this;
        }

        public Builder setCanSeeSky(boolean p_345443_) {
            this.canSeeSky = Optional.of(p_345443_);
            return this;
        }

        public LocationPredicate build() {
            Optional<PositionPredicate> $$0 = PositionPredicate.of(this.x, this.y, this.z);
            return new LocationPredicate($$0, this.biomes, this.structures, this.dimension, this.smokey, this.light, this.block, this.fluid, this.canSeeSky);
        }
    }
}

