/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transformation {
    private final Matrix4f matrix;
    public static final Codec<Transformation> CODEC = RecordCodecBuilder.create(p_269604_ -> p_269604_.group((App)ExtraCodecs.VECTOR3F.fieldOf("translation").forGetter(p_269599_ -> p_269599_.translation), (App)ExtraCodecs.QUATERNIONF.fieldOf("left_rotation").forGetter(p_269600_ -> p_269600_.leftRotation), (App)ExtraCodecs.VECTOR3F.fieldOf("scale").forGetter(p_269603_ -> p_269603_.scale), (App)ExtraCodecs.QUATERNIONF.fieldOf("right_rotation").forGetter(p_269598_ -> p_269598_.rightRotation)).apply((Applicative)p_269604_, Transformation::new));
    public static final Codec<Transformation> EXTENDED_CODEC = Codec.withAlternative(CODEC, (Codec)ExtraCodecs.MATRIX4F.xmap(Transformation::new, Transformation::getMatrix));
    private boolean decomposed;
    @Nullable
    private Vector3f translation;
    @Nullable
    private Quaternionf leftRotation;
    @Nullable
    private Vector3f scale;
    @Nullable
    private Quaternionf rightRotation;
    private static final Transformation IDENTITY = Util.make(() -> {
        Transformation $$0 = new Transformation(new Matrix4f());
        $$0.translation = new Vector3f();
        $$0.leftRotation = new Quaternionf();
        $$0.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        $$0.rightRotation = new Quaternionf();
        $$0.decomposed = true;
        return $$0;
    });

    public Transformation(@Nullable Matrix4f p_253689_) {
        this.matrix = p_253689_ == null ? new Matrix4f() : p_253689_;
    }

    public Transformation(@Nullable Vector3f p_253831_, @Nullable Quaternionf p_253846_, @Nullable Vector3f p_254502_, @Nullable Quaternionf p_253912_) {
        this.matrix = Transformation.compose(p_253831_, p_253846_, p_254502_, p_253912_);
        this.translation = p_253831_ != null ? p_253831_ : new Vector3f();
        this.leftRotation = p_253846_ != null ? p_253846_ : new Quaternionf();
        this.scale = p_254502_ != null ? p_254502_ : new Vector3f(1.0f, 1.0f, 1.0f);
        this.rightRotation = p_253912_ != null ? p_253912_ : new Quaternionf();
        this.decomposed = true;
    }

    public static Transformation identity() {
        return IDENTITY;
    }

    public Transformation compose(Transformation p_121097_) {
        Matrix4f $$1 = this.getMatrix();
        $$1.mul((Matrix4fc)p_121097_.getMatrix());
        return new Transformation($$1);
    }

    @Nullable
    public Transformation inverse() {
        if (this == IDENTITY) {
            return this;
        }
        Matrix4f $$0 = this.getMatrix().invert();
        if ($$0.isFinite()) {
            return new Transformation($$0);
        }
        return null;
    }

    private void ensureDecomposed() {
        if (!this.decomposed) {
            float $$0 = 1.0f / this.matrix.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> $$1 = MatrixUtil.svdDecompose(new Matrix3f((Matrix4fc)this.matrix).scale($$0));
            this.translation = this.matrix.getTranslation(new Vector3f()).mul($$0);
            this.leftRotation = new Quaternionf((Quaternionfc)$$1.getLeft());
            this.scale = new Vector3f((Vector3fc)$$1.getMiddle());
            this.rightRotation = new Quaternionf((Quaternionfc)$$1.getRight());
            this.decomposed = true;
        }
    }

    private static Matrix4f compose(@Nullable Vector3f p_254465_, @Nullable Quaternionf p_254416_, @Nullable Vector3f p_254499_, @Nullable Quaternionf p_254334_) {
        Matrix4f $$4 = new Matrix4f();
        if (p_254465_ != null) {
            $$4.translation((Vector3fc)p_254465_);
        }
        if (p_254416_ != null) {
            $$4.rotate((Quaternionfc)p_254416_);
        }
        if (p_254499_ != null) {
            $$4.scale((Vector3fc)p_254499_);
        }
        if (p_254334_ != null) {
            $$4.rotate((Quaternionfc)p_254334_);
        }
        return $$4;
    }

    public Matrix4f getMatrix() {
        return new Matrix4f((Matrix4fc)this.matrix);
    }

    public Vector3f getTranslation() {
        this.ensureDecomposed();
        return new Vector3f((Vector3fc)this.translation);
    }

    public Quaternionf getLeftRotation() {
        this.ensureDecomposed();
        return new Quaternionf((Quaternionfc)this.leftRotation);
    }

    public Vector3f getScale() {
        this.ensureDecomposed();
        return new Vector3f((Vector3fc)this.scale);
    }

    public Quaternionf getRightRotation() {
        this.ensureDecomposed();
        return new Quaternionf((Quaternionfc)this.rightRotation);
    }

    public boolean equals(Object p_121108_) {
        if (this == p_121108_) {
            return true;
        }
        if (p_121108_ == null || this.getClass() != p_121108_.getClass()) {
            return false;
        }
        Transformation $$1 = (Transformation)p_121108_;
        return Objects.equals(this.matrix, $$1.matrix);
    }

    public int hashCode() {
        return Objects.hash(this.matrix);
    }

    public Transformation slerp(Transformation p_175938_, float p_175939_) {
        Vector3f $$2 = this.getTranslation();
        Quaternionf $$3 = this.getLeftRotation();
        Vector3f $$4 = this.getScale();
        Quaternionf $$5 = this.getRightRotation();
        $$2.lerp((Vector3fc)p_175938_.getTranslation(), p_175939_);
        $$3.slerp((Quaternionfc)p_175938_.getLeftRotation(), p_175939_);
        $$4.lerp((Vector3fc)p_175938_.getScale(), p_175939_);
        $$5.slerp((Quaternionfc)p_175938_.getRightRotation(), p_175939_);
        return new Transformation($$2, $$3, $$4, $$5);
    }
}

