/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.datagen;

import com.mrbysco.justaraftmod.init.RaftRegistry;
import com.mrbysco.justaraftmod.items.RaftItem;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RaftDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new Recipes(packOutput, lookupProvider));
            RaftBlockTags blockTags = new RaftBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)blockTags);
            generator.addProvider(true, (DataProvider)new RaftItemTags(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, helper));
            generator.addProvider(true, (DataProvider)new RaftEntityTags(packOutput, lookupProvider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new Language(packOutput));
            generator.addProvider(true, (DataProvider)new ItemModels(packOutput, helper));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, lookupProvider);
        }

        protected void buildRecipes(RecipeOutput output) {
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.ACACIA_RAFT, (TagKey<Item>)ItemTags.ACACIA_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.BAMBOO_RAFT, (ItemLike)Items.BAMBOO).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.BIRCH_RAFT, (TagKey<Item>)ItemTags.BIRCH_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.CHERRY_RAFT, (TagKey<Item>)ItemTags.CHERRY_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.DARK_OAK_RAFT, (TagKey<Item>)ItemTags.DARK_OAK_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.JUNGLE_RAFT, (TagKey<Item>)ItemTags.JUNGLE_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.MANGROVE_RAFT, (TagKey<Item>)ItemTags.MANGROVE_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.OAK_RAFT, (TagKey<Item>)ItemTags.OAK_LOGS).save(output);
            this.generateRaftRecipe((DeferredHolder<Item, RaftItem>)RaftRegistry.SPRUCE_RAFT, (TagKey<Item>)ItemTags.SPRUCE_LOGS).save(output);
        }

        private RecipeBuilder generateRaftRecipe(DeferredHolder<Item, RaftItem> raft, TagKey<Item> logTag) {
            return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)raft.get())).pattern("S S").pattern("LLL").pattern("S S").define(Character.valueOf('L'), logTag).define(Character.valueOf('S'), Tags.Items.STRINGS).unlockedBy("has_log", Recipes.has(logTag)).unlockedBy("has_string", Recipes.has((TagKey)Tags.Items.STRINGS));
        }

        private RecipeBuilder generateRaftRecipe(DeferredHolder<Item, RaftItem> raft, ItemLike log) {
            return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)((ItemLike)raft.get())).pattern("S S").pattern("LLL").pattern("S S").define(Character.valueOf('L'), log).define(Character.valueOf('S'), Tags.Items.STRINGS).unlockedBy("has_log", Recipes.has((ItemLike)log)).unlockedBy("has_string", Recipes.has((TagKey)Tags.Items.STRINGS));
        }
    }

    public static class RaftBlockTags
    extends BlockTagsProvider {
        public RaftBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "justaraftmod", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
        }
    }

    public static class RaftItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> RAFTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"justaraftmod", (String)"rafts"));

        public RaftItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, TagsProvider<Block> blockTagProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagProvider.contentsGetter(), "justaraftmod", existingFileHelper);
        }

        public void addTags(HolderLookup.Provider provider) {
            this.tag(RAFTS).add((Object[])new Item[]{(Item)RaftRegistry.OAK_RAFT.get(), (Item)RaftRegistry.SPRUCE_RAFT.get(), (Item)RaftRegistry.BIRCH_RAFT.get(), (Item)RaftRegistry.JUNGLE_RAFT.get(), (Item)RaftRegistry.ACACIA_RAFT.get(), (Item)RaftRegistry.DARK_OAK_RAFT.get(), (Item)RaftRegistry.BAMBOO_RAFT.get(), (Item)RaftRegistry.MANGROVE_RAFT.get(), (Item)RaftRegistry.CHERRY_RAFT.get()});
        }
    }

    public static class RaftEntityTags
    extends EntityTypeTagsProvider {
        public RaftEntityTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper fileHelper) {
            super(output, lookupProvider, "justaraftmod", fileHelper);
        }

        public void addTags(HolderLookup.Provider provider) {
            this.tag(Tags.EntityTypes.BOATS).add(RaftRegistry.RAFT.get());
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "justaraftmod", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.justaraftmod.raft", "Just A Raft Mod");
            this.add("justaraftmod.config.title", "Just Another Raft Config");
            this.addItem((Supplier)RaftRegistry.OAK_RAFT, "Oak Log Raft");
            this.addItem((Supplier)RaftRegistry.SPRUCE_RAFT, "Spruce Log Raft");
            this.addItem((Supplier)RaftRegistry.BIRCH_RAFT, "Birch Log Raft");
            this.addItem((Supplier)RaftRegistry.CHERRY_RAFT, "Cherry Log Raft");
            this.addItem((Supplier)RaftRegistry.JUNGLE_RAFT, "Jungle Log Raft");
            this.addItem((Supplier)RaftRegistry.ACACIA_RAFT, "Acacia Log Raft");
            this.addItem((Supplier)RaftRegistry.DARK_OAK_RAFT, "Dark Oak Log Raft");
            this.addItem((Supplier)RaftRegistry.BAMBOO_RAFT, "Bamboo Raft");
            this.addItem((Supplier)RaftRegistry.MANGROVE_RAFT, "Mangrove Raft");
            this.addEntityType(RaftRegistry.RAFT, "Raft");
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "justaraftmod", helper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.ACACIA_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/acacia_log"))).texture("log_side", this.mcLoc("block/acacia_log"))).texture("log_top", this.mcLoc("block/acacia_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.BAMBOO_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/bamboo_stalk"))).texture("log_side", this.mcLoc("block/bamboo_stalk"))).texture("log_top", this.mcLoc("block/bamboo_stalk"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.BIRCH_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/birch_log"))).texture("log_side", this.mcLoc("block/birch_log"))).texture("log_top", this.mcLoc("block/birch_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.CHERRY_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/cherry_log"))).texture("log_side", this.mcLoc("block/cherry_log"))).texture("log_top", this.mcLoc("block/cherry_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.DARK_OAK_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/dark_oak_log"))).texture("log_side", this.mcLoc("block/dark_oak_log"))).texture("log_top", this.mcLoc("block/dark_oak_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.JUNGLE_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/jungle_log"))).texture("log_side", this.mcLoc("block/jungle_log"))).texture("log_top", this.mcLoc("block/jungle_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.MANGROVE_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/mangrove_log"))).texture("log_side", this.mcLoc("block/mangrove_log"))).texture("log_top", this.mcLoc("block/mangrove_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.OAK_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/oak_log"))).texture("log_side", this.mcLoc("block/oak_log"))).texture("log_top", this.mcLoc("block/oak_log_top"));
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(RaftRegistry.SPRUCE_RAFT.getId().getPath(), this.modLoc("item/raft_base"))).texture("particle", this.mcLoc("block/spruce_log"))).texture("log_side", this.mcLoc("block/spruce_log"))).texture("log_top", this.mcLoc("block/spruce_log_top"));
        }
    }
}

