/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.component;

import com.almostreliable.kubeio.binding.SagMillOutputItem;
import com.almostreliable.kubeio.mixin.IngredientAccessor;
import com.almostreliable.kubeio.mixin.SagMillOutputItemAccessor;
import com.almostreliable.kubeio.mixin.TagValueAccessor;
import com.enderio.machines.common.blocks.sag_mill.SagMillingRecipe;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.bindings.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.Collection;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record SagMillOutputItemComponent() implements RecipeComponent<SagMillingRecipe.OutputItem>
{
    public static final RecipeComponent<SagMillingRecipe.OutputItem> OUTPUT_ITEM = new SagMillOutputItemComponent();

    public Codec<SagMillingRecipe.OutputItem> codec() {
        return SagMillOutputItemAccessor.getCodec();
    }

    public TypeInfo typeInfo() {
        return TypeInfo.of(SagMillingRecipe.OutputItem.class).or(ItemStackJS.TYPE_INFO);
    }

    public SagMillingRecipe.OutputItem wrap(Context cx, KubeRecipe recipe, Object from) {
        if (from instanceof SagMillingRecipe.OutputItem) {
            SagMillingRecipe.OutputItem o = (SagMillingRecipe.OutputItem)from;
            return o;
        }
        RegistryAccessContainer registryAccess = ((KubeJSContext)cx).getRegistries();
        SizedIngredient sizedIngredient = SizedIngredientWrapper.wrap((RegistryAccessContainer)registryAccess, (Object)from);
        Ingredient.Value[] ingredientValues = ((IngredientAccessor)sizedIngredient.ingredient()).kubeio$getValues();
        if (ingredientValues.length > 1) {
            throw new IllegalArgumentException("compound ingredients not supported in sag mill output: " + String.valueOf(from));
        }
        Ingredient.Value ingredientValue = ingredientValues[0];
        if (ingredientValue instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)ingredientValue;
            TagKey<Item> tag = ((TagValueAccessor)tagValue).kubeio$getTag();
            return SagMillOutputItem.kubeio$ofTag(tag, sizedIngredient.count());
        }
        if (ingredientValue instanceof Ingredient.ItemValue) {
            Ingredient.ItemValue itemValue = (Ingredient.ItemValue)ingredientValue;
            Collection items = itemValue.getItems();
            if (items.size() > 1) {
                throw new IllegalArgumentException("compound ingredients not supported in sag mill output: " + String.valueOf(from));
            }
            ItemStack itemStack = new ItemStack((ItemLike)((ItemStack)items.iterator().next()).getItem(), sizedIngredient.count());
            return SagMillOutputItem.kubeio$of(itemStack);
        }
        ItemStack itemStack = ItemStackJS.wrap((RegistryAccessContainer)registryAccess, (Object)from);
        if (itemStack.isEmpty()) {
            throw new IllegalArgumentException("empty sag mill output: " + String.valueOf(from));
        }
        return SagMillOutputItem.kubeio$of(itemStack);
    }

    @Override
    public String toString() {
        return "enderio:sag_mill_output";
    }
}

