/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.packet;

import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.network.MatterNetwork;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TaskCreatePacket
extends Message {
    private String networkId;
    private int amount;
    private ItemStack stack;
    private boolean parallelMode;
    private BlockPos source;

    public TaskCreatePacket(String network, int amount, ItemStack stack, boolean parallelMode, BlockPos source) {
        this.networkId = network;
        this.amount = amount;
        this.stack = stack;
        this.parallelMode = parallelMode;
        this.source = source;
    }

    public TaskCreatePacket() {
    }

    protected void handleMessage(IPayloadContext context) {
        context.enqueueWork(() -> {
            for (Network network : NetworkManager.get((Level)context.player().level()).getNetworks()) {
                if (!network.getId().equals(this.networkId) || !(network instanceof MatterNetwork)) continue;
                MatterNetwork matterNetwork = (MatterNetwork)network;
                ReplicationTask task = new ReplicationTask(this.stack, this.amount, this.parallelMode ? IReplicationTask.Mode.MULTIPLE : IReplicationTask.Mode.SINGLE, this.source);
                matterNetwork.getTaskManager().getPendingTasks().put(task.getUuid().toString(), task);
                ((MatterNetwork)network).onTaskValueChanged(task, (ServerLevel)context.player().level());
                break;
            }
        });
    }
}

