/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.data;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.recipe.MatterValueRecipe;
import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class MatterValueDataProvider {
    private RecipeOutput recipeOutput;

    public void buildRecipes(RecipeOutput consumer) {
        this.recipeOutput = consumer;
        this.saveData(Items.IRON_INGOT, MatterValueDataProvider.metallic(9.0));
        this.saveData(Items.GOLD_INGOT, MatterValueDataProvider.metallic(9.0), MatterValueDataProvider.precious(9.0));
        this.saveData(Items.DIAMOND, MatterValueDataProvider.precious(36.0));
        this.saveData(Items.LAPIS_LAZULI, MatterValueDataProvider.precious(1.0), MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.COPPER_INGOT, MatterValueDataProvider.precious(2.0), MatterValueDataProvider.metallic(2.0));
        this.saveData(Items.ANCIENT_DEBRIS, MatterValueDataProvider.precious(18.0), MatterValueDataProvider.nether(18.0));
        this.saveData(Items.AMETHYST_SHARD, MatterValueDataProvider.precious(4.0), MatterValueDataProvider.earth(1.0));
        this.saveData(Items.BUDDING_AMETHYST, MatterValueDataProvider.precious(32.0), MatterValueDataProvider.earth(8.0));
        this.saveData(Items.COAL, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.precious(0.25), MatterValueDataProvider.organic(0.25));
        this.saveData(Items.EMERALD, MatterValueDataProvider.precious(36.0));
        this.saveData(new Item[]{Items.EXPOSED_COPPER, Items.WEATHERED_COPPER, Items.OXIDIZED_COPPER}, MatterValueDataProvider.precious(8.0), MatterValueDataProvider.metallic(8.0));
        this.saveTag((TagKey<Item>)ItemTags.LOGS, MatterValueDataProvider.earth(8.0), MatterValueDataProvider.organic(8.0));
        this.saveTag((TagKey<Item>)ItemTags.SAPLINGS, MatterValueDataProvider.earth(16.0), MatterValueDataProvider.organic(16.0));
        this.saveData(Items.MANGROVE_ROOTS, MatterValueDataProvider.earth(16.0), MatterValueDataProvider.organic(16.0));
        this.saveTag((TagKey<Item>)ItemTags.LEAVES, MatterValueDataProvider.organic(4.0));
        this.saveTag((TagKey<Item>)ItemTags.SMALL_FLOWERS, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveTag((TagKey<Item>)ItemTags.TALL_FLOWERS, MatterValueDataProvider.earth(4.0), MatterValueDataProvider.organic(4.0));
        this.saveTag((TagKey<Item>)Tags.Items.MUSHROOMS, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.living(2.0));
        this.saveData(Items.BAMBOO, MatterValueDataProvider.earth(0.5), MatterValueDataProvider.organic(0.5));
        this.saveData(Items.MOSS_BLOCK, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.STRING, MatterValueDataProvider.organic(2.0), MatterValueDataProvider.living(2.0));
        this.saveData(Items.COBWEB, MatterValueDataProvider.organic(18.0), MatterValueDataProvider.living(18.0));
        this.saveData(Items.GRASS_BLOCK, MatterValueDataProvider.organic(4.0));
        this.saveData(Items.FERN, MatterValueDataProvider.organic(4.0));
        this.saveData(Items.WET_SPONGE, MatterValueDataProvider.organic(12.0), MatterValueDataProvider.living(4.0), MatterValueDataProvider.precious(4.0));
        this.saveData(Items.DEAD_BUSH, MatterValueDataProvider.earth(1.0), MatterValueDataProvider.organic(1.0));
        this.saveData(Items.SEAGRASS, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.SEA_PICKLE, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.SUGAR_CANE, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.KELP, MatterValueDataProvider.earth(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.PRISMARINE_SHARD, MatterValueDataProvider.earth(4.0), MatterValueDataProvider.organic(4.0));
        this.saveData(Items.PRISMARINE_CRYSTALS, MatterValueDataProvider.earth(4.0), MatterValueDataProvider.organic(4.0));
        this.saveData(new Item[]{Items.CRIMSON_FUNGUS, Items.CRIMSON_ROOTS, Items.WEEPING_VINES, Items.WARPED_FUNGUS, Items.WARPED_ROOTS, Items.NETHER_SPROUTS, Items.TWISTING_VINES}, MatterValueDataProvider.organic(2.0), MatterValueDataProvider.nether(2.0));
        this.saveTag((TagKey<Item>)Tags.Items.STONES, MatterValueDataProvider.earth(2.0));
        this.saveTag((TagKey<Item>)Tags.Items.COBBLESTONES, MatterValueDataProvider.earth(2.0));
        this.saveData(Items.BLACKSTONE, MatterValueDataProvider.earth(1.0), MatterValueDataProvider.nether(1.0));
        this.saveData(Items.OBSIDIAN, MatterValueDataProvider.earth(4.0), MatterValueDataProvider.nether(1.0));
        this.saveData(Items.CRYING_OBSIDIAN, MatterValueDataProvider.earth(4.0), MatterValueDataProvider.nether(1.0), MatterValueDataProvider.quantum(1.0));
        this.saveData(Items.POINTED_DRIPSTONE, MatterValueDataProvider.earth(1.0));
        this.saveData(Items.CALCITE, MatterValueDataProvider.earth(2.0));
        this.saveData(Items.DIRT, MatterValueDataProvider.earth(1.0));
        this.saveData(Items.ROOTED_DIRT, MatterValueDataProvider.earth(1.0));
        this.saveData(Items.MYCELIUM, MatterValueDataProvider.earth(1.0), MatterValueDataProvider.organic(4.0));
        this.saveData(Items.SHORT_GRASS, MatterValueDataProvider.earth(1.0), MatterValueDataProvider.organic(1.0));
        this.saveData(Items.PODZOL, MatterValueDataProvider.earth(1.0), MatterValueDataProvider.organic(1.0));
        this.saveData(Items.ICE, MatterValueDataProvider.earth(4.0), MatterValueDataProvider.organic(4.0));
        this.saveData(Items.SNOWBALL, MatterValueDataProvider.earth(1.0));
        this.saveData(Items.MUD, MatterValueDataProvider.earth(1.0));
        this.saveData(Items.FLINT, MatterValueDataProvider.earth(1.0));
        this.saveData(Items.CLAY_BALL, MatterValueDataProvider.earth(2.0));
        this.saveTag((TagKey<Item>)Tags.Items.SANDS, MatterValueDataProvider.earth(2.0));
        this.saveTag((TagKey<Item>)Tags.Items.GRAVELS, MatterValueDataProvider.earth(2.0));
        this.saveData(new Item[]{Items.WARPED_NYLIUM, Items.CRIMSON_NYLIUM}, MatterValueDataProvider.organic(2.0), MatterValueDataProvider.nether(1.0));
        this.saveData(new Item[]{Items.WHITE_CONCRETE, Items.ORANGE_CONCRETE, Items.MAGENTA_CONCRETE, Items.LIGHT_BLUE_CONCRETE, Items.YELLOW_CONCRETE, Items.LIME_CONCRETE, Items.PINK_CONCRETE, Items.GRAY_CONCRETE, Items.LIGHT_GRAY_CONCRETE, Items.CYAN_CONCRETE, Items.PURPLE_CONCRETE, Items.BLUE_CONCRETE, Items.BROWN_CONCRETE, Items.GREEN_CONCRETE, Items.RED_CONCRETE, Items.BLACK_CONCRETE}, MatterValueDataProvider.earth(1.25), MatterValueDataProvider.organic(0.25));
        this.saveData(Items.NETHERRACK, MatterValueDataProvider.nether(1.0));
        this.saveData(Items.SOUL_SAND, MatterValueDataProvider.nether(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.SOUL_SOIL, MatterValueDataProvider.nether(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.BASALT, MatterValueDataProvider.nether(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.END_STONE, MatterValueDataProvider.ender(1.0));
        this.saveData(Items.NETHER_STAR, MatterValueDataProvider.quantum(64.0), MatterValueDataProvider.nether(16.0));
        this.saveData(Items.REDSTONE, MatterValueDataProvider.precious(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.SLIME_BALL, MatterValueDataProvider.living(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.HONEY_BLOCK, MatterValueDataProvider.living(18.0), MatterValueDataProvider.earth(18.0));
        this.saveData(Items.ECHO_SHARD, MatterValueDataProvider.quantum(1.0), MatterValueDataProvider.living(4.0));
        this.saveData(Items.HONEYCOMB, MatterValueDataProvider.living(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.NETHER_WART, MatterValueDataProvider.living(2.0), MatterValueDataProvider.nether(2.0));
        this.saveData(Items.CHORUS_FRUIT, MatterValueDataProvider.living(2.0), MatterValueDataProvider.ender(8.0));
        this.saveData(Items.QUARTZ, MatterValueDataProvider.precious(4.0), MatterValueDataProvider.nether(2.0));
        this.saveData(Items.GLOWSTONE_DUST, MatterValueDataProvider.precious(1.0), MatterValueDataProvider.nether(2.0));
        this.saveData(Items.FEATHER, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.LEATHER, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.WHEAT, MatterValueDataProvider.organic(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.GUNPOWDER, MatterValueDataProvider.organic(2.0), MatterValueDataProvider.earth(2.0));
        this.saveData(Items.ENDER_PEARL, MatterValueDataProvider.organic(4.0), MatterValueDataProvider.quantum(1.0), MatterValueDataProvider.ender(2.0));
        this.saveData(new Item[]{Items.CHORUS_PLANT, Items.CHORUS_FLOWER}, MatterValueDataProvider.organic(1.0), MatterValueDataProvider.quantum(1.0));
        this.saveData(Items.GLOWSTONE, MatterValueDataProvider.nether(4.0), MatterValueDataProvider.precious(4.0));
        this.saveData(new Item[]{Items.EGG, Items.PUMPKIN, Items.CARVED_PUMPKIN, Items.PORKCHOP, Items.APPLE, Items.COD, Items.SALMON, Items.TROPICAL_FISH, Items.PUFFERFISH, Items.MELON_SLICE, Items.BEEF, Items.CHICKEN, Items.POTATO, Items.POISONOUS_POTATO, Items.CARROT, Items.MUTTON, Items.RABBIT, Items.BEETROOT, Items.GLOW_BERRIES, Items.SWEET_BERRIES, Items.RABBIT_FOOT}, MatterValueDataProvider.organic(4.0), MatterValueDataProvider.living(4.0));
        this.saveData(Items.GHAST_TEAR, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0), MatterValueDataProvider.nether(2.0));
        this.saveData(Items.BLAZE_ROD, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0), MatterValueDataProvider.nether(2.0));
        this.saveData(new Item[]{Items.ROTTEN_FLESH, Items.SPIDER_EYE, Items.INK_SAC, Items.RABBIT_HIDE, Items.GLOW_INK_SAC, Items.TURTLE_SCUTE, Items.NAUTILUS_SHELL, Items.HEART_OF_THE_SEA}, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0));
        this.saveData(Items.BONE, MatterValueDataProvider.living(3.0), MatterValueDataProvider.organic(3.0));
        this.saveData(Items.DRAGON_BREATH, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0), MatterValueDataProvider.quantum(2.0));
        this.saveData(Items.PHANTOM_MEMBRANE, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0), MatterValueDataProvider.nether(2.0));
        this.saveData(Items.SHULKER_SHELL, MatterValueDataProvider.living(4.0), MatterValueDataProvider.nether(8.0));
        this.saveData(Items.TOTEM_OF_UNDYING, MatterValueDataProvider.precious(16.0), MatterValueDataProvider.quantum(8.0));
        this.saveData(Items.COCOA_BEANS, MatterValueDataProvider.organic(1.0), MatterValueDataProvider.earth(1.0));
        this.saveData(Items.ENCHANTED_GOLDEN_APPLE, MatterValueDataProvider.living(4.0), MatterValueDataProvider.precious(648.0));
        this.saveData(new Item[]{Items.OCHRE_FROGLIGHT, Items.PEARLESCENT_FROGLIGHT, Items.VERDANT_FROGLIGHT}, MatterValueDataProvider.living(2.0), MatterValueDataProvider.organic(2.0));
        this.saveTag((TagKey<Item>)ItemTags.CREEPER_DROP_MUSIC_DISCS, MatterValueDataProvider.precious(3.3), MatterValueDataProvider.quantum(1.0));
        this.saveData(new Item[]{Items.SCULK, Items.SCULK_VEIN}, MatterValueDataProvider.organic(1.0), MatterValueDataProvider.quantum(1.0));
        this.saveData(new Item[]{Items.SCULK_CATALYST, Items.SCULK_SHRIEKER, Items.SCULK_SENSOR}, MatterValueDataProvider.organic(8.0), MatterValueDataProvider.quantum(8.0));
        this.saveData(new Item[]{Items.WITHER_SKELETON_SKULL, Items.PLAYER_HEAD, Items.ZOMBIE_HEAD, Items.CREEPER_HEAD, Items.PIGLIN_HEAD, Items.DRAGON_HEAD, Items.SKELETON_SKULL}, MatterValueDataProvider.organic(8.0));
        this.saveData(new Item[]{Items.DEAD_TUBE_CORAL_BLOCK, Items.DEAD_BRAIN_CORAL_BLOCK, Items.DEAD_BUBBLE_CORAL_BLOCK, Items.DEAD_FIRE_CORAL_BLOCK, Items.DEAD_HORN_CORAL_BLOCK}, MatterValueDataProvider.organic(6.0));
        this.saveData(new Item[]{Items.CACTUS, Items.VINE, Items.TALL_GRASS, Items.LARGE_FERN, Items.BIG_DRIPLEAF, Items.TORCHFLOWER_SEEDS, Items.PITCHER_POD, Items.SMALL_DRIPLEAF, Items.LILY_PAD, Items.HANGING_ROOTS, Items.GLOW_LICHEN}, MatterValueDataProvider.earth(1.0), MatterValueDataProvider.organic(1.0));
        this.saveData(new Item[]{Items.TUBE_CORAL_BLOCK, Items.BRAIN_CORAL_BLOCK, Items.BUBBLE_CORAL_BLOCK, Items.FIRE_CORAL_BLOCK, Items.HORN_CORAL_BLOCK}, MatterValueDataProvider.organic(6.0), MatterValueDataProvider.living(4.0));
        this.saveData(new Item[]{Items.TUBE_CORAL, Items.BRAIN_CORAL, Items.BUBBLE_CORAL, Items.FIRE_CORAL, Items.HORN_CORAL, Items.TUBE_CORAL_FAN, Items.BRAIN_CORAL_FAN, Items.BUBBLE_CORAL_FAN, Items.FIRE_CORAL_FAN, Items.HORN_CORAL_FAN}, MatterValueDataProvider.organic(2.0), MatterValueDataProvider.living(1.0));
        this.saveData(new Item[]{Items.DEAD_BRAIN_CORAL, Items.DEAD_BUBBLE_CORAL, Items.DEAD_FIRE_CORAL, Items.DEAD_HORN_CORAL, Items.DEAD_TUBE_CORAL, Items.DEAD_TUBE_CORAL_FAN, Items.DEAD_BRAIN_CORAL_FAN, Items.DEAD_BUBBLE_CORAL_FAN, Items.DEAD_FIRE_CORAL_FAN, Items.DEAD_HORN_CORAL_FAN}, MatterValueDataProvider.organic(2.0));
    }

    private void saveData(Item item, MatterValue ... instances) {
        ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation recipeLocation = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)("matter_values/" + rl.getNamespace() + "/items/" + rl.getPath()));
        MatterValueRecipe recipe = new MatterValueRecipe(Ingredient.of((ItemLike[])new ItemLike[]{item}), instances);
        this.recipeOutput.accept(recipeLocation, (Recipe)recipe, null);
    }

    private void saveData(Item[] items, MatterValue ... instances) {
        Arrays.stream(items).forEach(item -> this.saveData((Item)item, instances));
    }

    private void saveTag(TagKey<Item> tag, MatterValue ... instances) {
        ResourceLocation recipeLocation = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)("matter_values/" + tag.location().getNamespace() + "/tags/" + tag.location().getPath()));
        MatterValueRecipe recipe = new MatterValueRecipe(Ingredient.of(tag), instances);
        this.recipeOutput.accept(recipeLocation, (Recipe)recipe, null);
    }

    private static MatterValue metallic(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.METALLIC.get(), d);
    }

    private static MatterValue earth(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.EARTH.get(), d);
    }

    private static MatterValue organic(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.ORGANIC.get(), d);
    }

    private static MatterValue quantum(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.QUANTUM.get(), d);
    }

    private static MatterValue nether(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.NETHER.get(), d);
    }

    private static MatterValue precious(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.PRECIOUS.get(), d);
    }

    private static MatterValue ender(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.ENDER.get(), d);
    }

    private static MatterValue living(double d) {
        return new MatterValue((IMatterType)ReplicationRegistry.Matter.LIVING.get(), d);
    }
}

