/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.render.shader;

import com.buuz135.replication.Replication;
import com.buuz135.replication.client.render.shader.FixedMultiTextureStateShard;
import com.buuz135.replication.client.render.shader.ShaderTexture;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;

public class ReplicationRenderTypes
extends RenderType {
    private static final Map<String, ShaderRenderType> RENDER_TYPES = (Map)Util.make(() -> {
        HashMap<String, ShaderRenderType> map = new HashMap<String, ShaderRenderType>();
        map.put("matter_pipe", new ShaderRenderType("matter_pipe", DefaultVertexFormat.POSITION_TEX, (textures, renderType) -> {
            RenderType.CompositeState compState = RenderType.CompositeState.builder().setShaderState(renderType.shaderState).setTextureState((RenderStateShard.EmptyTextureStateShard)new FixedMultiTextureStateShard((List<ShaderTexture>)textures)).createCompositeState(false);
            return ReplicationRenderTypes.create((String)renderType.formattedName(), (VertexFormat)renderType.format, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)compState);
        }));
        return Collections.unmodifiableMap(map);
    });

    public static Map<String, ShaderRenderType> getRenderTypes() {
        return RENDER_TYPES;
    }

    public static ShaderRenderType getRenderType(String name) {
        return ReplicationRenderTypes.getRenderTypes().get(name);
    }

    private ReplicationRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
        super(s, v, m, i, b, b2, r, r2);
        throw new IllegalStateException("This class is not meant to be constructed!");
    }

    public static class ShaderRenderType {
        private final String name;
        public ShaderInstance shader;
        private final RenderStateShard.ShaderStateShard shaderState = new RenderStateShard.ShaderStateShard(() -> this.shader);
        private final VertexFormat format;
        private final BiFunction<List<ShaderTexture>, ShaderRenderType, RenderType> builder;
        private final ResourceLocation shaderLocation;

        public ShaderRenderType(String name, VertexFormat format, BiFunction<List<ShaderTexture>, ShaderRenderType, RenderType> builder) {
            this.name = name;
            this.format = format;
            this.builder = Util.memoize(builder);
            this.shaderLocation = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)this.name);
        }

        public RenderType using(List<ShaderTexture> textures) {
            return this.builder.apply(textures, this);
        }

        public void register(ResourceProvider resourceManager, BiConsumer<ShaderInstance, Consumer<ShaderInstance>> registerFunc) throws IOException {
            registerFunc.accept(new ShaderInstance(resourceManager, this.shaderLocation(), this.format), this::shader);
        }

        public String formattedName() {
            return "%s_%s".formatted(Replication.MOD_ID, this.name);
        }

        public ResourceLocation shaderLocation() {
            return this.shaderLocation;
        }

        public String name() {
            return this.name;
        }

        public VertexFormat format() {
            return this.format;
        }

        private void shader(ShaderInstance shader) {
            this.shader = shader;
        }
    }
}

