/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.render;

import com.buuz135.replication.Replication;
import com.buuz135.replication.block.MatterPipeBlock;
import com.buuz135.replication.block.tile.MatterPipeBlockEntity;
import com.buuz135.replication.client.render.shader.ReplicationRenderTypes;
import com.buuz135.replication.client.render.shader.ShaderTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class MatterPipeRenderer<T extends MatterPipeBlockEntity>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation END_SKY_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/environment/end_sky.png");
    public static final ResourceLocation END_PORTAL_LOCATION = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/block/pipe_render.png");

    public MatterPipeRenderer(BlockEntityRendererProvider.Context p_173689_) {
    }

    public void render(T p_112650_, float p_112651_, PoseStack p_112652_, MultiBufferSource p_112653_, int p_112654_, int p_112655_) {
        Matrix4f matrix4f = p_112652_.last().pose();
        this.renderCube(p_112650_, matrix4f, p_112653_.getBuffer(this.renderType()));
    }

    private void renderCube(T blockEntity, Matrix4f matrix, VertexConsumer consumer) {
        float f = this.getOffsetDown();
        float f1 = this.getOffsetUp();
        f1 = 0.58f;
        float min = 0.375f;
        float max = 0.625f;
        boolean isNorth = (Boolean)blockEntity.getBlockState().getValue((Property)MatterPipeBlock.DIRECTIONS.get(Direction.NORTH));
        boolean isSouth = (Boolean)blockEntity.getBlockState().getValue((Property)MatterPipeBlock.DIRECTIONS.get(Direction.SOUTH));
        boolean isEast = (Boolean)blockEntity.getBlockState().getValue((Property)MatterPipeBlock.DIRECTIONS.get(Direction.EAST));
        boolean isWest = (Boolean)blockEntity.getBlockState().getValue((Property)MatterPipeBlock.DIRECTIONS.get(Direction.WEST));
        boolean isUp = (Boolean)blockEntity.getBlockState().getValue((Property)MatterPipeBlock.DIRECTIONS.get(Direction.UP));
        boolean isDown = (Boolean)blockEntity.getBlockState().getValue((Property)MatterPipeBlock.DIRECTIONS.get(Direction.DOWN));
        this.renderTop(blockEntity, matrix, consumer, min, max, isNorth, isSouth, isEast, isWest, isUp, isDown);
        this.renderBottom(blockEntity, matrix, consumer, min, max, isNorth, isSouth, isEast, isWest, isUp, isDown);
        this.renderNorthFace(blockEntity, matrix, consumer, min, max, isNorth, isSouth, isEast, isWest, isUp, isDown);
        this.renderSouthFace(blockEntity, matrix, consumer, min, max, isNorth, isSouth, isEast, isWest, isUp, isDown);
        this.renderWestFace(blockEntity, matrix, consumer, min, max, isNorth, isSouth, isEast, isWest, isUp, isDown);
        this.renderEastFace(blockEntity, matrix, consumer, min, max, isNorth, isSouth, isEast, isWest, isUp, isDown);
    }

    private void renderTop(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float min, float max, boolean isNorth, boolean isSouth, boolean isEast, boolean isWest, boolean isUp, boolean isDown) {
        float uMin = blockEntity.getBlockPos().getX();
        float uMax = blockEntity.getBlockPos().getX() + 1;
        float vMin = blockEntity.getBlockPos().getZ();
        float vMax = blockEntity.getBlockPos().getZ() + 1;
        if (!isUp) {
            consumer.addVertex(matrix, min, max, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + min);
        }
        if (isNorth) {
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, max, 0.0f).setUv(uMin + max, vMin);
            consumer.addVertex(matrix, min, max, 0.0f).setUv(uMin + min, vMin);
        }
        if (isSouth) {
            consumer.addVertex(matrix, min, max, 1.0f).setUv(uMin + min, vMax);
            consumer.addVertex(matrix, max, max, 1.0f).setUv(uMin + max, vMax);
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, min, max, max).setUv(uMin + min, vMin + max);
        }
        if (isEast) {
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, 1.0f, max, max).setUv(uMax, vMin + max);
            consumer.addVertex(matrix, 1.0f, max, min).setUv(uMax, vMin + min);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + max, vMin + min);
        }
        if (isWest) {
            consumer.addVertex(matrix, 0.0f, max, max).setUv(uMin, vMin + max);
            consumer.addVertex(matrix, min, max, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, 0.0f, max, min).setUv(uMin, vMin + min);
        }
    }

    private void renderBottom(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float min, float max, boolean isNorth, boolean isSouth, boolean isEast, boolean isWest, boolean isUp, boolean isDown) {
        float uMin = blockEntity.getBlockPos().getX();
        float uMax = blockEntity.getBlockPos().getX() + 1;
        float vMin = blockEntity.getBlockPos().getZ();
        float vMax = blockEntity.getBlockPos().getZ() + 1;
        if (!isDown) {
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + min, vMin + max);
        }
        if (isNorth) {
            consumer.addVertex(matrix, min, min, 0.0f).setUv(uMin + min, vMin);
            consumer.addVertex(matrix, max, min, 0.0f).setUv(uMin + max, vMin);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
        }
        if (isSouth) {
            consumer.addVertex(matrix, min, min, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, min, 1.0f).setUv(uMin + max, vMax);
            consumer.addVertex(matrix, min, min, 1.0f).setUv(uMin + min, vMax);
        }
        if (isEast) {
            consumer.addVertex(matrix, max, min, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, 1.0f, min, min).setUv(uMax, vMin + min);
            consumer.addVertex(matrix, 1.0f, min, max).setUv(uMax, vMin + max);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + max);
        }
        if (isWest) {
            consumer.addVertex(matrix, 0.0f, min, min).setUv(uMin, vMin + min);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, 0.0f, min, max).setUv(uMin, vMin + max);
        }
    }

    private void renderNorthFace(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float min, float max, boolean isNorth, boolean isSouth, boolean isEast, boolean isWest, boolean isUp, boolean isDown) {
        float uMin = blockEntity.getBlockPos().getX();
        float uMax = blockEntity.getBlockPos().getX() + 1;
        float vMin = blockEntity.getBlockPos().getY();
        float vMax = blockEntity.getBlockPos().getY() + 1;
        if (!isNorth) {
            consumer.addVertex(matrix, max, max, min).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + max);
        }
        if (isEast) {
            consumer.addVertex(matrix, 1.0f, max, min).setUv(uMax, vMin + max);
            consumer.addVertex(matrix, 1.0f, min, min).setUv(uMax, vMin + min);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + max, vMin + max);
        }
        if (isWest) {
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, 0.0f, min, min).setUv(uMin, vMin + min);
            consumer.addVertex(matrix, 0.0f, max, min).setUv(uMin, vMin + max);
        }
        if (isUp) {
            consumer.addVertex(matrix, max, 1.0f, min).setUv(uMin + max, vMax);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, min, 1.0f, min).setUv(uMin + min, vMax);
        }
        if (isDown) {
            consumer.addVertex(matrix, max, min, min).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, 0.0f, min).setUv(uMin + max, vMin);
            consumer.addVertex(matrix, min, 0.0f, min).setUv(uMin + min, vMin);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
        }
    }

    private void renderWestFace(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float min, float max, boolean isNorth, boolean isSouth, boolean isEast, boolean isWest, boolean isUp, boolean isDown) {
        float uMin = blockEntity.getBlockPos().getZ();
        float uMax = blockEntity.getBlockPos().getZ() + 1;
        float vMin = blockEntity.getBlockPos().getY();
        float vMax = blockEntity.getBlockPos().getY() + 1;
        if (!isWest) {
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, min, max, max).setUv(uMin + max, vMin + max);
        }
        if (isUp) {
            consumer.addVertex(matrix, min, 1.0f, min).setUv(uMin + min, vMax);
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, min, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, min, 1.0f, max).setUv(uMin + max, vMax);
        }
        if (isDown) {
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, 0.0f, min).setUv(uMin + min, vMin);
            consumer.addVertex(matrix, min, 0.0f, max).setUv(uMin + max, vMin);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + max, vMin + min);
        }
        if (isNorth) {
            consumer.addVertex(matrix, min, max, 0.0f).setUv(uMin, vMin + max);
            consumer.addVertex(matrix, min, min, 0.0f).setUv(uMin, vMin + min);
            consumer.addVertex(matrix, min, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, max, min).setUv(uMin + min, vMin + max);
        }
        if (isSouth) {
            consumer.addVertex(matrix, min, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, min, min, 1.0f).setUv(uMax, vMin + min);
            consumer.addVertex(matrix, min, max, 1.0f).setUv(uMax, vMin + max);
        }
    }

    private void renderEastFace(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float min, float max, boolean isNorth, boolean isSouth, boolean isEast, boolean isWest, boolean isUp, boolean isDown) {
        float uMin = blockEntity.getBlockPos().getZ();
        float uMax = blockEntity.getBlockPos().getZ() + 1;
        float vMin = blockEntity.getBlockPos().getY();
        float vMax = blockEntity.getBlockPos().getY() + 1;
        if (!isEast) {
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + min, vMin + max);
        }
        if (isUp) {
            consumer.addVertex(matrix, max, 1.0f, max).setUv(uMin + max, vMax);
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, max, min).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, max, 1.0f, min).setUv(uMin + min, vMax);
        }
        if (isDown) {
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, 0.0f, max).setUv(uMin + max, vMin);
            consumer.addVertex(matrix, max, 0.0f, min).setUv(uMin + min, vMin);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + min, vMin + min);
        }
        if (isNorth) {
            consumer.addVertex(matrix, max, max, min).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, max, min, min).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, max, min, 0.0f).setUv(uMin, vMin + min);
            consumer.addVertex(matrix, max, max, 0.0f).setUv(uMin, vMin + max);
        }
        if (isSouth) {
            consumer.addVertex(matrix, max, max, 1.0f).setUv(uMax, vMin + max);
            consumer.addVertex(matrix, max, min, 1.0f).setUv(uMax, vMin + min);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
        }
    }

    private void renderSouthFace(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float min, float max, boolean isNorth, boolean isSouth, boolean isEast, boolean isWest, boolean isUp, boolean isDown) {
        float uMin = blockEntity.getBlockPos().getX();
        float uMax = blockEntity.getBlockPos().getX() + 1;
        float vMin = blockEntity.getBlockPos().getY();
        float vMax = blockEntity.getBlockPos().getY() + 1;
        if (!isSouth) {
            consumer.addVertex(matrix, min, max, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
        }
        if (isEast) {
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + min);
            consumer.addVertex(matrix, 1.0f, min, max).setUv(uMax, vMin + min);
            consumer.addVertex(matrix, 1.0f, max, max).setUv(uMax, vMin + max);
        }
        if (isWest) {
            consumer.addVertex(matrix, 0.0f, min, max).setUv(uMin, vMin + min);
            consumer.addVertex(matrix, min, min, max).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, max, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, 0.0f, max, max).setUv(uMin, vMin + max);
        }
        if (isUp) {
            consumer.addVertex(matrix, min, 1.0f, max).setUv(uMin + min, vMax);
            consumer.addVertex(matrix, min, max, max).setUv(uMin + min, vMin + max);
            consumer.addVertex(matrix, max, max, max).setUv(uMin + max, vMin + max);
            consumer.addVertex(matrix, max, 1.0f, max).setUv(uMin + max, vMax);
        }
        if (isDown) {
            consumer.addVertex(matrix, min, min, max).setUv(uMin + min, vMin + min);
            consumer.addVertex(matrix, min, 0.0f, max).setUv(uMin + min, vMin);
            consumer.addVertex(matrix, max, 0.0f, max).setUv(uMin + max, vMin);
            consumer.addVertex(matrix, max, min, max).setUv(uMin + max, vMin + min);
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer consumer, float minX, float maxX, float minY, float maxY, float minZ, float maxZ, float p_173705_, Direction p_173706_) {
        float uMin = blockEntity.getBlockPos().getX();
        float uMax = blockEntity.getBlockPos().getX() + 1;
        float vMin = blockEntity.getBlockPos().getZ();
        float vMax = blockEntity.getBlockPos().getZ() + 1;
        consumer.addVertex(matrix, minX, minY, minZ).setUv(uMin, vMax);
        consumer.addVertex(matrix, maxX, minY, maxZ).setUv(uMax, vMax);
        consumer.addVertex(matrix, maxX, maxY, maxZ).setUv(uMax, vMin);
        consumer.addVertex(matrix, minX, maxY, maxZ).setUv(uMin, vMin);
    }

    private void renderFaces(RenderType renderType, PoseStack stack, MultiBufferSource renderTypeBuffer, AABB pos, double x, double y, double z, float red, float green, float blue, float alpha) {
        float x1 = (float)(pos.minX + x);
        float x2 = (float)(pos.maxX + x);
        float y1 = (float)(pos.minY + y);
        float y2 = (float)(pos.maxY + y);
        float z1 = (float)(pos.minZ + z);
        float z2 = (float)(pos.maxZ + z);
        Matrix4f matrix = stack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(renderType);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
    }

    protected float getOffsetUp() {
        return 0.75f;
    }

    protected float getOffsetDown() {
        return 0.375f;
    }

    protected RenderType renderType() {
        return ReplicationRenderTypes.getRenderType("matter_pipe").using(List.of(new ShaderTexture(ResourceLocation.parse((String)"replication:textures/block/shader.png"))));
    }
}

