/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.client.gui.ReplicationTerminalScreen;
import com.buuz135.replication.client.gui.addons.MatterPatternButton;
import com.buuz135.replication.client.gui.button.ReplicationTerminalTexturedButton;
import com.buuz135.replication.client.gui.button.ReplicationTerminalTexturedCheckbox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class ReplicationRequestWidget
extends AbstractWidget
implements Renderable {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/request_window.png");
    private static final ResourceLocation BUTTONS = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/replication_terminal_extras.png");
    private final MatterPatternButton matterPatternButton;
    private final ReplicationTerminalScreen replicationTerminalScreen;
    private final Button closeButton;
    private final EditBox amountBox;
    private final ReplicationTerminalTexturedCheckbox checkbox;
    private List<AbstractWidget> widgets;

    public ReplicationRequestWidget(int pX, int pY, int pWidth, int pHeight, Component pMessage, MatterPatternButton matterPatternButton, ReplicationTerminalScreen replicationTerminalContainer) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.matterPatternButton = matterPatternButton;
        this.replicationTerminalScreen = replicationTerminalContainer;
        this.widgets = new ArrayList<AbstractWidget>();
        this.closeButton = new ReplicationTerminalTexturedButton(this.getX() + 159, this.getY() + 8, 9, 9, (Component)Component.empty(), BUTTONS, Component.translatable((String)"tooltip.replication.close").getString(), 247, 50, 238, 50, button -> this.replicationTerminalScreen.disableRequest());
        this.widgets.add((AbstractWidget)this.closeButton);
        this.amountBox = new EditBox(Minecraft.getInstance().font, this.getX() + 45, this.getY() + 47, 94, 16, (Component)Component.literal((String)"1"));
        this.amountBox.setMaxLength(50);
        this.amountBox.setBordered(false);
        this.amountBox.setVisible(true);
        this.amountBox.setTextColor(7529831);
        this.amountBox.setValue("1");
        this.widgets.add((AbstractWidget)this.amountBox);
        int[] amount = new int[]{1, 8, 16, 64};
        for (int i = 0; i < amount.length; ++i) {
            int am = amount[i];
            ReplicationTerminalTexturedButton incrementButton = new ReplicationTerminalTexturedButton(this.getX() + 19 + 36 * i, this.getY() + 21, 30, 16, (Component)Component.literal((String)("+" + am)).setStyle(Style.EMPTY.withColor(Mth.color((float)0.44705883f, (float)0.8980392f, (float)0.40392157f))), BUTTONS, Component.literal((String)("+" + am)).getString(), 226, 64, 226, 80, button -> this.addNumber(am));
            this.widgets.add((AbstractWidget)incrementButton);
            ReplicationTerminalTexturedButton decrementButton = new ReplicationTerminalTexturedButton(this.getX() + 19 + 36 * i, this.getY() + 65, 30, 16, (Component)Component.literal((String)("-" + am)).setStyle(Style.EMPTY.withColor(Mth.color((float)0.44705883f, (float)0.8980392f, (float)0.40392157f))), BUTTONS, Component.literal((String)("-" + am)).getString(), 226, 64, 226, 80, button -> this.addNumber(-am));
            this.widgets.add((AbstractWidget)decrementButton);
        }
        this.checkbox = new ReplicationTerminalTexturedCheckbox(this.getX() + 19, this.getY() + 84, 9, 9, (Component)Component.translatable((String)"replication.single_mode"), BUTTONS, 238, 116, true, false);
        this.widgets.add((AbstractWidget)this.checkbox);
        this.widgets.add((AbstractWidget)new ReplicationTerminalTexturedButton(this.getX() + 137, this.getY() + 41, 20, 20, (Component)Component.empty(), BUTTONS, Component.translatable((String)"replication.replicate").getString(), 236, 96, 216, 96, button -> this.replicationTerminalScreen.createTask(matterPatternButton.pattern(), Integer.parseInt(this.amountBox.getValue()), this.checkbox.selected())));
    }

    public void addNumber(int number) {
        long current = Long.parseLong(this.amountBox.getValue());
        current = current == 1L && number != 1 ? (long)number : (current += (long)number);
        if (current <= 0L) {
            current = 1L;
        }
        current = Math.min(current, Integer.MAX_VALUE);
        current = Math.min(current, (long)this.matterPatternButton.cachedAmount());
        this.amountBox.setValue("" + current);
    }

    public List<AbstractWidget> getWidgets() {
        return this.widgets;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        guiGraphics.blit(TEXTURE, this.getX(), this.getY(), 0, 0, 176, 102);
        guiGraphics.renderItem(this.matterPatternButton.pattern().getStack(), this.getX() + 21, this.getY() + 43);
        for (AbstractWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY, v);
        }
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"replication.parallel_mode").setStyle(Style.EMPTY.withColor(Mth.color((float)0.44705883f, (float)0.8980392f, (float)0.40392157f))), this.getX() + 32, this.getY() + 85, 0xFFFFFF, false);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public EditBox getAmountBox() {
        return this.amountBox;
    }

    public void playDownSound(SoundManager pHandler) {
        pHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ReplicationRegistry.Sounds.TERMINAL_BUTTON.get()), (float)1.0f));
    }
}

