/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.block.ReplicatorBlock;
import com.buuz135.replication.block.tile.ReplicatorBlockEntity;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.client.ClientReplicationCalculation;
import com.buuz135.replication.client.MatterTooltipClientComponent;
import com.buuz135.replication.client.MatterTooltipComponent;
import com.buuz135.replication.client.gui.ReplicationTerminalScreen;
import com.buuz135.replication.client.render.ChipStorageRenderer;
import com.buuz135.replication.client.render.DisintegratorRenderer;
import com.buuz135.replication.client.render.IdentificationChamberRenderer;
import com.buuz135.replication.client.render.MatterPipeRenderer;
import com.buuz135.replication.client.render.MatterTankRenderer;
import com.buuz135.replication.client.render.ReplicatorRenderer;
import com.buuz135.replication.client.render.shader.ReplicationRenderTypes;
import com.buuz135.replication.container.ReplicationTerminalContainer;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.io.IOException;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.joml.Matrix4f;

public class ClientEvents {
    public static void init() {
        EventManager.mod(RegisterMenuScreensEvent.class).process(event -> event.register((MenuType)ReplicationTerminalContainer.TYPE.get(), ReplicationTerminalScreen::new)).subscribe();
        EventManager.mod(RegisterClientTooltipComponentFactoriesEvent.class).process(event -> event.register(MatterTooltipComponent.class, MatterTooltipClientComponent::new)).subscribe();
        EventManager.forge(RenderTooltipEvent.GatherComponents.class).process(pre -> {
            MatterCompound instance;
            if (Minecraft.getInstance().level != null && !pre.getItemStack().isEmpty() && (instance = ClientReplicationCalculation.getMatterCompound(pre.getItemStack())) != null && !instance.getValues().isEmpty()) {
                if (Screen.hasShiftDown() || Minecraft.getInstance().screen instanceof ReplicationTerminalScreen) {
                    pre.getTooltipElements().add(Either.right((Object)new MatterTooltipComponent(instance)));
                } else {
                    pre.getTooltipElements().add(Either.left((Object)Component.literal((String)"\u2139 Hold ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"Shift").withStyle(ChatFormatting.YELLOW)).append(" to see matter values").withStyle(ChatFormatting.GRAY)));
                }
            }
        }).subscribe();
        EventManager.forge(ItemTooltipEvent.class).process(pre -> {
            if (ItemStack.isSameItem((ItemStack)pre.getItemStack(), (ItemStack)new ItemStack((ItemLike)ReplicationRegistry.Blocks.MATTER_TANK.getBlock())) && pre.getItemStack().has(ReplicationAttachments.TILE)) {
                CompoundTag tag = (CompoundTag)pre.getItemStack().get(ReplicationAttachments.TILE);
                MatterStack matterStack = MatterStack.loadMatterStackFromNBT(tag.contains("tank") ? tag.getCompound("tank") : tag.getCompound("lockableMatterTankBundle").getCompound("Tank"));
                pre.getToolTip().add(1, Component.translatable((String)"tooltip.titanium.tank.amount").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(matterStack.getAmount()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(256000L) + String.valueOf(ChatFormatting.DARK_AQUA) + " matter"))));
                pre.getToolTip().add(1, Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.replication.tank.matter").getString())).append((Component)(matterStack.isEmpty() ? Component.translatable((String)"tooltip.titanium.tank.empty").withStyle(ChatFormatting.WHITE) : Component.translatable((String)matterStack.getTranslationKey()))).withStyle(ChatFormatting.WHITE));
            }
        }).subscribe();
        EventManager.mod(EntityRenderersEvent.RegisterRenderers.class).process(event -> {
            event.registerBlockEntityRenderer((BlockEntityType)ReplicationRegistry.Blocks.REPLICATOR.type().get(), p_173571_ -> new ReplicatorRenderer());
            event.registerBlockEntityRenderer((BlockEntityType)ReplicationRegistry.Blocks.MATTER_NETWORK_PIPE.type().get(), MatterPipeRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ReplicationRegistry.Blocks.MATTER_TANK.type().get(), MatterTankRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ReplicationRegistry.Blocks.DISINTEGRATOR.type().get(), DisintegratorRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ReplicationRegistry.Blocks.CHIP_STORAGE.type().get(), ChipStorageRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ReplicationRegistry.Blocks.IDENTIFICATION_CHAMBER.type().get(), p_173571_ -> new IdentificationChamberRenderer());
        }).subscribe();
        EventManager.mod(ModelEvent.BakingCompleted.class).process(event -> {
            ReplicatorRenderer.PLATE = ClientEvents.bakeModel(ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"block/replicator_plate"), event.getModelBakery());
            DisintegratorRenderer.BLADE = ClientEvents.bakeModel(ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"block/disintegrator_blade"), event.getModelBakery());
            for (int i = 0; i < 8; ++i) {
                ChipStorageRenderer.CHIP_MODELS.add(ClientEvents.bakeModel(ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)("block/chips/chip_storage_chips_" + i)), event.getModelBakery()));
            }
        }).subscribe();
        EventManager.forge(RenderHighlightEvent.Block.class).process(ClientEvents::blockOverlayEvent).subscribe();
        EventManager.mod(RegisterShadersEvent.class).process(ClientEvents::registerShaders).subscribe();
    }

    private static void registerShaders(RegisterShadersEvent event) {
        try {
            for (ReplicationRenderTypes.ShaderRenderType type : ReplicationRenderTypes.getRenderTypes().values()) {
                type.register(event.getResourceProvider(), (arg_0, arg_1) -> ((RegisterShadersEvent)event).registerShader(arg_0, arg_1));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BakedModel bakeModel(ResourceLocation model, ModelBakery modelBakery) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(model, "standalone");
        UnbakedModel unbakedModel = modelBakery.getModel(model);
        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.sprite(), modelResourceLocation);
        return unbakedModel.bake((ModelBaker)baker, Material::sprite, (ModelState)new SimpleModelState(Transformation.identity()));
    }

    public static void blockOverlayEvent(RenderHighlightEvent.Block event) {
        BlockHitResult traceResult;
        BlockState og;
        Block block;
        if (event.getTarget() != null && (block = (og = Minecraft.getInstance().level.getBlockState((traceResult = event.getTarget()).getBlockPos())).getBlock()) instanceof ReplicatorBlock) {
            ReplicatorBlock replicatorBlock = (ReplicatorBlock)block;
            block = Minecraft.getInstance().level.getBlockEntity(traceResult.getBlockPos());
            if (block instanceof ReplicatorBlockEntity) {
                ReplicatorBlockEntity replicatorBlockEntity = (ReplicatorBlockEntity)block;
                VoxelShape body = (VoxelShape)replicatorBlock.getShapePlate(og).getFirst();
                VoxelShape plate = (VoxelShape)replicatorBlock.getShapePlate(og).getSecond();
                BlockPos blockpos = event.getTarget().getBlockPos();
                event.setCanceled(true);
                PoseStack stack = new PoseStack();
                stack.pushPose();
                Camera info = event.getCamera();
                double d0 = info.getPosition().x();
                double d1 = info.getPosition().y();
                double d2 = info.getPosition().z();
                VertexConsumer builder = event.getMultiBufferSource().getBuffer((RenderType)RenderType.LINES);
                ClientEvents.drawShape(stack, builder, body, (double)blockpos.getX() - d0, (double)blockpos.getY() - d1, (double)blockpos.getZ() - d2, 0.0f, 0.0f, 0.0f, 0.4f);
                stack.translate(0.0f, -0.563f, 0.0f);
                float progress = (float)replicatorBlockEntity.getProgress() / (float)ReplicationConfig.Replicator.MAX_PROGRESS;
                stack.translate(0.0f, 0.563f * progress, 0.0f);
                ClientEvents.drawShape(stack, builder, plate, (double)blockpos.getX() - d0, (double)blockpos.getY() - d1, (double)blockpos.getZ() - d2, 0.0f, 0.0f, 0.0f, 0.4f);
                stack.popPose();
            }
        }
    }

    private static void drawShape(PoseStack matrixStackIn, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStackIn.last().pose();
        PoseStack.Pose posestack$pose = matrixStackIn.last();
        shapeIn.forAllEdges((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
            float f = (float)(p_230013_18_ - p_230013_12_);
            float f1 = (float)(p_230013_20_ - p_230013_14_);
            float f2 = (float)(p_230013_22_ - p_230013_16_);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            bufferIn.addVertex(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).setColor(red, green, blue, alpha).setNormal(posestack$pose, f /= f3, f1 /= f3, f2 /= f3);
            bufferIn.addVertex(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).setColor(red, green, blue, alpha).setNormal(posestack$pose, f, f1, f2);
        });
    }
}

