/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.calculation;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.packet.ReplicationCalculationPacket;
import com.buuz135.replication.recipe.MatterValueRecipe;
import com.buuz135.replication.util.ReplicationTags;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.network.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicationCalculation {
    public static final Logger CALCULATOR_LOG = LogManager.getLogger((String)"Replication Calculator");
    public static HashMap<String, CalculationReference> SORTED_CALCULATION_REFERENCE = new HashMap();
    public static List<RecipeHolder<MatterValueRecipe>> DEFAULT_MATTER_RECIPE = new ArrayList<RecipeHolder<MatterValueRecipe>>();
    public static HashMap<String, MatterCompound> DEFAULT_MATTER_COMPOUND = new HashMap();
    private static CompoundTag cachedSyncTag = new CompoundTag();
    private static HashMap<Ingredient, MatterCompound> INGREDIENT_CACHE = new HashMap();

    public static void init() {
        EventManager.forge(AddReloadListenerEvent.class).process(addReloadListenerEvent -> addReloadListenerEvent.addListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> ReplicationCalculation.organizeRecipes(addReloadListenerEvent.getServerResources().getRecipeManager(), addReloadListenerEvent.getRegistryAccess())))).subscribe();
        EventManager.forge(TagsUpdatedEvent.class).process(tagsUpdatedEvent -> {
            if (tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
                ReplicationCalculation.calculateRecipes(tagsUpdatedEvent.getRegistryAccess());
            }
        }).subscribe();
        EventManager.forge(PlayerEvent.PlayerLoggedInEvent.class).process(playerLoggedInEvent -> {
            Player patt0$temp;
            if (!cachedSyncTag.isEmpty() && (patt0$temp = playerLoggedInEvent.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                Replication.NETWORK.sendTo((Message)new ReplicationCalculationPacket(cachedSyncTag), serverPlayer);
            }
        }).subscribe();
    }

    public static String getNameFromStack(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
    }

    public static void organizeRecipes(RecipeManager recipeManager, RegistryAccess registryAccess) {
        String rl;
        ItemStack result;
        CALCULATOR_LOG.info("Sorting recipes");
        INGREDIENT_CACHE = new HashMap();
        cachedSyncTag = new CompoundTag();
        long time = System.currentTimeMillis();
        DEFAULT_MATTER_COMPOUND = new HashMap();
        DEFAULT_MATTER_RECIPE = recipeManager.getAllRecipesFor((RecipeType)ReplicationRegistry.CustomRecipeTypes.MATTER_VALUE_RECIPE_TYPE.get());
        SORTED_CALCULATION_REFERENCE = new HashMap();
        time = System.currentTimeMillis();
        for (RecipeHolder craftingRecipe : recipeManager.getAllRecipesFor(RecipeType.CRAFTING)) {
            result = ((CraftingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)registryAccess);
            rl = ReplicationCalculation.getNameFromStack(result);
            SORTED_CALCULATION_REFERENCE.computeIfAbsent(rl, string -> new CalculationReference(result, new ArrayList<RecipeReference>())).getReferences().add(new RecipeReference(craftingRecipe.id(), result, (List<Ingredient>)((CraftingRecipe)craftingRecipe.value()).getIngredients()));
        }
        for (RecipeHolder craftingRecipe : recipeManager.getAllRecipesFor(RecipeType.SMELTING)) {
            result = ((SmeltingRecipe)craftingRecipe.value()).getResultItem((HolderLookup.Provider)registryAccess);
            rl = ReplicationCalculation.getNameFromStack(result);
            SORTED_CALCULATION_REFERENCE.computeIfAbsent(rl, string -> new CalculationReference(result, new ArrayList<RecipeReference>())).getReferences().add(new RecipeReference(craftingRecipe.id(), result, (List<Ingredient>)((SmeltingRecipe)craftingRecipe.value()).getIngredients()));
        }
        CALCULATOR_LOG.info("Sorted Recipes in " + (System.currentTimeMillis() - time) + "ms");
    }

    public static void calculateRecipes(RegistryAccess registryAccess) {
        CALCULATOR_LOG.info("Updating replication calculation");
        new Thread(() -> {
            long time = System.currentTimeMillis();
            for (RecipeHolder<MatterValueRecipe> matterValueRecipe : DEFAULT_MATTER_RECIPE) {
                for (ItemStack item : ((MatterValueRecipe)matterValueRecipe.value()).input.getItems()) {
                    String name = ReplicationCalculation.getNameFromStack(item);
                    MatterCompound compound = new MatterCompound();
                    for (MatterValue matterValue : ((MatterValueRecipe)matterValueRecipe.value()).matter) {
                        compound.add(matterValue);
                    }
                    DEFAULT_MATTER_COMPOUND.put(name, compound);
                }
            }
            CALCULATOR_LOG.info("Loaded default values in " + (System.currentTimeMillis() - time) + "ms");
            CompoundTag tempTag = new CompoundTag();
            time = System.currentTimeMillis();
            long timeTracker = System.currentTimeMillis();
            int totalAmount = BuiltInRegistries.ITEM.size();
            for (int i = 0; i < 1; ++i) {
                int checkedAmount = 0;
                int amount = 0;
                for (Item item : BuiltInRegistries.ITEM) {
                    ++checkedAmount;
                    if (System.currentTimeMillis() - timeTracker > 10000L) {
                        CALCULATOR_LOG.info("Progress " + checkedAmount + " of " + totalAmount + " items");
                        timeTracker = System.currentTimeMillis();
                    }
                    try {
                        MatterCompound compound;
                        String rl;
                        ItemStack stack = item.getDefaultInstance();
                        if (stack.isEmpty() || !DEFAULT_MATTER_COMPOUND.containsKey(rl = ReplicationCalculation.getNameFromStack(stack)) && !SORTED_CALCULATION_REFERENCE.containsKey(rl) || (compound = ReplicationCalculation.getMatterCompound(stack, 0, new ArrayList<String>(), new ArrayList<String>(), false)) == null || compound.getValues().isEmpty()) continue;
                        tempTag.put(rl, (Tag)compound.serializeNBT((HolderLookup.Provider)registryAccess));
                        ++amount;
                    }
                    catch (Exception e) {
                        CALCULATOR_LOG.info("Failed to calculate " + String.valueOf(item), (Throwable)e);
                    }
                }
                CALCULATOR_LOG.info("Resolved " + amount + " values in " + (System.currentTimeMillis() - time) + "ms");
            }
            cachedSyncTag = tempTag;
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                    Replication.NETWORK.sendTo((Message)new ReplicationCalculationPacket(cachedSyncTag), player);
                }
            }
        }, "Replication").start();
    }

    @Nullable
    public static MatterCompound getMatterCompound(ItemStack stack) {
        return ReplicationCalculation.getMatterCompound(stack, 0, new ArrayList<String>(), new ArrayList<String>(), false);
    }

    private static MatterCompound getMatterCompound(ItemStack item, int depth, List<String> visitedRecipes, List<String> visitedCalculations, boolean printDebug) {
        MatterCompound result = null;
        result = ReplicationCalculation.getMatterCompound(item, depth, visitedRecipes, visitedCalculations, printDebug, result);
        return result;
    }

    private static MatterCompound getMatterCompound(ItemStack item, int depth, List<String> visitedRecipes, List<String> visitedCalculations, boolean printDebug, MatterCompound result) {
        MatterCompound defaultValue = ReplicationCalculation.getDefaultValue(item);
        if (defaultValue != null) {
            if (printDebug) {
                CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "Found default value for " + item.toString());
            }
            result = result == null ? defaultValue : result.compare(defaultValue);
        } else {
            if (ReplicationConfig.RecipeCalculation.MAX_RECIPE_DEPTH == 0) {
                return null;
            }
            if (item.is(ReplicationTags.SKIP_CALCULATION)) {
                return null;
            }
            String name = ReplicationCalculation.getNameFromStack(item);
            if (SORTED_CALCULATION_REFERENCE.containsKey(name)) {
                MatterCompound temp;
                if (printDebug) {
                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "Calculating value for " + String.valueOf(item));
                }
                if ((temp = SORTED_CALCULATION_REFERENCE.get(name).resolve(depth, visitedRecipes, visitedCalculations, printDebug)) != null) {
                    result = result == null ? temp : result.compare(temp);
                }
            }
        }
        return result;
    }

    private static MatterCompound getMatterCompound(Ingredient input, int depth, List<String> visitedRecipes, List<String> visitedCalculations, boolean printDebug) {
        if (INGREDIENT_CACHE.containsKey(input)) {
            return INGREDIENT_CACHE.get(input);
        }
        MatterCompound result = null;
        for (ItemStack item : input.getItems()) {
            MatterCompound temp = ReplicationCalculation.getMatterCompound(item, depth, visitedRecipes, visitedCalculations, printDebug, result);
            result = result == null ? temp : result.compare(temp);
        }
        if (result != null) {
            INGREDIENT_CACHE.put(input, result);
        }
        return result;
    }

    private static MatterCompound getDefaultValue(ItemStack stack) {
        if (DEFAULT_MATTER_COMPOUND.containsKey(ReplicationCalculation.getNameFromStack(stack))) {
            return DEFAULT_MATTER_COMPOUND.get(ReplicationCalculation.getNameFromStack(stack));
        }
        return null;
    }

    private static String repeatChar(char character, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be non-negative.");
        }
        StringBuilder builder = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            builder.append(character);
        }
        return builder.toString();
    }

    private static class CalculationReference {
        private final List<RecipeReference> references;
        private final ItemStack stack;
        private final String name;
        private boolean resolved = false;
        private MatterCompound cached;

        public CalculationReference(ItemStack stack, List<RecipeReference> references) {
            this.references = references;
            this.stack = stack;
            this.name = ReplicationCalculation.getNameFromStack(stack);
        }

        public MatterCompound resolve(int depth, List<String> visitedRecipes, List<String> visitedCalculations, boolean printDebug) {
            if (visitedCalculations.contains(this.name)) {
                return null;
            }
            visitedCalculations.add(this.name);
            if (this.references.size() == 0) {
                CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "FOUND NO RECIPES FOR " + this.stack.toString());
            }
            if (this.resolved) {
                if (printDebug) {
                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "RESOLVED_" + (this.cached == null ? null : this.cached.toString()));
                }
                return this.cached;
            }
            MatterCompound result = ReplicationCalculation.getDefaultValue(this.stack);
            if (result != null) {
                this.resolved = true;
                this.cached = result;
                if (printDebug) {
                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "DEFAULT_" + this.cached.toString());
                }
                return this.cached;
            }
            if (visitedCalculations.size() > ReplicationConfig.RecipeCalculation.MAX_RECIPE_DEPTH || visitedRecipes.size() > ReplicationConfig.RecipeCalculation.MAX_VISITED_RECIPES) {
                if (printDebug) {
                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "POSIBLE INFINTE LOOP FOUND, BREAKING");
                }
                return this.cached;
            }
            for (RecipeReference reference : this.references) {
                if (printDebug) {
                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "Visiting Recipe: " + String.valueOf(reference.getName()));
                }
                if (visitedRecipes.contains(reference.getName().toString())) continue;
                if (printDebug) {
                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + reference.getName().toString());
                }
                MatterCompound temp = null;
                if (reference.getCachedCompound() != null) {
                    temp = reference.getCachedCompound();
                    if (printDebug) {
                        CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "RECIPECACHE" + String.valueOf(temp));
                    }
                } else {
                    visitedRecipes.add(reference.getName().toString());
                    for (Ingredient input : reference.inputs) {
                        if (input.getItems().length == 0) continue;
                        ArrayList<String> tempVisitedRecipes = new ArrayList<String>(visitedRecipes);
                        ArrayList<String> tempVisitedCalculations = new ArrayList<String>(visitedCalculations);
                        MatterCompound inputMatter = ReplicationCalculation.getMatterCompound(input, depth + 1, tempVisitedRecipes, tempVisitedCalculations, printDebug);
                        tempVisitedRecipes = null;
                        tempVisitedCalculations = null;
                        if (inputMatter == null) {
                            if (printDebug) {
                                CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "ONE INGREDIENT DOESNT HAVE VALUE " + input.getItems().length);
                                for (ItemStack item : input.getItems()) {
                                    CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 2) + "\\" + ReplicationCalculation.repeatChar('_', depth + 2) + item.toString());
                                }
                            }
                            temp = null;
                            break;
                        }
                        if (temp == null) {
                            temp = new MatterCompound();
                        }
                        temp.add(inputMatter);
                    }
                    if (temp != null) {
                        temp.divide(reference.getOutput().getCount());
                        reference.setCachedCompound(temp);
                    }
                    if (printDebug) {
                        CALCULATOR_LOG.info(ReplicationCalculation.repeatChar(' ', depth + 1) + "\\" + ReplicationCalculation.repeatChar('_', depth + 1) + "CALCULATED_" + String.valueOf(temp));
                    }
                }
                if (temp != null) {
                    if (result == null) {
                        if (!temp.getValues().isEmpty()) {
                            result = temp;
                        }
                    } else {
                        result = result.compare(temp);
                    }
                }
                temp = null;
            }
            if (result != null) {
                this.resolved = true;
                this.cached = result;
                return this.cached;
            }
            return result;
        }

        public List<RecipeReference> getReferences() {
            return this.references;
        }
    }

    private static class RecipeReference {
        private final ResourceLocation name;
        private final ItemStack output;
        private final List<Ingredient> inputs;
        private MatterCompound cachedCompound;

        public RecipeReference(ResourceLocation name, ItemStack output, List<Ingredient> inputs) {
            this.name = name;
            this.output = output;
            this.inputs = inputs;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public List<Ingredient> getInputs() {
            return this.inputs;
        }

        public void setCachedCompound(MatterCompound cachedCompound) {
            this.cachedCompound = cachedCompound;
        }

        public MatterCompound getCachedCompound() {
            return this.cachedCompound;
        }
    }
}

