/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.calculation;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.calculation.MatterValue;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MatterCompound
implements INBTSerializable<CompoundTag> {
    private final HashMap<IMatterType, MatterValue> values = new HashMap();
    private double cachedWeight = 2.147483647E9;

    public MatterCompound add(MatterValue value) {
        this.values.computeIfAbsent(value.getMatter(), iMatterType -> new MatterValue((IMatterType)iMatterType, 0.0)).add(value.getAmount());
        this.cachedWeight = this.getWeight();
        return this;
    }

    public MatterCompound add(MatterCompound other) {
        if (other != null) {
            for (MatterValue value : other.getValues().values()) {
                this.add(value);
            }
        }
        return this;
    }

    public MatterCompound compare(MatterCompound other) {
        return other == null || this.getCachedWeight() < other.getCachedWeight() ? this : other;
    }

    public MatterCompound divide(double amount) {
        for (MatterValue value : this.values.values()) {
            value.setAmount(value.getAmount() / amount);
        }
        this.cachedWeight = this.getWeight();
        return this;
    }

    public double getWeight() {
        double amount = 0.0;
        for (MatterValue value : this.values.values()) {
            amount += value.getAmount();
        }
        return amount;
    }

    public double getCachedWeight() {
        return this.cachedWeight;
    }

    public HashMap<IMatterType, MatterValue> getValues() {
        return this.values;
    }

    public String toString() {
        return "MatterCompound{values=" + String.valueOf(this.values) + "}";
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        for (MatterValue value : this.getValues().values()) {
            tag.put(value.getMatter().getName(), (Tag)value.serializeNBT(provider));
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.values.clear();
        for (String allKey : compoundTag.getAllKeys()) {
            MatterValue matterValue = new MatterValue((IMatterType)ReplicationRegistry.Matter.EMPTY.get(), 0.0);
            matterValue.deserializeNBT(provider, compoundTag.getCompound(allKey));
            this.values.put(matterValue.getMatter(), matterValue);
        }
    }
}

