/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.api.task.ReplicationTask;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.client.gui.addons.ReplicatorCraftingAddon;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IEnumValues;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.api.redstone.IRedstoneReader;
import com.hrznstudio.titanium.api.redstone.IRedstoneState;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.redstone.RedstoneAction;
import com.hrznstudio.titanium.block.redstone.RedstoneManager;
import com.hrznstudio.titanium.block.redstone.RedstoneState;
import com.hrznstudio.titanium.client.screen.addon.ItemstackFilterScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.button.RedstoneControlButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class ReplicatorBlockEntity
extends ReplicationMachine<ReplicatorBlockEntity>
implements IRedstoneReader {
    public static final float LOWER_PROGRESS = 0.563f;
    @Save
    private int progress = ReplicationConfig.Replicator.MAX_PROGRESS;
    @Save
    private int action = 1;
    @Save
    private ProgressBarComponent<ReplicatorBlockEntity> progressBarComponent;
    @Save
    private SidedInventoryComponent<ReplicatorBlockEntity> output;
    @Save
    private String craftingTask;
    @Save
    private ItemStack craftingStack = ItemStack.EMPTY;
    private IReplicationTask cachedReplicationTask;
    @Save
    private RedstoneManager<RedstoneAction> redstoneManager;
    private RedstoneControlButtonComponent<RedstoneAction> redstoneButton;
    @Save
    private ItemStackFilter infiniteCrafting;

    public ReplicatorBlockEntity(BasicTileBlock<ReplicatorBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.progressBarComponent = new ProgressBarComponent(26, 25, 0, ReplicationConfig.Replicator.MAX_PROGRESS * 2).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP);
        this.addProgressBar(this.progressBarComponent);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 42, 63, 7, 0).setColor(14592060).setInputFilter((stack, integer) -> false).setColorGuiEnabled(false);
        this.addInventory((InventoryComponent)this.output);
        this.redstoneManager = new RedstoneManager((IEnumValues)RedstoneAction.IGNORE, false);
        this.redstoneButton = new RedstoneControlButtonComponent(154, 84, 14, 14, () -> this.redstoneManager, () -> this);
        this.addButton((ButtonComponent)this.redstoneButton);
        this.infiniteCrafting = new ItemStackFilter("infiniteCrafting", 1){

            public void setFilter(int slot, ItemStack stack) {
                super.setFilter(slot, stack.getItem().getDefaultInstance());
            }

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
                list.add(() -> new ItemstackFilterScreenAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        for (FilterSlot filterSlot : ReplicatorBlockEntity.this.infiniteCrafting.getFilterSlots()) {
                            if (filterSlot == null) continue;
                            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)Objects.requireNonNull(provider.getAsset(AssetTypes.SLOT)), (int)(guiX + filterSlot.getX()), (int)(guiY + filterSlot.getY()));
                            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            if (((ItemStack)filterSlot.getFilter()).isEmpty()) continue;
                            Lighting.setupFor3DItems();
                            guiGraphics.renderItem((ItemStack)filterSlot.getFilter(), filterSlot.getX() + guiX + 1, filterSlot.getY() + guiY + 1);
                        }
                    }
                });
                return list;
            }
        };
        this.infiniteCrafting.getFilterSlots()[0] = new FilterSlot(43, 28, 0, (Object)ItemStack.EMPTY);
        this.addFilter((IFilter)this.infiniteCrafting);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new ReplicatorCraftingAddon(50, 30, this));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, ReplicatorBlockEntity blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (((RedstoneAction)this.redstoneManager.getAction()).canRun(this.getEnvironmentValue(false, null)) && this.redstoneManager.shouldWork()) {
            IReplicationTask task;
            this.tickProgress();
            this.progressBarComponent.setProgress(this.action == 1 ? ReplicationConfig.Replicator.MAX_PROGRESS - this.progress : ReplicationConfig.Replicator.MAX_PROGRESS + this.progress);
            this.syncObject(this.progressBarComponent);
            if (this.level.getGameTime() % 20L == 0L && this.craftingTask == null && this.cachedReplicationTask == null && !((ItemStack)this.infiniteCrafting.getFilterSlots()[0].getFilter()).isEmpty()) {
                task = new ReplicationTask(((ItemStack)this.infiniteCrafting.getFilterSlots()[0].getFilter()).copy(), 1, IReplicationTask.Mode.SINGLE, this.getBlockPos());
                ((ReplicationTask)task).acceptReplicator(this.getBlockPos());
                this.craftingTask = ((ReplicationTask)task).getUuid().toString();
                this.cachedReplicationTask = task;
                this.craftingStack = ((ReplicationTask)task).getReplicatingStack();
                this.syncObject(this.craftingStack);
                this.getNetwork().getTaskManager().getPendingTasks().put(((ReplicationTask)task).getUuid().toString(), task);
                this.getNetwork().onTaskValueChanged(task, (ServerLevel)this.level);
            }
            if (this.level.getGameTime() % 20L == 0L && this.craftingTask == null && (task = this.getNetwork().getTaskManager().findTaskForReplicator(this.getBlockPos(), this.getNetwork())) != null) {
                task.acceptReplicator(this.getBlockPos());
                this.craftingTask = task.getUuid().toString();
                this.cachedReplicationTask = task;
                this.craftingStack = task.getReplicatingStack();
                this.syncObject(this.craftingStack);
                this.getNetwork().onTaskValueChanged(task, (ServerLevel)this.level);
            }
            if (this.level.getGameTime() % 20L == 0L && this.craftingTask != null && this.cachedReplicationTask == null && this.getNetwork().getTaskManager().getPendingTasks().containsKey(this.craftingTask)) {
                this.cachedReplicationTask = this.getNetwork().getTaskManager().getPendingTasks().get(this.craftingTask);
                this.craftingStack = this.cachedReplicationTask.getReplicatingStack();
                this.syncObject(this.craftingStack);
            }
            if (this.level.getGameTime() % 20L == 0L && this.craftingTask != null && this.cachedReplicationTask != null && !this.cachedReplicationTask.getStoredMatterStack().containsKey(this.getBlockPos().asLong())) {
                this.cachedReplicationTask.storeMatterStacksFor(this.level, this.getBlockPos(), this.getNetwork());
            }
        }
    }

    @NotNull
    public ReplicatorBlockEntity getSelf() {
        return this;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, ReplicatorBlockEntity blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
    }

    private void tickProgress() {
        if (this.craftingTask != null && this.getEnergyStorage().getEnergyStored() > ReplicationConfig.Replicator.POWER_TICK && this.cachedReplicationTask != null && this.cachedReplicationTask.getStoredMatterStack().containsKey(this.getBlockPos().asLong())) {
            if (this.action == 0) {
                if (this.progress >= ReplicationConfig.Replicator.MAX_PROGRESS) {
                    if (ItemHandlerHelper.insertItem(this.output, (ItemStack)this.craftingStack.copy(), (boolean)true).isEmpty()) {
                        this.action = 1;
                        this.syncObject(this.action);
                        this.replicateItem();
                    }
                } else {
                    this.getEnergyStorage().extractEnergy(ReplicationConfig.Replicator.POWER_TICK, false);
                    ++this.progress;
                }
                this.syncObject(this.progress);
            } else {
                --this.progress;
                this.getEnergyStorage().extractEnergy(ReplicationConfig.Replicator.POWER_TICK, false);
                this.syncObject(this.progress);
                if (this.progress <= 0) {
                    this.action = 0;
                    this.syncObject(this.action);
                }
            }
            this.markComponentDirty();
        }
        if (this.craftingTask == null && this.progress < ReplicationConfig.Replicator.MAX_PROGRESS) {
            this.action = 1;
            ++this.progress;
            this.syncObject(this.action);
            this.syncObject(this.progress);
        }
    }

    @Override
    @NotNull
    protected EnergyStorageComponent<ReplicatorBlockEntity> createEnergyStorage() {
        return new EnergyStorageComponent(25000, 7, 25);
    }

    private void replicateItem() {
        this.cachedReplicationTask.finalizeReplication(this.level, this.getBlockPos(), this.getNetwork());
        this.getNetwork().onTaskValueChanged(this.cachedReplicationTask, (ServerLevel)this.level);
        if (!this.getBlockPos().equals((Object)this.cachedReplicationTask.getSource())) {
            IItemHandler capability = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.cachedReplicationTask.getSource(), (Object)Direction.UP);
            if (capability != null) {
                if (!ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)this.cachedReplicationTask.getReplicatingStack().copyWithCount(1), (boolean)false).isEmpty()) {
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)this.cachedReplicationTask.getReplicatingStack().copyWithCount(1), (boolean)false);
                }
            } else {
                ItemHandlerHelper.insertItem(this.output, (ItemStack)this.cachedReplicationTask.getReplicatingStack().copyWithCount(1), (boolean)false);
            }
        } else {
            ItemHandlerHelper.insertItem(this.output, (ItemStack)this.cachedReplicationTask.getReplicatingStack().copyWithCount(1), (boolean)false);
        }
        this.cachedReplicationTask = null;
        this.craftingStack = ItemStack.EMPTY;
        this.craftingTask = null;
        this.redstoneManager.finish();
        this.syncObject(this.craftingStack);
    }

    @Override
    public void setRemoved() {
        if (this.cachedReplicationTask != null) {
            this.cachedReplicationTask.getReplicatorsOnTask().remove(this.getBlockPos().asLong());
            if (this.cachedReplicationTask.getReplicatorsOnTask().isEmpty()) {
                this.getNetwork().cancelTask(this.craftingTask, this.level);
            }
        }
        super.setRemoved();
    }

    public void cancelTask() {
        this.cachedReplicationTask = null;
        this.craftingStack = ItemStack.EMPTY;
        this.craftingTask = null;
        this.redstoneManager.finish();
        this.syncObject(this.craftingStack);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getAction() {
        return this.action;
    }

    public ItemStack getCraftingStack() {
        return this.craftingStack;
    }

    public boolean isInfinite() {
        return !((ItemStack)this.infiniteCrafting.getFilterSlots()[0].getFilter()).isEmpty();
    }

    public IRedstoneState getEnvironmentValue(boolean strongPower, Direction direction) {
        if (strongPower) {
            if (direction == null) {
                return this.level.hasNeighborSignal(this.worldPosition) ? RedstoneState.ON : RedstoneState.OFF;
            }
            return this.level.hasSignal(this.worldPosition, direction) ? RedstoneState.ON : RedstoneState.OFF;
        }
        return this.level.getBestNeighborSignal(this.worldPosition) > 0 ? RedstoneState.ON : RedstoneState.OFF;
    }

    public void onNeighborChanged(Block blockIn, BlockPos fromPos) {
        super.onNeighborChanged(blockIn, fromPos);
        this.redstoneManager.setLastRedstoneState(this.getEnvironmentValue(false, null).isReceivingRedstone());
    }

    public int getTitleColor() {
        return 7529831;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 16.0f;
    }
}

