/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.client.gui.ReplicationAddonProvider;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ReplicationMachine<T extends NetworkBlockEntity<T>>
extends NetworkBlockEntity<T> {
    @Save
    private final EnergyStorageComponent<T> energyStorage = this.createEnergyStorage();

    public ReplicationMachine(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.energyStorage.setComponentHarness((IComponentHarness)((NetworkBlockEntity)this.getSelf()));
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
    }

    public ItemInteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return ItemInteractionResult.SUCCESS;
    }

    @Nonnull
    public EnergyStorageComponent<T> getEnergyStorage() {
        return this.energyStorage;
    }

    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List screenAddons = super.getScreenAddons();
        screenAddons.addAll(this.getEnergyStorage().getScreenAddons());
        return screenAddons;
    }

    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        List containerAddons = super.getContainerAddons();
        containerAddons.addAll(this.getEnergyStorage().getContainerAddons());
        return containerAddons;
    }

    @Nonnull
    protected EnergyStorageComponent<T> createEnergyStorage() {
        return new EnergyStorageComponent(25000, 9, 28);
    }

    public IAssetProvider getAssetProvider() {
        return ReplicationAddonProvider.INSTANCE;
    }
}

