/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.pattern.IMatterPatternHolder;
import com.buuz135.replication.api.pattern.IMatterPatternModifier;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.client.gui.addons.IdentificationChamberAddon;
import com.buuz135.replication.util.InvUtil;
import com.buuz135.replication.util.ReplicationTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.util.FacingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class IdentificationChamberBlockEntity
extends ReplicationMachine<IdentificationChamberBlockEntity> {
    public static final float LOWER_PROGRESS = 0.58f;
    @Save
    private SidedInventoryComponent<?> input = (SidedInventoryComponent)new SidedInventoryComponent("input", 44, 48, 1, 0).disableFacingAddon().setInputFilter((itemStack, integer) -> ReplicationCalculation.getMatterCompound(itemStack) != null || itemStack.is((Item)ReplicationRegistry.Items.MATTER_BLUEPRINT.get())).setOutputFilter((itemStack, integer) -> false).setSlotLimit(1).setOnSlotChanged((stack, integer) -> this.syncObject(this.input)).setColorGuiEnabled(false);
    @Save
    private ProgressBarComponent<?> progressBarComponent;
    @Save
    private SidedInventoryComponent<?> memoryChipInput;
    @Save
    private SidedInventoryComponent<?> memoryChipOutput;

    public IdentificationChamberBlockEntity(BasicTileBlock<IdentificationChamberBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        InvUtil.disableAllSidesAndEnable(this.input, (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL), IFacingComponent.FaceMode.ENABLED, FacingUtil.Sideness.BOTTOM, FacingUtil.Sideness.BACK);
        this.addInventory((InventoryComponent)this.input);
        this.progressBarComponent = new ProgressBarComponent(72, 48, ReplicationConfig.IdentificationChamber.MAX_PROGRESS * 2).setCanIncrease(iComponentHarness -> this.canIncrease()).setOnTickWork(() -> this.syncObject(this.progressBarComponent)).setOnFinishWork(this::onFinish).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT);
        this.addProgressBar(this.progressBarComponent);
        this.memoryChipInput = (SidedInventoryComponent)new SidedInventoryComponent("memoryChipInput", 106, 30, 3, 0).disableFacingAddon().setInputFilter((itemStack, integer) -> itemStack.getItem() instanceof IMatterPatternHolder).setOutputFilter((itemStack, integer) -> false).setSlotPosition(integer -> Pair.of((Object)0, (Object)(18 * integer))).setColorGuiEnabled(false);
        InvUtil.disableAllSidesAndEnable(this.memoryChipInput, (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL), IFacingComponent.FaceMode.ENABLED, FacingUtil.Sideness.BOTTOM, FacingUtil.Sideness.BACK);
        this.addInventory((InventoryComponent)this.memoryChipInput);
        this.memoryChipOutput = (SidedInventoryComponent)new SidedInventoryComponent("memoryChipOutput", 142, 30, 3, 0).disableFacingAddon().setInputFilter((itemStack, integer) -> false).setOutputFilter((itemStack, integer) -> true).setSlotPosition(integer -> Pair.of((Object)0, (Object)(18 * integer))).setColorGuiEnabled(false);
        InvUtil.disableAllSidesAndEnable(this.memoryChipOutput, (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL), IFacingComponent.FaceMode.ENABLED, FacingUtil.Sideness.BOTTOM, FacingUtil.Sideness.BACK);
        this.addInventory((InventoryComponent)this.memoryChipOutput);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new IdentificationChamberAddon(50, 30, this));
    }

    private void onFinish() {
        ItemStack input = this.getInput().getStackInSlot(0).getItem().getDefaultInstance();
        if (!input.isEmpty()) {
            for (int i = 0; i < this.memoryChipInput.getSlots(); ++i) {
                Item item;
                ItemStack stack = this.memoryChipInput.getStackInSlot(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof IMatterPatternModifier)) continue;
                IMatterPatternModifier patternModifier = (IMatterPatternModifier)item;
                IMatterPatternModifier.ModifierAction returnedValue = null;
                if (input.has(ReplicationAttachments.BLUEPRINT)) {
                    input = this.getInput().getStackInSlot(0);
                    ItemStack item2 = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CompoundTag)input.get(ReplicationAttachments.BLUEPRINT)).getCompound("Item"));
                    double progress = ((CompoundTag)input.get(ReplicationAttachments.BLUEPRINT)).getDouble("Progress");
                    returnedValue = patternModifier.addPattern(this.level, stack, item2, (float)progress);
                    this.getInput().getStackInSlot(0).shrink(1);
                    this.syncObject(this.input);
                } else {
                    returnedValue = patternModifier.addPattern(this.level, stack, input, 0.2f);
                }
                if (returnedValue.getPattern() != null && returnedValue.getPattern().getCompletion() >= 1.0f) {
                    this.getInput().getStackInSlot(0).shrink(1);
                    this.syncObject(this.input);
                }
                if (returnedValue.getPattern() != null) {
                    this.getEnergyStorage().extractEnergy(ReplicationConfig.IdentificationChamber.POWER_USAGE, false);
                }
                if (returnedValue.getType() == IMatterPatternModifier.ModifierType.FULL && returnedValue.getPattern() != null) {
                    ItemStack exportingItem = stack.copy();
                    for (int z = 0; z < this.memoryChipOutput.getSlots(); ++z) {
                        if (!this.memoryChipOutput.getStackInSlot(z).isEmpty()) continue;
                        this.memoryChipOutput.setStackInSlot(z, exportingItem);
                        stack.shrink(1);
                        return;
                    }
                }
                if (returnedValue.getPattern() != null) break;
            }
        }
    }

    private boolean canIncrease() {
        int i;
        if (this.getEnergyStorage().getEnergyStored() <= ReplicationConfig.IdentificationChamber.POWER_USAGE) {
            return false;
        }
        if (this.input.getStackInSlot(0).isEmpty()) {
            return false;
        }
        if (this.input.getStackInSlot(0).is(ReplicationTags.CANT_BE_SCANNED)) {
            return false;
        }
        boolean hasOutputSlot = false;
        for (i = 0; i < this.memoryChipOutput.getSlots(); ++i) {
            if (!this.memoryChipOutput.getStackInSlot(i).isEmpty()) continue;
            hasOutputSlot = true;
            break;
        }
        if (!hasOutputSlot) {
            return false;
        }
        for (i = 0; i < this.memoryChipInput.getSlots(); ++i) {
            if (this.memoryChipInput.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public IdentificationChamberBlockEntity getSelf() {
        return this;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, IdentificationChamberBlockEntity blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, IdentificationChamberBlockEntity blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
    }

    public int getProgress() {
        if (this.progressBarComponent.getProgress() > ReplicationConfig.IdentificationChamber.MAX_PROGRESS) {
            return ReplicationConfig.IdentificationChamber.MAX_PROGRESS * 2 - this.progressBarComponent.getProgress();
        }
        return this.progressBarComponent.getProgress();
    }

    public SidedInventoryComponent<?> getInput() {
        return this.input;
    }

    public int getTitleColor() {
        return 7529831;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 16.0f;
    }
}

