/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.ReplicationConfig;
import com.buuz135.replication.api.matter_fluid.IMatterTank;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.api.matter_fluid.component.MatterTankComponent;
import com.buuz135.replication.api.network.IMatterTanksSupplier;
import com.buuz135.replication.block.tile.ReplicationMachine;
import com.buuz135.replication.calculation.MatterCompound;
import com.buuz135.replication.calculation.MatterValue;
import com.buuz135.replication.calculation.ReplicationCalculation;
import com.buuz135.replication.client.gui.addons.DisintegratorAddon;
import com.buuz135.replication.util.InvUtil;
import com.buuz135.replication.util.ReplicationTags;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class DisintegratorBlockEntity
extends ReplicationMachine<DisintegratorBlockEntity>
implements IMatterTanksSupplier {
    @Save
    private SidedInventoryComponent<?> input;
    @Save
    private ProgressBarComponent<?> progressBarComponent;
    @Save
    private MatterTankComponent<DisintegratorBlockEntity> tank1;
    @Save
    private MatterTankComponent<DisintegratorBlockEntity> tank2;
    @Save
    private MatterTankComponent<DisintegratorBlockEntity> tank3;
    @Save
    private MatterTankComponent<DisintegratorBlockEntity> tank4;
    @Save
    private MatterTankComponent<DisintegratorBlockEntity> tank5;
    @Save
    private MatterTankComponent<DisintegratorBlockEntity> tank6;
    private Queue<MatterStack> queuedMatterStacks = new ArrayDeque<MatterStack>();

    public DisintegratorBlockEntity(BasicTileBlock<DisintegratorBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.input = (SidedInventoryComponent)new SidedInventoryComponent("input", 29, 30, 3, 0).disableFacingAddon().setInputFilter((itemStack, integer) -> ReplicationCalculation.getMatterCompound(itemStack) != null).setOutputFilter((itemStack, integer) -> false).setSlotLimit(64).setSlotPosition(integer -> Pair.of((Object)0, (Object)(18 * integer))).setOnSlotChanged((stack, integer) -> this.syncObject(this.input)).setColorGuiEnabled(false);
        InvUtil.disableAllSidesAndEnable(this.input, (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL), IFacingComponent.FaceMode.ENABLED, FacingUtil.Sideness.BOTTOM, FacingUtil.Sideness.BACK, FacingUtil.Sideness.TOP);
        this.addInventory((InventoryComponent)this.input);
        this.progressBarComponent = new ProgressBarComponent(48, 28, ReplicationConfig.Disintegrator.MAX_PROGRESS).setOnTickWork(() -> this.syncObject(this.progressBarComponent)).setCanIncrease(iComponentHarness -> {
            if (!this.queuedMatterStacks.isEmpty()) {
                return false;
            }
            if (this.getEnergyStorage().getEnergyStored() < ReplicationConfig.Disintegrator.POWER_USAGE) {
                return false;
            }
            for (int i = 0; i < this.input.getSlots(); ++i) {
                ItemStack stack = this.input.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                return true;
            }
            return false;
        }).setOnFinishWork(this::onFinish).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP);
        this.addProgressBar(this.progressBarComponent);
        this.tank1 = this.createMatterTank(1);
        this.tank2 = this.createMatterTank(2);
        this.tank3 = this.createMatterTank(3);
        this.tank4 = this.createMatterTank(4);
        this.tank5 = this.createMatterTank(5);
        this.tank6 = this.createMatterTank(6);
        this.addMatterTank(this.tank1);
        this.addMatterTank(this.tank2);
        this.addMatterTank(this.tank3);
        this.addMatterTank(this.tank4);
        this.addMatterTank(this.tank5);
        this.addMatterTank(this.tank6);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DisintegratorAddon(50, 30, this));
    }

    private void onFinish() {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            MatterCompound data;
            ItemStack stack = this.input.getStackInSlot(i);
            if (stack.isEmpty() || stack.is(ReplicationTags.CANT_BE_DISINTEGRATED) || this.getEnergyStorage().getEnergyStored() < ReplicationConfig.Disintegrator.POWER_USAGE || (data = ReplicationCalculation.getMatterCompound(stack)) == null) continue;
            for (MatterValue matterValue : data.getValues().values()) {
                this.queuedMatterStacks.add(new MatterStack(matterValue.getMatter(), Mth.ceil((double)matterValue.getAmount())));
            }
            stack.shrink(1);
            this.getEnergyStorage().extractEnergy(ReplicationConfig.Disintegrator.POWER_USAGE, false);
        }
        this.syncObject(this.input);
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, DisintegratorBlockEntity blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (!this.queuedMatterStacks.isEmpty()) {
            MatterStack peekedElement = this.queuedMatterStacks.peek();
            for (MatterTankComponent matterTankComponent : this.getMatterTankComponents()) {
                if (matterTankComponent.isEmpty() || !matterTankComponent.getMatter().isMatterEqual(peekedElement) || matterTankComponent.fillForced(peekedElement, IFluidHandler.FluidAction.SIMULATE) > peekedElement.getAmount()) continue;
                peekedElement.setAmount(peekedElement.getAmount() - matterTankComponent.fillForced(peekedElement, IFluidHandler.FluidAction.EXECUTE));
                if (!peekedElement.isEmpty()) continue;
                this.queuedMatterStacks.poll();
                return;
            }
            if (!peekedElement.isEmpty()) {
                for (MatterTankComponent matterTankComponent : this.getMatterTankComponents()) {
                    if (!matterTankComponent.isEmpty()) continue;
                    peekedElement.setAmount(peekedElement.getAmount() - matterTankComponent.fillForced(peekedElement, IFluidHandler.FluidAction.EXECUTE));
                    if (!peekedElement.isEmpty()) continue;
                    this.queuedMatterStacks.poll();
                    return;
                }
            }
        }
    }

    private MatterTankComponent<DisintegratorBlockEntity> createMatterTank(int index) {
        return new MatterTankComponent("tank" + index, 16000, 42 + index * 18, 28).setTankAction(FluidTankComponent.Action.DRAIN);
    }

    @NotNull
    public DisintegratorBlockEntity getSelf() {
        return this;
    }

    @Override
    public List<? extends IMatterTank> getTanks() {
        return this.getMatterTankComponents();
    }

    public SidedInventoryComponent<?> getInput() {
        return this.input;
    }

    public int getTitleColor() {
        return 7529831;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 16.0f;
    }
}

