/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block.tile;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.pattern.IMatterPatternHolder;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.block.tile.NetworkBlockEntity;
import com.buuz135.replication.client.gui.ReplicationAddonProvider;
import com.buuz135.replication.client.gui.addons.ChipStorageAddon;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ChipStorageBlockEntity
extends NetworkBlockEntity<ChipStorageBlockEntity>
implements IMatterPatternHolder<ChipStorageBlockEntity> {
    @Save
    private SidedInventoryComponent<ChipStorageBlockEntity> chips;
    private List<MatterPattern> cachedPatters = new ArrayList<MatterPattern>();
    private boolean hasInvChanged = false;

    public ChipStorageBlockEntity(BasicTileBlock<ChipStorageBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.chips = (SidedInventoryComponent)new SidedInventoryComponent("input", 68, 18, 8, 0).disableFacingAddon().setSlotPosition(integer -> ChipStorageBlockEntity.getSlotPos(integer)).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> stack.is((Item)ReplicationRegistry.Items.MEMORY_CHIP.get())).setOnSlotChanged((stack, integer) -> this.notifyNetworkOfSlotChange()).setColorGuiEnabled(false);
        this.addInventory((InventoryComponent)this.chips);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new ChipStorageAddon(50, 30, this));
    }

    public ItemInteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return ItemInteractionResult.SUCCESS;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, ChipStorageBlockEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        if (this.hasInvChanged) {
            this.notifyNetworkOfSlotChange();
        }
    }

    public void setLevel(Level p_155231_) {
        super.setLevel(p_155231_);
        if (this.isServer()) {
            this.cachePatterns();
        }
    }

    private void notifyNetworkOfSlotChange() {
        if (this.isServer()) {
            this.syncObject(this.chips);
            this.cachePatterns();
            this.getNetwork().onChipValuesChanged(this, this.worldPosition);
        }
    }

    public void cachePatterns() {
        this.cachedPatters = new ArrayList<MatterPattern>();
        for (int i = 0; i < this.chips.getSlots(); ++i) {
            Item item;
            ItemStack slot = this.chips.getStackInSlot(i);
            if (slot.isEmpty() || !((item = slot.getItem()) instanceof IMatterPatternHolder)) continue;
            IMatterPatternHolder stackHolder = (IMatterPatternHolder)item;
            List<MatterPattern> patterns = stackHolder.getPatterns(this.level, slot);
            patterns.forEach(pattern -> {
                if (!pattern.getStack().isEmpty() && pattern.getCompletion() == 1.0f) {
                    this.cachedPatters.add((MatterPattern)pattern);
                }
            });
        }
    }

    @NotNull
    public ChipStorageBlockEntity getSelf() {
        return this;
    }

    public static Pair<Integer, Integer> getSlotPos(int slot) {
        int slotSpacing = 21;
        int offset = 2;
        return switch (slot) {
            case 1 -> Pair.of((Object)slotSpacing, (Object)0);
            case 2 -> Pair.of((Object)(slotSpacing * 2), (Object)slotSpacing);
            case 3 -> Pair.of((Object)(slotSpacing * 2), (Object)(slotSpacing * 2));
            case 4 -> Pair.of((Object)slotSpacing, (Object)(slotSpacing * 3));
            case 5 -> Pair.of((Object)0, (Object)(slotSpacing * 3));
            case 6 -> Pair.of((Object)(-slotSpacing), (Object)(slotSpacing * 2));
            case 7 -> Pair.of((Object)(-slotSpacing), (Object)slotSpacing);
            default -> Pair.of((Object)0, (Object)0);
        };
    }

    public SidedInventoryComponent<ChipStorageBlockEntity> getChips() {
        return this.chips;
    }

    @Override
    public int getPatternSlots(ChipStorageBlockEntity element) {
        return element.chips.getSlots();
    }

    @Override
    public List<MatterPattern> getPatterns(Level level, ChipStorageBlockEntity element) {
        return this.cachedPatters;
    }

    public IAssetProvider getAssetProvider() {
        return ReplicationAddonProvider.INSTANCE;
    }

    public int getTitleColor() {
        return 7529831;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        return super.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight) - 16.0f;
    }
}

