/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.block.tile.MatterPipeBlockEntity;
import com.buuz135.replication.network.MatterNetwork;
import com.google.common.collect.ImmutableMap;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.apache.commons.lang3.mutable.MutableObject;

public class MatterPipeBlock
extends BasicTileBlock<MatterPipeBlockEntity>
implements INetworkDirectionalConnection {
    public static final Map<Direction, BooleanProperty> DIRECTIONS = new HashMap<Direction, BooleanProperty>();
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final Map<BlockState, VoxelShape> COLL_SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final VoxelShape CENTER_SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final Map<Direction, VoxelShape> DIR_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)Direction.DOWN, (Object)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.NORTH, (Object)Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)Block.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)Direction.EAST, (Object)Block.box((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).put((Object)Direction.WEST, (Object)Block.box((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).build();

    public MatterPipeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), MatterPipeBlockEntity.class);
        this.setItemGroup(Replication.TAB);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, state) -> new MatterPipeBlockEntity(this, (BlockEntityType<?>)((BlockEntityType)ReplicationRegistry.Blocks.MATTER_NETWORK_PIPE.type().get()), pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add((Property[])DIRECTIONS.values().toArray(Property[]::new));
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    private BlockState createState(Level world, BlockPos pos, BlockState curr) {
        BlockState state = this.defaultBlockState();
        FluidState fluid = world.getFluidState(pos);
        if (fluid.is(FluidTags.WATER) && fluid.getAmount() == 8) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        for (Direction dir : Direction.values()) {
            BooleanProperty prop = DIRECTIONS.get(dir);
            boolean type = this.getConnectionType(world, pos, dir, state);
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(type));
        }
        return state;
    }

    protected boolean getConnectionType(Level world, BlockPos pos, Direction direction, BlockState state) {
        NetworkElement network;
        if (world.isClientSide()) {
            return false;
        }
        BlockState relativeState = world.getBlockState(pos.relative(direction));
        if (relativeState.getBlock() instanceof MatterPipeBlock) {
            return true;
        }
        NetworkManager networkManager = NetworkManager.get((Level)world);
        if (networkManager != null && (network = networkManager.getElement(pos.relative(direction))) != null && network.getNetwork() instanceof MatterNetwork) {
            INetworkDirectionalConnection networkDirectionalConnection = (INetworkDirectionalConnection)relativeState.getBlock();
            return networkDirectionalConnection.canConnect(world, pos, relativeState, direction.getOpposite());
        }
        IEnergyStorage cap = (IEnergyStorage)world.getCapability(Capabilities.EnergyStorage.BLOCK, pos.relative(direction), (Object)direction.getOpposite());
        return cap != null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.createState(context.getLevel(), context.getClickedPos(), this.defaultBlockState());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        NetworkElement pipe;
        BlockState newState = this.createState(worldIn, pos, state);
        if (newState != state) {
            worldIn.setBlockAndUpdate(pos, newState);
        }
        if (!worldIn.isClientSide && (pipe = NetworkManager.get((Level)worldIn).getElement(pos)) != null && pipe.getNetwork() != null) {
            pipe.getNetwork().scanGraph(worldIn, pos);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.getShape(worldIn, pos, context), SHAPE_CACHE, null);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.cacheAndGetShape(state, worldIn, pos, s -> s.getCollisionShape(worldIn, pos, context), COLL_SHAPE_CACHE, s -> {
            MutableObject newShape = new MutableObject((Object)Shapes.empty());
            s.forAllBoxes((x1, y1, z1, x2, y2, z2) -> newShape.setValue((Object)Shapes.join((VoxelShape)Shapes.create((double)x1, (double)y1, (double)z1, (double)x2, (double)(y2 + 0.1875), (double)z2), (VoxelShape)((VoxelShape)newShape.getValue()), (BooleanOp)BooleanOp.OR)));
            return ((VoxelShape)newShape.getValue()).optimize();
        });
    }

    private VoxelShape cacheAndGetShape(BlockState state, BlockGetter worldIn, BlockPos pos, Function<BlockState, VoxelShape> coverShapeSelector, Map<BlockState, VoxelShape> cache, Function<VoxelShape, VoxelShape> shapeModifier) {
        VoxelShape shape = cache.get(state);
        if (shape == null) {
            shape = CENTER_SHAPE;
            for (Map.Entry<Direction, BooleanProperty> entry : DIRECTIONS.entrySet()) {
                if (!((Boolean)state.getValue((Property)entry.getValue())).booleanValue()) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)DIR_SHAPES.get(entry.getKey()));
            }
            if (shapeModifier != null) {
                shape = shapeModifier.apply(shape);
            }
            cache.put(state, shape);
        }
        return shape;
    }

    public boolean canConnect(Level level, BlockPos pos, BlockState state, Direction direction) {
        return true;
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)8).pattern("PPP").pattern("IRI").pattern("PPP").define(Character.valueOf('P'), Tags.Items.GLASS_PANES).define(Character.valueOf('I'), (ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).save(consumer);
    }

    static {
        for (Direction value : Direction.values()) {
            DIRECTIONS.put(value, BooleanProperty.create((String)value.getName().toLowerCase(Locale.ROOT)));
        }
    }
}

