/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api.pattern;

import com.buuz135.replication.api.pattern.MatterPattern;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IMatterPatternModifier<T> {
    @Nullable
    public ModifierAction addPattern(Level var1, T var2, ItemStack var3, float var4);

    public static enum ModifierType {
        FULL,
        CAN_KEEP_ADDING;

    }

    public static class ModifierAction {
        private final MatterPattern pattern;
        private final ModifierType type;

        public static ModifierAction isFull(MatterPattern pattern) {
            return new ModifierAction(pattern, ModifierType.FULL);
        }

        public static ModifierAction canKeepAdding(MatterPattern pattern) {
            return new ModifierAction(pattern, ModifierType.CAN_KEEP_ADDING);
        }

        public ModifierAction(@Nullable MatterPattern pattern, ModifierType type) {
            this.pattern = pattern;
            this.type = type;
        }

        @Nullable
        public MatterPattern getPattern() {
            return this.pattern;
        }

        public ModifierType getType() {
            return this.type;
        }
    }
}

