/*
 * Decompiled with CFR 0.152.
 */
package koala.fishingreal.forge.compat;

import com.teammetallurgy.aquaculture.entity.AquaFishingBobberEntity;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import java.util.List;
import javax.annotation.Nonnull;
import koala.fishingreal.FishingReal;
import koala.fishingreal.forge.FishingRealForge;
import koala.fishingreal.forge.mixin.compat.AquaFishingBobberEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AquacultureCompat {
    public static void onItemFished(ItemFishedEvent event) {
        if (event.getHookEntity() instanceof AquaFishingBobberEntity) {
            ItemStackHandler rodHandler;
            ItemStack bait;
            LootParams lootParams;
            List<ItemStack> doubleLoot;
            final AquaFishingBobberEntity hook = (AquaFishingBobberEntity)event.getHookEntity();
            if (hook.level().isClientSide()) {
                return;
            }
            if (hook.hasHook() && hook.getHook().getDoubleCatchChance() > 0.0 && hook.level().random.nextDouble() <= hook.getHook().getDoubleCatchChance() && !(doubleLoot = AquacultureCompat.getLoot(hook, lootParams = new LootParams.Builder((ServerLevel)hook.level()).withParameter(LootContextParams.ORIGIN, (Object)hook.position()).withParameter(LootContextParams.TOOL, (Object)event.getEntity().getUseItem()).withParameter(LootContextParams.THIS_ENTITY, (Object)hook).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)event.getEntity()).withParameter(LootContextParams.THIS_ENTITY, (Object)hook).withLuck((float)((AquaFishingBobberEntityAccessor)hook).getLuck() + event.getEntity().getLuck()).create(LootContextParamSets.FISHING), (ServerLevel)hook.level())).isEmpty()) {
                for (ItemStack stack : doubleLoot) {
                    Entity convertedEntity = FishingReal.convertItemStack(stack, event.getEntity(), hook.position());
                    FishingRealForge.fishUpEntity((Entity)(convertedEntity == null ? new ItemEntity(hook.level(), hook.getX(), hook.getY(), hook.getZ(), stack){

                        public boolean displayFireAnimation() {
                            return false;
                        }

                        public void lavaHurt() {
                        }

                        public boolean isInvulnerableTo(@Nonnull DamageSource source) {
                            BlockPos spawnPos = BlockPos.containing((double)hook.getX(), (double)hook.getY(), (double)hook.getZ());
                            return hook.isLavaHookInLava(hook, this.level(), spawnPos) || super.isInvulnerableTo(source);
                        }
                    } : convertedEntity), (FishingHook)hook, stack, event.getEntity());
                }
            }
            if (!event.getEntity().isCreative() && !(bait = (rodHandler = AquaFishingRodItem.getHandler((ItemStack)((AquaFishingBobberEntityAccessor)hook).getFishingRod())).getStackInSlot(1)).isEmpty()) {
                bait.hurtAndBreak(1, (ServerLevel)hook.level(), null, item -> {
                    bait.shrink(1);
                    hook.playSound((SoundEvent)AquaSounds.BOBBER_BAIT_BREAK.get(), 0.7f, 0.2f);
                });
                rodHandler.setStackInSlot(1, bait);
            }
        }
    }

    private static List<ItemStack> getLoot(AquaFishingBobberEntity hook, LootParams lootParams, ServerLevel level) {
        ResourceKey lootTableLocation = hook.isLavaHookInLava(hook, (Level)level, hook.blockPosition()) ? (level.getLevel().dimensionType().hasCeiling() ? AquaLootTables.NETHER_FISHING : AquaLootTables.LAVA_FISHING) : BuiltInLootTables.FISHING;
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableLocation);
        return lootTable.getRandomItems(lootParams);
    }
}

