/*
 * Decompiled with CFR 0.152.
 */
package koala.fishingreal;

import java.util.function.BiConsumer;
import koala.fishingreal.FishingConversion;
import koala.fishingreal.FishingManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class FishingReal {
    public static final FishingManager FISHING_MANAGER = new FishingManager();
    public static final String MOD_ID = "fishingreal";

    public static boolean doItemStacksMatchIgnoreNBT(ItemStack stack1, ItemStack stack2) {
        return stack1.is(stack2.getItem()) && stack1.getCount() == stack2.getCount();
    }

    public static void onRegisterReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        registry.accept(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"fishing"), (PreparableReloadListener)FISHING_MANAGER);
    }

    public static Entity convertItemStack(ItemStack itemstack, Player player, Vec3 position) {
        Level level;
        if (player != null && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            FishingConversion.FishingResult result = FISHING_MANAGER.getConversionResultFromStack(itemstack);
            if (result != null) {
                Entity resultEntity = result.entity().create(player.level());
                result.tag().ifPresent(arg_0 -> ((Entity)resultEntity).load(arg_0));
                resultEntity.moveTo(position);
                if (result.randomizeNbt() && resultEntity instanceof Mob) {
                    Mob resultMob = (Mob)resultEntity;
                    resultMob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(player.blockPosition()), MobSpawnType.NATURAL, null);
                }
                return resultEntity;
            }
        }
        return null;
    }

    public static Entity convertItemEntity(Entity fishedEntity, Player player) {
        ItemEntity itemEntity;
        Entity resultEntity;
        if (player != null && fishedEntity instanceof ItemEntity && (resultEntity = FishingReal.convertItemStack((itemEntity = (ItemEntity)fishedEntity).getItem(), player, itemEntity.position())) != null) {
            resultEntity.moveTo(itemEntity.position());
            resultEntity.setDeltaMovement(itemEntity.getDeltaMovement().multiply(1.2, 1.2, 1.2));
            return resultEntity;
        }
        return fishedEntity;
    }
}

