/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MathUtil {
    public static Stream<ChunkPos> getChunksFromAABB(AABB bounds) {
        ChunkPos min = new ChunkPos(BlockPos.containing((double)bounds.minX, (double)bounds.minY, (double)bounds.minZ));
        ChunkPos max = new ChunkPos(BlockPos.containing((double)bounds.maxX, (double)bounds.maxY, (double)bounds.maxZ));
        return ChunkPos.rangeClosed((ChunkPos)min, (ChunkPos)max);
    }

    public static int volumeOf(Vec3i dimensions) {
        return dimensions.getX() * dimensions.getY() * dimensions.getZ();
    }

    public static Vec3i getRegionPositionByIndex(int i) {
        int index = i + 1;
        int s = (int)Math.ceil(Math.sqrt(index)) + (int)((Math.ceil(Math.sqrt(index)) % 2.0 + 1.0) % 2.0);
        int ringIndex = 0;
        int p = 1;
        if (s > 1) {
            ringIndex = i - (s - 2) * (s - 2);
            p = s * s - (s - 2) * (s - 2);
        }
        int ri = (ringIndex + s / 2) % p;
        int x = 0;
        if (s > 1) {
            x = ri < p / 4 ? ri : (ri <= p / 4 * 2 - 1 ? p / 4 : (ri <= p / 4 * 3 ? p / 4 * 3 - ri : 0));
        }
        int y = 0;
        if (s > 1) {
            y = ri < p / 4 ? 0 : (ri <= p / 4 * 2 - 1 ? ri - p / 4 : (ri <= p / 4 * 3 ? p / 4 : p - ri));
        }
        return new Vec3i(x -= s / 2, 0, y -= s / 2);
    }

    public static Vec3 getCenterWithY(ChunkPos chunk, int y) {
        return Vec3.atBottomCenterOf((Vec3i)chunk.getWorldPosition().offset((Vec3i)new BlockPos(8, y, 8)));
    }

    public static Vec3 getCenterWithY(Vec3i regionIndex, int y) {
        ChunkPos chunk = new ChunkPos(regionIndex.getX() * 64, regionIndex.getZ() * 64);
        return MathUtil.getCenterWithY(chunk, y);
    }
}

