/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.CMRegistries;
import dev.compactmods.machines.api.item.component.MachineComponents;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.machine.MachineConstants;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlock;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlockEntity;
import dev.compactmods.machines.machine.block.UnboundCompactMachineBlock;
import dev.compactmods.machines.machine.block.UnboundCompactMachineEntity;
import dev.compactmods.machines.machine.item.BoundCompactMachineItem;
import dev.compactmods.machines.machine.item.UnboundCompactMachineItem;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public interface Machines {
    public static final BlockBehaviour.Properties MACHINE_BLOCK_PROPS = BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.COW_BELL).pushReaction(PushReaction.IGNORE).sound(SoundType.METAL).strength(8.0f, 20.0f).requiresCorrectToolForDrops();
    public static final Supplier<Item.Properties> MACHINE_ITEM_PROPS = Item.Properties::new;

    public static void prepare() {
        Blocks.prepare();
        Items.prepare();
        BlockEntities.prepare();
        DataComponents.prepare();
        Attachments.prepare();
    }

    public static void registerEvents(IEventBus modBus) {
    }

    public static interface Blocks {
        public static final DeferredBlock<UnboundCompactMachineBlock> UNBOUND_MACHINE = CMRegistries.BLOCKS.register("new_machine", () -> new UnboundCompactMachineBlock(MACHINE_BLOCK_PROPS));
        public static final DeferredBlock<BoundCompactMachineBlock> BOUND_MACHINE = CMRegistries.BLOCKS.register("machine", () -> new BoundCompactMachineBlock(MACHINE_BLOCK_PROPS));

        public static void prepare() {
        }
    }

    public static interface Items {
        public static final DeferredItem<BoundCompactMachineItem> BOUND_MACHINE = CMRegistries.ITEMS.register("machine", () -> new BoundCompactMachineItem(MACHINE_ITEM_PROPS.get()));
        public static final DeferredItem<UnboundCompactMachineItem> UNBOUND_MACHINE = CMRegistries.ITEMS.register("new_machine", () -> new UnboundCompactMachineItem(MACHINE_ITEM_PROPS.get()));

        public static void prepare() {
        }

        public static ItemStack unbound() {
            return Items.unboundColored(-1);
        }

        public static ItemStack unboundColored(int color) {
            ItemStack stack = UNBOUND_MACHINE.toStack();
            stack.set(DataComponents.MACHINE_COLOR, (Object)MachineColor.fromARGB((int)color));
            return stack;
        }

        public static ItemStack boundToRoom(String roomCode) {
            return Items.boundToRoom(roomCode, -1);
        }

        public static ItemStack boundToRoom(String roomCode, int color) {
            return Items.boundToRoom(roomCode, MachineColor.fromARGB((int)color));
        }

        public static ItemStack boundToRoom(String roomCode, MachineColor color) {
            ItemStack stack = BOUND_MACHINE.toStack();
            stack.set(DataComponents.BOUND_ROOM_CODE, (Object)roomCode);
            stack.set(DataComponents.MACHINE_COLOR, (Object)color);
            return stack;
        }

        public static ItemStack forNewRoom(Holder.Reference<RoomTemplate> templateHolder) {
            RoomTemplate template = (RoomTemplate)templateHolder.value();
            ItemStack stack = UNBOUND_MACHINE.toStack();
            stack.set(DataComponents.ROOM_TEMPLATE_ID, (Object)templateHolder.key().location());
            stack.set(DataComponents.MACHINE_COLOR, (Object)template.defaultMachineColor());
            return stack;
        }
    }

    public static interface BlockEntities {
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<UnboundCompactMachineEntity>> UNBOUND_MACHINE = CMRegistries.BLOCK_ENTITIES.register(MachineConstants.UNBOUND_MACHINE_ENTITY.getPath(), () -> BlockEntityType.Builder.of(UnboundCompactMachineEntity::new, (Block[])new Block[]{(Block)Blocks.UNBOUND_MACHINE.get()}).build(null));
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BoundCompactMachineBlockEntity>> MACHINE = CMRegistries.BLOCK_ENTITIES.register(MachineConstants.BOUND_MACHINE_ENTITY.getPath(), () -> BlockEntityType.Builder.of(BoundCompactMachineBlockEntity::new, (Block[])new Block[]{(Block)Blocks.BOUND_MACHINE.get()}).build(null));

        public static void prepare() {
        }
    }

    public static interface DataComponents {
        public static final String KEY_ROOM_TEMPLATE = "room_template";
        public static final String KEY_ROOM_CODE = "room_code";
        public static final String KEY_MACHINE_COLOR = "machine_color";
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> BOUND_ROOM_CODE = CMRegistries.DATA_COMPONENTS.registerComponentType("room_code", MachineComponents.BOUND_ROOM_CODE);
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<MachineColor>> MACHINE_COLOR = CMRegistries.DATA_COMPONENTS.registerComponentType("machine_color", MachineComponents.MACHINE_COLOR);
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<ResourceLocation>> ROOM_TEMPLATE_ID = CMRegistries.DATA_COMPONENTS.registerComponentType("room_template", MachineComponents.ROOM_TEMPLATE_ID);

        public static void prepare() {
        }
    }

    public static interface Attachments {
        public static final Supplier<AttachmentType<MachineColor>> MACHINE_COLOR = CMRegistries.ATTACHMENT_TYPES.register("machine_color", () -> AttachmentType.builder(() -> MachineColor.fromARGB((int)-1)).serialize(MachineColor.CODEC).build());

        public static void prepare() {
        }
    }
}

