/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.i18n;

import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.function.PlayerAndRoomCodeFunction;
import dev.compactmods.spatial.aabb.AABBHelper;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public interface RoomTranslations {
    public static final PlayerAndRoomCodeFunction<Component> PLAYER_ROOM_INFO = (player, roomCode) -> Component.translatableWithFallback((String)IDs.PLAYER_ROOM_INFO, (String)"%1$s is inside room '%2$s'.", (Object[])new Object[]{player.getDisplayName(), roomCode});
    public static final Function<Player, Component> PLAYER_NOT_IN_COMPACT_DIM = player -> Component.translatableWithFallback((String)IDs.Errors.PLAYER_NOT_IN_COMPACT_DIM, (String)"", (Object[])new Object[]{player.getDisplayName()});
    public static final Function<Player, Component> UNKNOWN_ROOM_BY_PLAYER_CHUNK = player -> Component.translatableWithFallback((String)IDs.Errors.UNKNOWN_ROOM_BY_PLAYER_CHUNK, (String)"Room not found at chunk: %s", (Object[])new Object[]{player.chunkPosition().toString()}).withStyle(ChatFormatting.DARK_RED);
    public static final Function<String, Component> UNKNOWN_ROOM_BY_CODE = roomCode -> Component.translatableWithFallback((String)IDs.Errors.UNKNOWN_ROOM_BY_CODE, (String)"Room not found: %s", (Object[])new Object[]{roomCode});
    public static final BiFunction<BlockPos, RoomInstance, Component> MACHINE_ROOM_INFO = (machinePos, info) -> Component.translatableWithFallback((String)IDs.MACHINE_ROOM_INFO, (String)"Machine at %1$s is bound to a %2$s size room at %3$s", (Object[])new Object[]{machinePos.toShortString(), AABBHelper.toString((AABB)info.boundaries().innerBounds()), info.boundaries().innerBounds().getCenter()});
    public static final PlayerAndRoomCodeFunction<Component> ROOM_SPAWNPOINT_SET = (player, roomCode) -> Component.translatableWithFallback((String)IDs.ROOM_SPAWNPOINT_SET, (String)"Room spawn for %s updated.", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.GREEN);

    public static interface IDs {
        public static final String ROOM_SPAWNPOINT_SET = Util.makeDescriptionId((String)"rooms", (ResourceLocation)CompactMachines.modRL((String)"spawnpoint_set"));
        public static final String PLAYER_ROOM_INFO = Util.makeDescriptionId((String)"rooms", (ResourceLocation)CompactMachines.modRL((String)"player_room_info"));
        public static final String MACHINE_ROOM_INFO = Util.makeDescriptionId((String)"machine", (ResourceLocation)CompactMachines.modRL((String)"machine_room_info"));

        public static interface Errors {
            public static final String UNKNOWN_ROOM_BY_CODE = Util.makeDescriptionId((String)"rooms.errors", (ResourceLocation)CompactMachines.modRL((String)"room_not_found"));
            public static final String CANNOT_ENTER_ROOM = Util.makeDescriptionId((String)"rooms.errors", (ResourceLocation)CompactMachines.modRL((String)"cannot_enter"));
            public static final String UNKNOWN_ROOM_BY_PLAYER_CHUNK = Util.makeDescriptionId((String)"rooms.errors", (ResourceLocation)CompactMachines.modRL((String)"unknown_room_chunk"));
            public static final String PLAYER_NOT_IN_COMPACT_DIM = Util.makeDescriptionId((String)"rooms.errors", (ResourceLocation)CompactMachines.modRL((String)"player_not_in_compact_dimension"));
        }
    }
}

