/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.table;

import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.entry.SimpleLootEntry;
import com.almostreliable.lootjs.loot.LootFunctionList;
import com.almostreliable.lootjs.loot.extension.LootPoolExtension;
import com.almostreliable.lootjs.loot.extension.LootTableExtension;
import com.almostreliable.lootjs.loot.table.LootEntriesTransformer;
import com.almostreliable.lootjs.loot.table.MutableLootPool;
import com.almostreliable.lootjs.loot.table.PostLootAction;
import com.almostreliable.lootjs.loot.table.PostLootActionOwner;
import com.almostreliable.lootjs.util.DebugInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class MutableLootTable
implements LootEntriesTransformer {
    private final LootTable origin;
    private final ResourceLocation location;
    @Nullable
    private LootFunctionList functions;

    public MutableLootTable(LootTable lootTable) {
        this(lootTable, lootTable.getLootTableId());
    }

    public MutableLootTable(LootTable lootTable, ResourceLocation location) {
        this.location = location;
        this.origin = lootTable;
    }

    public MutableLootTable(LootContextParamSet paramSet, ResourceLocation location) {
        this(new LootTable.Builder().setParamSet(paramSet).setRandomSequence(location).build(), location);
    }

    public ResourceLocation getRandomSequence() {
        ResourceLocation rs = LootTableExtension.cast(this.origin).lootjs$getRandomSequence();
        return rs == null ? this.getLocation() : rs;
    }

    public void setRandomSequence(@Nullable ResourceLocation randomSequence) {
        LootTableExtension.cast(this.origin).lootjs$setRandomSequence(randomSequence);
    }

    public LootType getLootType() {
        return LootType.getLootType(this.origin.getParamSet());
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    private List<LootPool> getVanillaPools() {
        return LootTableExtension.cast(this.origin).lootjs$getPools();
    }

    public MutableLootTable firstPool(Consumer<MutableLootPool> onModifyPool) {
        onModifyPool.accept(this.firstPool());
        return this;
    }

    public MutableLootPool firstPool() {
        List<LootPool> pools = LootTableExtension.cast(this.origin).lootjs$getPools();
        if (pools.isEmpty()) {
            return this.createPool();
        }
        return new MutableLootPool(pools.get(0));
    }

    public MutableLootTable createPool(Consumer<MutableLootPool> onCreatePool) {
        onCreatePool.accept(this.createPool());
        return this;
    }

    public MutableLootPool createPool() {
        LootPool pool = new LootPool(new ArrayList(), new ArrayList(), new ArrayList(), (NumberProvider)ConstantValue.exactly((float)1.0f), (NumberProvider)ConstantValue.exactly((float)0.0f), Optional.empty());
        this.getVanillaPools().add(pool);
        return new MutableLootPool(pool);
    }

    public LootFunctionList getFunctions() {
        if (this.functions == null) {
            this.functions = LootTableExtension.cast(this.origin).lootjs$createFunctionList();
        }
        return this.functions;
    }

    public MutableLootTable onDrop(PostLootAction postLootAction) {
        LootTable lootTable = this.origin;
        if (lootTable instanceof PostLootActionOwner) {
            PostLootActionOwner owner = (PostLootActionOwner)lootTable;
            owner.lootjs$setPostLootAction(postLootAction);
        }
        return this;
    }

    public void writeToVanillaTable() {
    }

    public void print() {
        DebugInfo info = new DebugInfo();
        info.add("Loot table: " + String.valueOf(this.location));
        info.push();
        info.add("% Pools [");
        info.push();
        for (LootPool pool : this.getVanillaPools()) {
            info.add("{");
            info.push();
            LootPoolExtension.cast(pool).lootjs$collectDebugInfo(info);
            info.pop();
            info.add("}");
        }
        info.pop();
        info.add("]");
        LootFunctionList f = this.functions == null ? LootTableExtension.cast(this.origin).lootjs$createFunctionList() : this.functions;
        f.collectDebugInfo(info);
        info.pop();
        info.release();
    }

    public MutableLootTable clear() {
        this.getFunctions().clear();
        this.getVanillaPools().clear();
        return this;
    }

    @Override
    public MutableLootTable modifyEntry(UnaryOperator<SimpleLootEntry> onTransform, boolean deepTransform) {
        for (LootPool pool : this.getVanillaPools()) {
            new MutableLootPool(pool).modifyEntry((UnaryOperator)onTransform, deepTransform);
        }
        return this;
    }

    @Override
    public MutableLootTable removeEntry(Predicate<SimpleLootEntry> onRemove, boolean deepRemove) {
        for (LootPool pool : this.getVanillaPools()) {
            new MutableLootPool(pool).removeEntry((Predicate)onRemove, deepRemove);
        }
        return this;
    }

    public MutableLootTable apply(Consumer<LootFunctionList> onModifiers) {
        onModifiers.accept(this.getFunctions());
        return this;
    }
}

