/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube.wrappers;

import com.almostreliable.lootjs.core.LootType;
import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.LootTableFilter;
import com.almostreliable.lootjs.kube.wrappers.MinMaxBoundsWrapper;
import com.almostreliable.lootjs.util.BlockFilter;
import com.almostreliable.lootjs.util.Utils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.util.NBTUtils;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BasicWrapper {
    public static final EntityTypePredicate EMPTY_ENTITY_TYPE_PREDICATE = new EntityTypePredicate((HolderSet)HolderSet.direct((Holder[])new Holder[0]));
    private static final TypeInfo ENTITY_HOLDER_SET = TypeInfo.of(HolderSet.class).withParams(new TypeInfo[]{TypeInfo.of(EntityType.class)});

    public static BlockFilter ofBlockFilter(RegistryAccessContainer registries, Object o) {
        if (o instanceof BlockFilter) {
            BlockFilter bf = (BlockFilter)o;
            return bf;
        }
        final BlockStatePredicate bsp = BlockStatePredicate.of((RegistryAccessContainer)registries, (Object)o);
        return new BlockFilter(){

            @Override
            @NotNull
            public Iterator<Block> iterator() {
                return bsp.getBlocks().iterator();
            }

            @Override
            public boolean test(BlockState blockState) {
                return bsp.test(blockState);
            }
        };
    }

    public static NbtPredicate ofNbtPredicate(Context cx, Object o, TypeInfo target) {
        if (o instanceof NbtPredicate) {
            NbtPredicate nbt = (NbtPredicate)o;
            return nbt;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return new NbtPredicate((CompoundTag)NBTUtils.compoundTag((Context)cx, (Map)map));
        }
        return new NbtPredicate(new CompoundTag());
    }

    public static PlayerPredicate.AdvancementPredicate ofAdvancementPredicate(RegistryAccessContainer registry, Object o) {
        return (PlayerPredicate.AdvancementPredicate)PlayerPredicate.AdvancementPredicate.CODEC.parse((DynamicOps)registry.java(), o).getOrThrow();
    }

    public static LightPredicate ofLightPredicate(RegistryAccessContainer registry, Object o) {
        MinMaxBounds.Ints range = MinMaxBoundsWrapper.ofMinMaxInt(registry, o);
        return new LightPredicate(range);
    }

    public static EntitySubPredicate ofEntitySubPredicate(Context cx, Object o, TypeInfo target) {
        if (o instanceof Map) {
            RegistryAccessContainer registries = ((KubeJSContext)cx).getRegistries();
            return (EntitySubPredicate)registries.decode(cx, EntitySubPredicate.CODEC, o);
        }
        return new EntitySubPredicate(){

            public MapCodec<? extends EntitySubPredicate> codec() {
                throw new UnsupportedOperationException("Custom EntitySubPredicate does not have a codec");
            }

            public boolean matches(Entity arg, ServerLevel arg2, @Nullable Vec3 arg3) {
                return false;
            }
        };
    }

    public static EntityTypePredicate ofEntityTypePredicate(Context cx, @Nullable Object o) {
        if (o instanceof EntityType) {
            EntityType type = (EntityType)o;
            return EntityTypePredicate.of((EntityType)type);
        }
        HolderSet holderSet = (HolderSet)cx.jsToJava(o, ENTITY_HOLDER_SET);
        return new EntityTypePredicate(holderSet);
    }

    public static DamageSourcePredicate ofDamageSourcePredicate(Context cx, Object o, TypeInfo target) {
        String str;
        if (o instanceof String && (str = (String)o).startsWith("#")) {
            String tag = str.substring(0, 1);
            TagPredicate predicate = TagPredicate.is((TagKey)TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)tag)));
            return DamageSourcePredicate.Builder.damageType().tag(predicate).build();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(Utils.mapOrThrow(o));
        Object predicate = map.get("tags");
        if (predicate instanceof List) {
            List list = (List)predicate;
            ArrayList predicates = new ArrayList();
            for (Object obj : list) {
                BasicWrapper.getTagPredicate(obj).ifPresent(predicates::add);
            }
            map.put("tags", predicates);
        }
        return (DamageSourcePredicate)((RecordTypeInfo)target).createInstance(cx, map);
    }

    private static Optional<TagPredicate<DamageType>> getTagPredicate(Object rawPredicate) {
        try {
            Map<String, Object> map = Utils.mapOrThrow(rawPredicate);
            if (!map.containsKey("id") || !map.containsKey("expected")) {
                throw new IllegalArgumentException("Missing id and expected in damage source predicate: " + String.valueOf(rawPredicate));
            }
            String id = map.get("id").toString();
            boolean expected = (Boolean)map.get("expected");
            TagKey tag = TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)id));
            return Optional.of(new TagPredicate(tag, expected));
        }
        catch (Exception e) {
            ConsoleJS.SERVER.error("Error parsing damage source predicate: " + String.valueOf(rawPredicate), (Throwable)e);
            return Optional.empty();
        }
    }

    public static IdFilter ofIdFilter(Object o) {
        Pattern pattern = RegExpKJS.wrap((Object)o);
        if (pattern != null) {
            return new IdFilter.ByPattern(pattern);
        }
        Object object = o;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, String.class, ResourceLocation.class}, (Object)object2, n)) {
            case 0 -> {
                List list = (List)object2;
                yield new IdFilter.Or(list.stream().map(BasicWrapper::ofIdFilter).toList());
            }
            case 1 -> {
                String str = (String)object2;
                if (str.startsWith("@")) {
                    yield new IdFilter.ByMod(str.substring(1));
                }
                yield new IdFilter.ByLocation(ResourceLocation.parse((String)str));
            }
            case 2 -> {
                ResourceLocation rl = (ResourceLocation)object2;
                yield new IdFilter.ByLocation(rl);
            }
            default -> throw new IllegalArgumentException("Invalid resource location filter: " + String.valueOf(o));
        };
    }

    public static LootTableFilter ofLootTableFilter(Object o) {
        if (o instanceof LootType) {
            LootType lootType = (LootType)((Object)o);
            return new LootTableFilter.ByLootType(lootType);
        }
        return new LootTableFilter.ByIdFilter(BasicWrapper.ofIdFilter(o));
    }
}

