/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.filters;

import com.almostreliable.lootjs.core.filters.IdFilter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.ItemAbility;

public interface ItemFilter {
    public static final ItemFilter NONE = itemStack -> false;
    public static final ItemFilter ANY = itemStack -> true;
    public static final ItemFilter EMPTY = ItemStack::isEmpty;
    public static final ItemFilter ARMOR = itemStack -> itemStack.getItem() instanceof ArmorItem;
    public static final ItemFilter EDIBLE = itemStack -> itemStack.getFoodProperties(null) != null;
    public static final ItemFilter DAMAGEABLE = ItemStack::isDamageableItem;
    public static final ItemFilter DAMAGED = ItemStack::isDamaged;
    public static final ItemFilter ENCHANTED = ItemStack::isEnchanted;
    public static final ItemFilter BLOCK_ITEM = itemStack -> itemStack.getItem() instanceof BlockItem;

    public static ItemFilter hasEnchantment(IdFilter filter) {
        return ItemFilter.hasEnchantment(filter, MinMaxBounds.Ints.ANY);
    }

    public static ItemFilter hasEnchantment(IdFilter filter, MinMaxBounds.Ints levelBounds) {
        return itemStack -> {
            ItemEnchantments enchantments = (ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS);
            return ItemFilter.hasEnchantmentsInComponent(filter, levelBounds, enchantments);
        };
    }

    public static ItemFilter hasStoredEnchantment(IdFilter filter) {
        return ItemFilter.hasStoredEnchantment(filter, MinMaxBounds.Ints.ANY);
    }

    public static ItemFilter hasStoredEnchantment(IdFilter filter, MinMaxBounds.Ints levelBounds) {
        return itemStack -> {
            ItemEnchantments enchantments = (ItemEnchantments)itemStack.get(DataComponents.STORED_ENCHANTMENTS);
            return ItemFilter.hasEnchantmentsInComponent(filter, levelBounds, enchantments);
        };
    }

    private static boolean hasEnchantmentsInComponent(IdFilter filter, MinMaxBounds.Ints levelBounds, @Nullable ItemEnchantments enchantments) {
        if (enchantments == null) {
            return false;
        }
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            boolean matches = ((Holder)entry.getKey()).unwrapKey().filter(key -> filter.test(key.location())).isPresent();
            if (!matches || !levelBounds.matches(entry.getIntValue())) continue;
            return true;
        }
        return false;
    }

    public static ItemFilter tag(String tag) {
        if (tag.startsWith("#")) {
            tag = tag.substring(1);
        }
        return new Tag((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag)));
    }

    public static ItemFilter item(ItemStack otherItemStack, boolean checkComponents) {
        if (checkComponents) {
            return itemStack -> ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)otherItemStack);
        }
        return itemStack -> itemStack.getItem() == otherItemStack.getItem();
    }

    public static ItemFilter equipmentSlot(EquipmentSlot slot) {
        return itemStack -> itemStack.getEquipmentSlot() == slot;
    }

    public static ItemFilter equipmentSlotGroup(EquipmentSlotGroup slotGroup) {
        return itemStack -> {
            EquipmentSlot equipmentSlot = itemStack.getEquipmentSlot();
            if (equipmentSlot == null) {
                return false;
            }
            return slotGroup.test(equipmentSlot);
        };
    }

    public static ItemFilter allOf(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> ANY;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].and(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (itemFilter.test(itemStack)) continue;
                    return false;
                }
                return true;
            };
        };
    }

    public static ItemFilter not(ItemFilter itemFilter) {
        return itemFilter.negate();
    }

    public static ItemFilter anyOf(ItemFilter ... itemFilters) {
        Objects.requireNonNull(itemFilters);
        return switch (itemFilters.length) {
            case 0 -> NONE;
            case 1 -> itemFilters[0];
            case 2 -> itemFilters[0].or(itemFilters[1]);
            default -> itemStack -> {
                for (ItemFilter itemFilter : itemFilters) {
                    if (!itemFilter.test(itemStack)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    public static ItemFilter custom(Predicate<ItemStack> predicate) {
        return predicate::test;
    }

    public boolean test(ItemStack var1);

    default public ItemFilter and(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) && other.test(itemStack);
    }

    default public ItemFilter negate() {
        return itemS -> !this.test(itemS);
    }

    default public ItemFilter or(ItemFilter other) {
        Objects.requireNonNull(other);
        return itemStack -> this.test(itemStack) || other.test(itemStack);
    }

    public static ItemFilter anyToolAction(String ... actions) {
        List<ItemAbility> toolActions = Arrays.stream(actions).map(ItemAbility::get).toList();
        if (toolActions.isEmpty()) {
            return itemStack -> true;
        }
        if (toolActions.size() == 1) {
            ItemAbility action = toolActions.getFirst();
            return itemStack -> itemStack.canPerformAction(action);
        }
        if (toolActions.size() == 2) {
            ItemAbility action1 = toolActions.get(0);
            ItemAbility action2 = toolActions.get(1);
            return itemStack -> itemStack.canPerformAction(action1) || itemStack.canPerformAction(action2);
        }
        return itemStack -> {
            for (ItemAbility action : toolActions) {
                if (!itemStack.canPerformAction(action)) continue;
                return true;
            }
            return false;
        };
    }

    public static ItemFilter toolAction(String ... actions) {
        List<ItemAbility> toolActions = Arrays.stream(actions).map(ItemAbility::get).toList();
        if (toolActions.size() == 1) {
            ItemAbility action = toolActions.getFirst();
            return itemStack -> itemStack.canPerformAction(action);
        }
        if (toolActions.isEmpty()) {
            return itemStack -> true;
        }
        if (toolActions.size() == 2) {
            ItemAbility action1 = toolActions.get(0);
            ItemAbility action2 = toolActions.get(1);
            return itemStack -> itemStack.canPerformAction(action1) && itemStack.canPerformAction(action2);
        }
        return itemStack -> {
            for (ItemAbility action : toolActions) {
                if (itemStack.canPerformAction(action)) continue;
                return false;
            }
            return true;
        };
    }

    public record Tag(TagKey<Item> tag) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return itemStack.is(this.tag);
        }
    }

    public record Ingredient(net.minecraft.world.item.crafting.Ingredient ingredient) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return this.ingredient.test(itemStack);
        }
    }
}

