/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.entry;

import com.almostreliable.lootjs.core.entry.AbstractSimpleLootEntry;
import com.almostreliable.lootjs.core.entry.SingleLootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.util.DebugInfo;
import com.almostreliable.lootjs.util.Utils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ItemLootEntry
extends AbstractSimpleLootEntry<LootItem>
implements SingleLootEntry {
    public ItemLootEntry(LootItem vanillaEntry) {
        super(vanillaEntry);
    }

    public ItemLootEntry(ItemStack itemStack) {
        super(new LootItem((Holder)itemStack.getItem().builtInRegistryHolder(), 1, 0, EMPTY_CONDITIONS, EMPTY_FUNCTIONS));
        if (itemStack.getCount() > 1) {
            this.getFunctions().setCount((NumberProvider)ConstantValue.exactly((float)itemStack.getCount()));
        }
        if (!itemStack.isComponentsPatchEmpty()) {
            DataComponentPatch.Builder builder = DataComponentPatch.builder();
            for (TypedDataComponent component : itemStack.getComponents()) {
                builder.set((DataComponentType)Utils.cast(component.type()), component.value());
            }
            this.getFunctions().addFunction((LootItemFunction)new SetComponentsFunction(new ArrayList(), builder.build()));
        }
    }

    public ItemLootEntry(Item item, @Nullable NumberProvider count) {
        super(new LootItem((Holder)item.builtInRegistryHolder(), 1, 0, EMPTY_CONDITIONS, EMPTY_FUNCTIONS));
        if (count != null) {
            this.getFunctions().setCount(count);
        }
    }

    @Override
    public LootPoolEntryType getVanillaType() {
        return LootPoolEntries.ITEM;
    }

    public Item getItem() {
        return (Item)((LootItem)this.vanillaEntry).item.value();
    }

    public void setItem(Item item) {
        if (item == Items.AIR) {
            throw new IllegalStateException("Vanilla Loot Entry cannot be set to AIR, consider using LootEntry.empty()");
        }
        ((LootItem)this.vanillaEntry).item = item.builtInRegistryHolder();
    }

    @Nullable
    public ItemStack create(LootContext context) {
        for (LootItemCondition condition : this.getConditions()) {
            if (condition.test((Object)context)) continue;
            return null;
        }
        ItemStack item = new ItemStack((ItemLike)this.getItem());
        for (LootItemFunction function : this.getFunctions()) {
            item = (ItemStack)function.apply((Object)item, (Object)context);
        }
        return item;
    }

    public boolean test(ItemFilter filter) {
        return filter.test(new ItemStack((ItemLike)this.getItem()));
    }

    @Override
    public ItemLootEntry addCondition(LootItemCondition condition) {
        this.getConditions().add(condition);
        return this;
    }

    @Override
    public void collectDebugInfo(DebugInfo info) {
        info.add("% Item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.getItem())));
        super.collectDebugInfo(info);
    }
}

