/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Upgrade;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.interfaces.IUpgradeTile;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpgradeUtils {
    private UpgradeUtils() {
    }

    public static ItemStack getStack(Upgrade upgrade) {
        return UpgradeUtils.getStack(upgrade, 1);
    }

    public static ItemStack getStack(Upgrade upgrade, int count) {
        return new ItemStack(UpgradeUtils.getItem(upgrade), count);
    }

    public static ItemLike getItem(Upgrade upgrade) {
        return switch (upgrade) {
            default -> throw new MatchException(null, null);
            case Upgrade.SPEED -> MekanismItems.SPEED_UPGRADE;
            case Upgrade.ENERGY -> MekanismItems.ENERGY_UPGRADE;
            case Upgrade.FILTER -> MekanismItems.FILTER_UPGRADE;
            case Upgrade.MUFFLING -> MekanismItems.MUFFLING_UPGRADE;
            case Upgrade.CHEMICAL -> MekanismItems.CHEMICAL_UPGRADE;
            case Upgrade.ANCHOR -> MekanismItems.ANCHOR_UPGRADE;
            case Upgrade.STONE_GENERATOR -> MekanismItems.STONE_GENERATOR_UPGRADE;
        };
    }

    public static List<Component> getInfo(BlockEntity tile, Upgrade upgrade) {
        List<Component> ret = new ArrayList<Component>();
        if (tile instanceof IUpgradeTile) {
            IUpgradeTile upgradeTile = (IUpgradeTile)tile;
            if (tile instanceof Upgrade.IUpgradeInfoHandler) {
                Upgrade.IUpgradeInfoHandler upgradeInfoHandler = (Upgrade.IUpgradeInfoHandler)tile;
                return upgradeInfoHandler.getInfo(upgrade);
            }
            ret = UpgradeUtils.getMultScaledInfo(upgradeTile, upgrade);
        }
        return ret;
    }

    public static List<Component> getMultScaledInfo(IUpgradeTile tile, Upgrade upgrade) {
        ArrayList<Component> ret = new ArrayList<Component>();
        if (tile.supportsUpgrades() && upgrade.getMax() > 1) {
            double effect = Math.pow(MekanismConfig.general.maxUpgradeMultiplier.get(), (float)tile.getComponent().getUpgrades(upgrade) / (float)upgrade.getMax());
            ret.add((Component)MekanismLang.UPGRADES_EFFECT.translate(Float.valueOf((float)Math.round(effect * 100.0) / 100.0f)));
        }
        return ret;
    }

    public static List<Component> getExpScaledInfo(IUpgradeTile tile, Upgrade upgrade) {
        ArrayList<Component> ret = new ArrayList<Component>();
        if (tile.supportsUpgrades() && upgrade.getMax() > 1) {
            ret.add((Component)MekanismLang.UPGRADES_EFFECT.translate(Math.pow(2.0, tile.getComponent().getUpgrades(upgrade))));
        }
        return ret;
    }
}

