/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPITags;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.lib.distribution.Target;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@NothingNullByDefault
public class ChemicalUtil {
    private ChemicalUtil() {
    }

    public static ItemStack getFullChemicalTank(ChemicalTankTier tier, @NotNull Chemical chemical) {
        return ChemicalUtil.getFilledVariant(ChemicalUtil.getEmptyChemicalTank(tier), (IChemicalProvider)chemical);
    }

    private static ItemLike getEmptyChemicalTank(ChemicalTankTier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case ChemicalTankTier.BASIC -> MekanismBlocks.BASIC_CHEMICAL_TANK;
            case ChemicalTankTier.ADVANCED -> MekanismBlocks.ADVANCED_CHEMICAL_TANK;
            case ChemicalTankTier.ELITE -> MekanismBlocks.ELITE_CHEMICAL_TANK;
            case ChemicalTankTier.ULTIMATE -> MekanismBlocks.ULTIMATE_CHEMICAL_TANK;
            case ChemicalTankTier.CREATIVE -> MekanismBlocks.CREATIVE_CHEMICAL_TANK;
        };
    }

    public static ItemStack getFilledVariant(ItemLike toFill, IChemicalProvider provider) {
        return ChemicalUtil.getFilledVariant(new ItemStack(toFill), provider);
    }

    public static ItemStack getFilledVariant(ItemStack toFill, IChemicalProvider provider) {
        IMekanismChemicalHandler attachment = ContainerType.CHEMICAL.createHandler(toFill);
        if (attachment != null) {
            for (IChemicalTank tank : attachment.getChemicalTanks(null)) {
                long amount = tank.getCapacity();
                tank.setStack(provider.getStack(amount));
            }
        }
        return toFill;
    }

    public static int getRGBDurabilityForDisplay(ItemStack stack) {
        ChemicalStack chemicalStack = StorageUtils.getFirstChemicalFromAttachment(stack);
        return chemicalStack.isEmpty() ? 0 : chemicalStack.getChemicalColorRepresentation();
    }

    public static boolean hasAnyChemical(ItemStack stack) {
        return ChemicalUtil.hasChemical(stack, ConstantPredicates.alwaysTrue());
    }

    public static boolean hasChemicalOfType(ItemStack stack, Chemical type) {
        return ChemicalUtil.hasChemical(stack, s -> s.is(type));
    }

    public static boolean hasChemical(ItemStack stack, Predicate<ChemicalStack> validityCheck) {
        IChemicalHandler handler = (IChemicalHandler)stack.getCapability(Capabilities.CHEMICAL.item());
        if (handler != null) {
            for (int tank = 0; tank < handler.getChemicalTanks(); ++tank) {
                ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                if (chemicalStack.isEmpty() || !validityCheck.test(chemicalStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAttributeTooltips(Chemical chemical, Consumer<Component> tooltipAdder) {
        for (ChemicalAttribute attr : chemical.getAttributes()) {
            attr.collectTooltips(tooltipAdder);
        }
    }

    public static void addChemicalDataToTooltip(List<Component> tooltips, ChemicalStack chemical, boolean advanced) {
        ChemicalUtil.addChemicalDataToTooltip(tooltips, chemical.getChemical(), advanced);
    }

    public static void addChemicalDataToTooltip(List<Component> tooltips, Chemical chemical, boolean advanced) {
        if (!chemical.isEmptyType()) {
            ChemicalUtil.addChemicalDataToTooltip(chemical, advanced, tooltips::add);
        }
    }

    public static void addChemicalDataToTooltip(ChemicalStack chemical, boolean advanced, Consumer<Component> tooltipAdder) {
        ChemicalUtil.addChemicalDataToTooltip(chemical.getChemical(), advanced, tooltipAdder);
    }

    private static void addChemicalDataToTooltip(Chemical chemical, boolean advanced, Consumer<Component> tooltipAdder) {
        if (!chemical.isEmptyType()) {
            ChemicalUtil.addAttributeTooltips(chemical.getChemical(), tooltipAdder);
            if (chemical.is(MekanismAPITags.Chemicals.WASTE_BARREL_DECAY_BLACKLIST)) {
                tooltipAdder.accept((Component)MekanismLang.DECAY_IMMUNE.translateColored(EnumColor.AQUA));
            }
            if (advanced) {
                tooltipAdder.accept((Component)TextComponentUtil.build(ChatFormatting.DARK_GRAY, chemical.getRegistryName()));
            }
        }
    }

    public static void emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, IChemicalTank tank) {
        ChemicalUtil.emit(targets, tank, tank.getCapacity());
    }

    public static void emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, IChemicalTank tank, long maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0L) {
            tank.extract(ChemicalUtil.emit(targets, ChemicalStack.EMPTY, tank, maxOutput), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static long emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, @NotNull ChemicalStack stack) {
        return ChemicalUtil.emit(targets, stack, null, Long.MAX_VALUE);
    }

    private static long emit(Collection<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> targets, @NotNull ChemicalStack stack, @UnknownNullability IChemicalTank tank, long maxOutput) {
        if (stack.isEmpty() && tank == null) {
            return 0L;
        }
        if (targets.isEmpty()) {
            return 0L;
        }
        Target target = null;
        for (BlockCapabilityCache<IChemicalHandler, Direction> capability : targets) {
            IChemicalHandler handler = (IChemicalHandler)capability.getCapability();
            if (handler == null) continue;
            if (stack.isEmpty() && (stack = tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL)).isEmpty()) {
                return 0L;
            }
            if (!ChemicalUtil.canInsert(handler, stack)) continue;
            if (target == null) {
                target = new ChemicalHandlerTarget(targets.size());
            }
            target.addHandler(handler);
        }
        return EmitUtils.sendToAcceptors(target, stack.getAmount(), stack.copy());
    }

    public static boolean canInsert(IChemicalHandler handler, @NotNull ChemicalStack stack) {
        return handler.insertChemical(stack, Action.SIMULATE).getAmount() < stack.getAmount();
    }

    public static Chemical chemical(ChemicalBuilder builder, @Nullable Integer colorRepresentation) {
        if (colorRepresentation == null) {
            return new Chemical(builder);
        }
        final int color = colorRepresentation;
        return new Chemical(builder){

            @Override
            public int getColorRepresentation() {
                return color;
            }
        };
    }
}

