/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.IAlloyInteraction;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.AlloyTier;
import mekanism.api.tier.BaseTier;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.AlloyUpgradeTrigger;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.block.transmitter.BlockLargeTransmitter;
import mekanism.common.block.transmitter.BlockSmallTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.proxy.ProxyConfigurable;
import mekanism.common.capabilities.resolver.BasicSidedCapabilityResolver;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityTransmitter
extends CapabilityTileEntity
implements ProxyConfigurable.ISidedConfigurable,
IAlloyInteraction {
    public static final ICapabilityProvider<TileEntityTransmitter, @Nullable Direction, IConfigurable> CONFIGURABLE_PROVIDER = TileEntityTransmitter.capabilityProvider(Capabilities.CONFIGURABLE, (tile, cap) -> new BasicSidedCapabilityResolver<IConfigurable, TileEntityTransmitter>((TileEntityTransmitter)tile, (BlockCapability<IConfigurable, Direction>)cap, ProxyConfigurable::new));
    public static final ModelProperty<TransmitterModelData> TRANSMITTER_PROPERTY = new ModelProperty();
    private final Transmitter<?, ?, ?> transmitter;
    private boolean forceUpdate = true;
    private boolean loaded = false;
    private boolean markJoined = false;

    public TileEntityTransmitter(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(((IHasTileEntity)blockProvider.getBlock()).getTileType(), pos, state);
        this.transmitter = this.createTransmitter(blockProvider);
        this.cacheCoord();
    }

    protected abstract Transmitter<?, ?, ?> createTransmitter(IBlockProvider var1);

    public Transmitter<?, ?, ?> getTransmitter() {
        return this.transmitter;
    }

    @Override
    public void setLevel(@NotNull Level level) {
        super.setLevel(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.getTransmitter().getAcceptorCache().initializeCache(serverLevel);
        }
    }

    public void setForceUpdate() {
        this.forceUpdate = true;
    }

    public abstract TransmitterType getTransmitterType();

    protected void onUpdateServer() {
        if (this.markJoined) {
            this.onWorldJoin(false);
            this.markJoined = false;
        }
        if (this.forceUpdate) {
            this.getTransmitter().refreshConnections();
            this.forceUpdate = false;
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, TileEntityTransmitter transmitter) {
        transmitter.onUpdateServer();
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        return this.getTransmitter().getReducedUpdateTag(provider, super.getReducedUpdateTag(provider));
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        if (this.getTransmitter().handleUpdateTag(tag, provider)) {
            this.updateModelData();
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.getTransmitter().read(provider, nbt);
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        this.getTransmitter().write(provider, nbtTags);
    }

    public void onNeighborBlockChange(Direction side) {
        this.getTransmitter().onNeighborBlockChange(side);
    }

    @Override
    public void clearRemoved() {
        super.clearRemoved();
        if (this.isRemote()) {
            this.onWorldJoin(false);
        } else {
            this.markJoined = true;
        }
    }

    public void onChunkUnloaded() {
        if (!this.isRemote()) {
            this.getTransmitter().takeShare();
        }
        super.onChunkUnloaded();
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        this.onWorldSeparate(false);
        this.getTransmitter().remove();
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.onWorldJoin(false);
        this.getTransmitter().refreshConnections();
    }

    private void onWorldJoin(boolean wasPresent) {
        if (!this.isRemote() && !wasPresent) {
            TransmitterNetworkRegistry.trackTransmitter(this.getTransmitter());
        }
        if (!this.loaded) {
            this.loaded = true;
            if (!this.isRemote()) {
                TransmitterNetworkRegistry.registerOrphanTransmitter(this.getTransmitter());
            }
        }
    }

    private void onWorldSeparate(boolean stillPresent) {
        if (!this.isRemote() && !stillPresent) {
            TransmitterNetworkRegistry.untrackTransmitter(this.getTransmitter());
        }
        if (this.loaded) {
            this.loaded = false;
            if (this.isRemote()) {
                this.getTransmitter().setTransmitterNetwork(null);
            } else {
                TransmitterNetworkRegistry.invalidateTransmitter(this.getTransmitter());
            }
        }
    }

    public void chunkAccessibilityChange(boolean loaded) {
        if (loaded) {
            this.onWorldJoin(true);
        } else {
            this.getTransmitter().validateAndTakeShare();
            this.onWorldSeparate(true);
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Direction getSideLookingAt(Player player, Direction fallback) {
        Direction side = this.getSideLookingAt(player);
        return side == null ? fallback : side;
    }

    @Nullable
    public Direction getSideLookingAt(Player player) {
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace((Entity)player, this.getBlockPos(), this.getCollisionBoxes());
        if (result != null && result.valid()) {
            ArrayList<Direction> list = new ArrayList<Direction>(EnumUtils.DIRECTIONS.length);
            byte connections = this.getTransmitter().getAllCurrentConnections();
            for (Direction dir : EnumUtils.DIRECTIONS) {
                if (!Transmitter.connectionMapContainsSide(connections, dir)) continue;
                list.add(dir);
            }
            int boxIndex = result.subHit + 1;
            if (boxIndex < list.size()) {
                return (Direction)list.get(boxIndex);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public InteractionResult onSneakRightClick(@NotNull Player player, @NotNull Direction side) {
        if (!this.isRemote()) {
            Direction hitSide = this.getSideLookingAt(player);
            if (hitSide == null) {
                InteractionResult result;
                if (this.transmitter.getConnectionTypeRaw(side) != ConnectionType.NONE && (result = this.onConfigure(player, side)).consumesAction()) {
                    this.getTransmitter().refreshConnections();
                    this.getTransmitter().notifyTileChange();
                    return result;
                }
                hitSide = side;
            }
            this.transmitter.setConnectionTypeRaw(hitSide, (ConnectionType)this.transmitter.getConnectionTypeRaw(hitSide).getNext());
            this.getTransmitter().onModeChange(Direction.from3DDataValue((int)hitSide.ordinal()));
            this.getTransmitter().refreshConnections();
            this.getTransmitter().notifyTileChange();
            player.displayClientMessage((Component)MekanismLang.CONNECTION_TYPE.translateColored(EnumColor.GRAY, this.transmitter.getConnectionTypeRaw(hitSide)), true);
            this.sendUpdatePacket();
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult onConfigure(Player player, Direction side) {
        return this.getTransmitter().onConfigure(player, side);
    }

    @Override
    @NotNull
    public InteractionResult onRightClick(@NotNull Player player, @NotNull Direction side) {
        return this.getTransmitter().onRightClick(player, side);
    }

    public List<VoxelShape> getCollisionBoxes() {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        boolean isSmall = this.getTransmitterType().getSize() == TransmitterType.Size.SMALL;
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = this.getTransmitter().getConnectionType(side);
            if (connectionType == ConnectionType.NONE) continue;
            if (isSmall) {
                list.add(BlockSmallTransmitter.getSideForType(connectionType, side));
                continue;
            }
            list.add(BlockLargeTransmitter.getSideForType(connectionType, side));
        }
        list.add(isSmall ? BlockSmallTransmitter.CENTER : BlockLargeTransmitter.CENTER);
        return list;
    }

    @NotNull
    public ModelData getModelData() {
        TransmitterModelData data = this.initModelData();
        this.updateModelData(data);
        return ModelData.of(TRANSMITTER_PROPERTY, (Object)data);
    }

    protected void updateModelData(TransmitterModelData modelData) {
        for (Direction side : EnumUtils.DIRECTIONS) {
            modelData.setConnectionData(side, this.getTransmitter().getConnectionType(side));
        }
    }

    @NotNull
    protected TransmitterModelData initModelData() {
        return new TransmitterModelData();
    }

    @Override
    public void onAlloyInteraction(Player player, ItemStack stack, @NotNull AlloyTier tier) {
        if (this.getLevel() != null && this.getTransmitter().hasTransmitterNetwork()) {
            Object transmitterNetwork = this.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(((DynamicNetwork)transmitterNetwork).getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getBlockPos().distSqr((Vec3i)this.worldPosition), o2.getBlockPos().distSqr((Vec3i)this.worldPosition));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                BlockState upgradeState;
                TileEntityTransmitter transmitterTile;
                BlockState state;
                IUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IUpgradeableTransmitter) || !(upgradeableTransmitter = (IUpgradeableTransmitter)((Object)transmitter)).canUpgrade(tier) || (state = (transmitterTile = transmitter.getTransmitterTile()).getBlockState()) == (upgradeState = transmitterTile.upgradeResult(state, tier.getBaseTier()))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        DynamicBufferedNetwork dynamicNetwork = (DynamicBufferedNetwork)transmitterNetwork;
                        dynamicNetwork.validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                Object upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getBlockPos();
                Level transmitterWorld = transmitter.getLevel();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.setBlockAndUpdate(transmitterPos, upgradeState);
                TileEntityTransmitter upgradedTile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)transmitterWorld, transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter<?, ?, ?> upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IUpgradeableTransmitter) {
                    this.transferUpgradeData((IUpgradeableTransmitter)((Object)upgradedTransmitter), (TransmitterUpgradeData)upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                ((DynamicNetwork)transmitterNetwork).invalidate(null);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((AlloyUpgradeTrigger)((Object)MekanismCriteriaTriggers.ALLOY_UPGRADE.value())).trigger(serverPlayer);
                }
            }
        }
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }

    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return current;
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
    }

    public void redstoneChanged(boolean powered) {
    }

    protected Predicate<@Nullable Direction> getExtractPredicate() {
        return side -> {
            if (side == null) {
                return true;
            }
            return this.getTransmitter().getConnectionType((Direction)side).canSendTo();
        };
    }

    protected Predicate<@Nullable Direction> getInsertPredicate() {
        return side -> {
            if (side == null) {
                return true;
            }
            return this.getTransmitter().getConnectionType((Direction)side).canAccept();
        };
    }
}

