/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.item.CursedTransporterItemHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityLogisticalTransporterBase
extends TileEntityTransmitter {
    protected TileEntityLogisticalTransporterBase(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(new TransporterCapabilityResolver());
    }

    protected abstract LogisticalTransporterBase createTransmitter(IBlockProvider var1);

    public LogisticalTransporterBase getTransmitter() {
        return (LogisticalTransporterBase)super.getTransmitter();
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, TileEntityLogisticalTransporterBase transmitter) {
        transmitter.getTransmitter().onUpdateClient();
    }

    @Override
    public void onUpdateServer() {
        super.onUpdateServer();
        this.getTransmitter().onUpdateServer();
    }

    @Override
    public void blockRemoved() {
        LogisticalTransporterBase transporter;
        super.blockRemoved();
        if (!this.isRemote() && !(transporter = this.getTransmitter()).isUpgrading()) {
            for (TransporterStack stack : transporter.getTransit()) {
                TransporterUtils.drop(transporter, stack);
            }
        }
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE && old != ConnectionType.PUSH || type == ConnectionType.PUSH && old != ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.ITEM.block(), side);
        } else if (old == ConnectionType.NONE && type != ConnectionType.PUSH || old == ConnectionType.PUSH && type != ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    @NothingNullByDefault
    private class TransporterCapabilityResolver
    implements ICapabilityResolver<Direction> {
        private static final List<BlockCapability<?, @Nullable Direction>> SUPPORTED_CAPABILITY = Collections.singletonList(Capabilities.ITEM.block());
        private final Map<Direction, CursedTransporterItemHandler> cursedHandlers = new EnumMap<Direction, CursedTransporterItemHandler>(Direction.class);
        private final Map<Direction, IItemHandler> handlers = new EnumMap<Direction, IItemHandler>(Direction.class);

        private TransporterCapabilityResolver() {
        }

        @Override
        public List<BlockCapability<?, @Nullable Direction>> getSupportedCapabilities() {
            return SUPPORTED_CAPABILITY;
        }

        @Override
        @Nullable
        public <T> T resolve(BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side) {
            LogisticalTransporterBase transporter;
            if (side == null) {
                return null;
            }
            IItemHandler cachedCapability = this.handlers.get(side);
            if (cachedCapability == null && (transporter = TileEntityLogisticalTransporterBase.this.getTransmitter()).exposesInsertCap(side)) {
                CursedTransporterItemHandler cached = this.cursedHandlers.get(side);
                if (cached == null) {
                    cached = new CursedTransporterItemHandler(transporter, WorldUtils.relativePos(TileEntityLogisticalTransporterBase.this.getWorldPositionLong(), side), () -> TileEntityLogisticalTransporterBase.this.level == null ? -1L : TileEntityLogisticalTransporterBase.this.level.getGameTime());
                    this.cursedHandlers.put(side, cached);
                }
                this.handlers.put(side, cached);
                return (T)cached;
            }
            return (T)cachedCapability;
        }

        @Override
        public void invalidate(BlockCapability<?, @Nullable Direction> capability, @Nullable Direction side) {
            if (side != null) {
                this.handlers.remove(side);
            }
        }

        @Override
        public void invalidateAll() {
            this.handlers.clear();
        }
    }
}

