/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.item.CursedTransporterItemHandler;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.InternalInventorySlot;
import mekanism.common.lib.SidedBlockPos;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.IAdvancedTransportEjector;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityQIOExporter
extends TileEntityQIOFilterHandler
implements IAdvancedTransportEjector {
    private static final EfficientEjector<Object2LongMap.Entry<HashedItem>> FILTER_EJECTOR = new EfficientEjector<Object2LongMap.Entry>(Map.Entry::getKey, e -> MathUtils.clampToInt(e.getLongValue()), (exporter, freq) -> exporter.getFilterEjectMap((QIOFrequency)freq).object2LongEntrySet());
    private static final EfficientEjector<Map.Entry<HashedItem, QIOFrequency.QIOItemTypeData>> FILTERLESS_EJECTOR = new EfficientEjector<Map.Entry>(Map.Entry::getKey, e -> MathUtils.clampToInt(((QIOFrequency.QIOItemTypeData)e.getValue()).getCount()), (exporter, freq) -> freq.getItemDataMap().entrySet());
    private static final int MAX_DELAY = 10;
    @Nullable
    private @Nullable BlockCapabilityCache<IItemHandler, @Nullable Direction> backInventory;
    private int delay = 0;
    private boolean exportWithoutFilter;
    private boolean roundRobin;
    @Nullable
    private SidedBlockPos rrTarget;

    public TileEntityQIOExporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_EXPORTER, pos, state);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this.facingSupplier);
        builder.addSlot(InternalInventorySlot.create(listener), RelativeSide.BACK);
        return builder.build();
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        return type != ContainerType.ITEM && super.persists(type);
    }

    @Override
    protected boolean onUpdateServer(@Nullable QIOFrequency frequency) {
        boolean needsUpdate = super.onUpdateServer(frequency);
        if (frequency != null && this.canFunction()) {
            if (this.delay > 0) {
                --this.delay;
            } else {
                this.tryEject(frequency);
                this.delay = 10;
            }
        }
        return needsUpdate;
    }

    @Override
    protected void invalidateDirectionCaches(Direction newDirection) {
        super.invalidateDirectionCaches(newDirection);
        this.backInventory = null;
    }

    private void tryEject(QIOFrequency freq) {
        EfficientEjector<Object> ejector;
        IItemHandler backHandler;
        if (this.backInventory == null) {
            Direction direction = this.getDirection();
            this.backInventory = Capabilities.ITEM.createCache((ServerLevel)this.level, this.worldPosition.relative(direction.getOpposite()), direction);
        }
        if ((backHandler = (IItemHandler)this.backInventory.getCapability()) == null) {
            return;
        }
        if (this.getFilterManager().hasEnabledFilters()) {
            ejector = FILTER_EJECTOR;
        } else if (this.exportWithoutFilter) {
            ejector = FILTERLESS_EJECTOR;
        } else {
            return;
        }
        ejector.eject(this, freq, backHandler);
    }

    private Object2LongMap<HashedItem> getFilterEjectMap(QIOFrequency freq) {
        Object2LongOpenHashMap map = new Object2LongOpenHashMap();
        for (QIOFilter filter : this.getFilterManager().getEnabledFilters()) {
            if (filter instanceof QIOItemStackFilter) {
                QIOItemStackFilter itemFilter = (QIOItemStackFilter)filter;
                if (itemFilter.fuzzyMode) {
                    map.putAll(freq.getStacksByItem(itemFilter.getItemStack().getItem()));
                    continue;
                }
                HashedItem type = HashedItem.create(itemFilter.getItemStack());
                map.put((Object)type, freq.getStoredByHash(type));
                continue;
            }
            if (filter instanceof QIOTagFilter) {
                QIOTagFilter tagFilter = (QIOTagFilter)filter;
                String tagName = tagFilter.getTagName();
                map.putAll(freq.getStacksByTagWildcard(tagName));
                continue;
            }
            if (!(filter instanceof QIOModIDFilter)) continue;
            QIOModIDFilter modIDFilter = (QIOModIDFilter)filter;
            String modID = modIDFilter.getModID();
            map.putAll(freq.getStacksByModIDWildcard(modID));
        }
        return map;
    }

    @ComputerMethod
    public boolean getExportWithoutFilter() {
        return this.exportWithoutFilter;
    }

    public void toggleExportWithoutFilter() {
        this.exportWithoutFilter = !this.exportWithoutFilter;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getExportWithoutFilter, value -> {
            this.exportWithoutFilter = value;
        }));
        container.track(SyncableBoolean.create(this::getRoundRobin, value -> {
            this.roundRobin = value;
        }));
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        SidedBlockPos rrTarget = this.getRoundRobinTarget();
        if (rrTarget != null) {
            nbtTags.put("rr_target", (Tag)rrTarget.serialize());
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (nbt.contains("rr_target", 10)) {
            this.setRoundRobinTarget(SidedBlockPos.deserialize(nbt.getCompound("rr_target")));
        }
    }

    @Override
    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("rr_target");
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        dataMap.putBoolean("auto", this.exportWithoutFilter);
        dataMap.putBoolean("round_robin", this.roundRobin);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "auto", value -> {
            this.exportWithoutFilter = value;
        });
        this.roundRobin = dataMap.getBoolean("round_robin");
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MekanismDataComponents.AUTO, (Object)this.exportWithoutFilter);
        builder.set(MekanismDataComponents.ROUND_ROBIN, (Object)this.roundRobin);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.exportWithoutFilter = (Boolean)input.getOrDefault(MekanismDataComponents.AUTO, (Object)this.exportWithoutFilter);
        this.roundRobin = (Boolean)input.getOrDefault(MekanismDataComponents.ROUND_ROBIN, (Object)this.roundRobin);
    }

    @Override
    @Nullable
    public SidedBlockPos getRoundRobinTarget() {
        return this.rrTarget;
    }

    @Override
    public void setRoundRobinTarget(@Nullable SidedBlockPos target) {
        this.rrTarget = target;
    }

    @Override
    @ComputerMethod(nameOverride="isRoundRobin")
    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    @Override
    public void toggleRoundRobin() {
        this.roundRobin = !this.roundRobin;
        this.setRoundRobinTarget((SidedBlockPos)null);
        this.markForSave();
    }

    @Override
    public boolean canSendHome(@NotNull ItemStack stack) {
        QIOFrequency frequency = this.getQIOFrequency();
        return frequency != null && frequency.massInsert(stack, stack.getCount(), Action.SIMULATE) > 0L;
    }

    @Override
    @NotNull
    public TransitRequest.TransitResponse sendHome(@NotNull TransitRequest request) {
        if (request.isEmpty()) {
            return request.getEmptyResponse();
        }
        QIOFrequency frequency = this.getQIOFrequency();
        if (frequency != null) {
            for (TransitRequest.ItemData data : request) {
                ItemStack remainder;
                ItemStack origInsert = StackUtils.size(data.getStack(), data.getTotalCount());
                if (!TransporterManager.didEmit(origInsert, remainder = frequency.addItem(origInsert))) continue;
                return request.createResponse(TransporterManager.getToUse(origInsert, remainder), data);
            }
        }
        return request.getEmptyResponse();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setExportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.exportWithoutFilter != value) {
            this.toggleExportWithoutFilter();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setRoundRobin(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.roundRobin != value) {
            this.toggleRoundRobin();
        }
    }

    private record EfficientEjector<T>(Function<T, HashedItem> typeSupplier, ToIntFunction<T> countSupplier, BiFunction<TileEntityQIOExporter, QIOFrequency, Collection<T>> ejectMapCalculator) {
        private static final double MAX_EJECT_ATTEMPTS = 100.0;

        private void eject(TileEntityQIOExporter exporter, QIOFrequency freq, IItemHandler inventory) {
            int slots = inventory.getSlots();
            if (slots == 0) {
                return;
            }
            Collection<T> ejectMap = this.ejectMapCalculator.apply(exporter, freq);
            if (ejectMap.isEmpty()) {
                return;
            }
            LogisticalTransporterBase transporter = null;
            LogisticalTransporterBase.PathCalculator<TileEntityQIOExporter> pathCalculator = null;
            if (inventory instanceof CursedTransporterItemHandler) {
                CursedTransporterItemHandler cursed = (CursedTransporterItemHandler)inventory;
                transporter = cursed.getTransporter();
                if (!transporter.hasTransmitterNetwork()) {
                    return;
                }
                Direction from = exporter.getDirection();
                if (!transporter.canReceiveFrom(from) || !transporter.canConnectMutual(from, exporter)) {
                    return;
                }
                pathCalculator = exporter.getRoundRobin() ? TransporterStack::recalculateRRPath : TransporterStack::recalculatePath;
            }
            RandomSource random = exporter.getLevel().getRandom();
            double ejectChance = Math.min(1.0, 100.0 / (double)ejectMap.size());
            boolean randomizeEject = ejectChance < 1.0;
            int maxTypes = exporter.getMaxTransitTypes();
            int maxCount = exporter.getMaxTransitCount();
            Object2IntOpenHashMap removed = new Object2IntOpenHashMap();
            int amountRemoved = 0;
            for (T obj : ejectMap) {
                int toUse;
                if (amountRemoved == maxCount || removed.size() == maxTypes) break;
                if (randomizeEject && random.nextDouble() > ejectChance) continue;
                HashedItem type = this.typeSupplier.apply(obj);
                int amountToInsert = Math.min(maxCount - amountRemoved, this.countSupplier.applyAsInt(obj));
                ItemStack origInsert = type.createStack(amountToInsert);
                if (transporter == null) {
                    ItemStack toInsert = origInsert.copy();
                    for (int i = 0; i < slots && !(toInsert = inventory.insertItem(i, toInsert, false)).isEmpty(); ++i) {
                    }
                    toUse = TransporterManager.getToUse(origInsert, toInsert).getCount();
                } else {
                    TransitRequest.SimpleTransitRequest request = TransitRequest.simple(origInsert);
                    TransitRequest.TransitResponse response = transporter.insertUnchecked(exporter, request, transporter.getColor(), true, 1, pathCalculator);
                    toUse = response.getSendingAmount();
                }
                if (toUse <= 0) continue;
                amountRemoved += toUse;
                removed.mergeInt((Object)type, toUse, Integer::sum);
            }
            ObjectIterator iterator = Object2IntMaps.fastIterator((Object2IntMap)removed);
            while (iterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                int amount = entry.getIntValue();
                ItemStack ret = freq.removeByType((HashedItem)entry.getKey(), amount);
                if (ret.getCount() == amount) continue;
                Mekanism.logger.error("QIO ejection item removal didn't line up with prediction: removed {}, expected {}", (Object)ret.getCount(), (Object)amount);
            }
        }
    }
}

