/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.attachments.containers.item.AttachedItems;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowOutputInventorySlot;
import mekanism.common.network.to_client.qio.BulkQIOData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityQIODashboard
extends TileEntityQIOComponent
implements IQIOCraftingWindowHolder {
    private QIOCraftingWindow[] craftingWindows;
    private boolean insertIntoFrequency = true;
    private boolean recipesChecked = false;

    public TileEntityQIODashboard(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_DASHBOARD, pos, state);
    }

    @Override
    protected void presetVariables() {
        super.presetVariables();
        this.craftingWindows = new QIOCraftingWindow[3];
        for (byte tableIndex = 0; tableIndex < this.craftingWindows.length; tableIndex = (byte)(tableIndex + 1)) {
            this.craftingWindows[tableIndex] = new QIOCraftingWindow(this, tableIndex);
        }
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.readOnly();
        for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
            for (int slot = 0; slot < 9; ++slot) {
                builder.addSlot(craftingWindow.getInputSlot(slot));
            }
            builder.addSlot(craftingWindow.getOutputSlot());
        }
        return builder.build();
    }

    @Override
    public void applyInventorySlots(BlockEntity.DataComponentInput input, List<IInventorySlot> slots, AttachedItems attachedItems) {
        List<ItemStack> stacks = attachedItems.containers();
        int size = stacks.size();
        if (size == slots.size()) {
            for (int i = 0; i < size; ++i) {
                IInventorySlot slot = slots.get(i);
                if (slot instanceof CraftingWindowOutputInventorySlot) {
                    slot.setEmpty();
                    continue;
                }
                ItemStack stack = stacks.get(i).copy();
                if (slot instanceof BasicInventorySlot) {
                    BasicInventorySlot basicSlot = (BasicInventorySlot)slot;
                    basicSlot.setStackUnchecked(stack);
                    continue;
                }
                slot.setStack(stack);
            }
        }
    }

    @Override
    @Nullable
    public AttachedItems collectInventorySlots(DataComponentMap.Builder builder, List<IInventorySlot> slots) {
        boolean hasNonEmpty = false;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(slots.size());
        for (IInventorySlot slot : slots) {
            ItemStack stack = slot instanceof CraftingWindowOutputInventorySlot ? ItemStack.EMPTY : slot.getStack().copy();
            stacks.add(stack);
            if (stack.isEmpty()) continue;
            hasNonEmpty = true;
        }
        return hasNonEmpty ? new AttachedItems(stacks) : null;
    }

    @Override
    protected boolean onUpdateServer(@Nullable QIOFrequency frequency) {
        boolean needsUpdate = super.onUpdateServer(frequency);
        if (CommonWorldTickHandler.flushTagAndRecipeCaches || !this.recipesChecked) {
            this.recipesChecked = true;
            for (QIOCraftingWindow craftingWindow : this.craftingWindows) {
                craftingWindow.invalidateRecipe();
            }
        }
        return needsUpdate;
    }

    @Override
    public void encodeExtraContainerData(RegistryFriendlyByteBuf buffer) {
        super.encodeExtraContainerData(buffer);
        BulkQIOData.encodeToPacket(buffer, this.getFrequency());
    }

    @Override
    public QIOCraftingWindow[] getCraftingWindows() {
        return this.craftingWindows;
    }

    @Override
    @Nullable
    public QIOFrequency getFrequency() {
        return this.getQIOFrequency();
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        dataMap.putBoolean("insert_into_frequency", this.insertIntoFrequency);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "insert_into_frequency", value -> {
            this.insertIntoFrequency = value;
        });
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MekanismDataComponents.INSERT_INTO_FREQUENCY, (Object)this.insertIntoFrequency);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.insertIntoFrequency = (Boolean)input.getOrDefault(MekanismDataComponents.INSERT_INTO_FREQUENCY, (Object)this.insertIntoFrequency);
    }

    public boolean shiftClickIntoFrequency() {
        return this.insertIntoFrequency;
    }

    public void toggleShiftClickDirection() {
        this.insertIntoFrequency = !this.insertIntoFrequency;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::shiftClickIntoFrequency, value -> {
            this.insertIntoFrequency = value;
        }));
    }

    private void validateWindow(int window) throws ComputerException {
        if (window < 0 || window >= this.craftingWindows.length) {
            throw new ComputerException("Window '%d' is out of bounds, must be between 0 and %d.", window, this.craftingWindows.length);
        }
    }

    @ComputerMethod
    ItemStack getCraftingInput(int window, int slot) throws ComputerException {
        this.validateWindow(window);
        if (slot < 0 || slot >= 9) {
            throw new ComputerException("Slot '%d' is out of bounds, must be between 0 and 9.", slot);
        }
        return this.craftingWindows[window].getInputSlot(slot).getStack();
    }

    @ComputerMethod
    ItemStack getCraftingOutput(int window) throws ComputerException {
        this.validateWindow(window);
        return this.craftingWindows[window].getOutputSlot().getStack();
    }
}

