/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.HashSet;
import java.util.UUID;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.SparkleAnimation;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.BoundMethodHolder;
import mekanism.common.integration.computer.FactoryRegistry;
import mekanism.common.integration.computer.MethodRestriction;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.dynamic.SyncMapper;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityMultiblock<T extends MultiblockData>
extends TileEntityMekanism
implements IMultiblock<T>,
IConfigurable {
    private Structure structure = Structure.INVALID;
    private final T defaultMultiblock = this.createMultiblock();
    private boolean prevStructure;
    private boolean isMaster;
    @Nullable
    private UUID cachedID = null;
    private long unformedTicks = 100L;

    public TileEntityMultiblock(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.cacheCoord();
    }

    @Override
    public void setStructure(Structure structure) {
        this.structure = structure;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public T getDefaultData() {
        return this.defaultMultiblock;
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (!this.getMultiblock().isFormed()) {
            ++this.unformedTicks;
            if (!this.playersUsing.isEmpty()) {
                for (Player player : new HashSet(this.playersUsing)) {
                    player.closeContainer();
                }
            }
        } else {
            this.unformedTicks = 0L;
        }
    }

    @Override
    protected boolean onUpdateServer() {
        boolean needsPacket = super.onUpdateServer();
        if (this.ticker >= 3) {
            this.structure.tick(this, this.ticker % 10 == 0);
        }
        MultiblockData multiblock = this.getMultiblock();
        if (this.isMaster() && multiblock.isFormed() && multiblock.recheckStructure) {
            multiblock.recheckStructure = false;
            this.getStructure().doImmediateUpdate(this, this.ticker % 10 == 0);
            multiblock = this.getMultiblock();
        }
        if (multiblock.isFormed()) {
            if (!this.prevStructure) {
                this.structureChanged(multiblock);
                this.prevStructure = true;
                needsPacket = true;
            }
            if (multiblock.inventoryID != null) {
                UUID oldCachedID = this.cachedID;
                this.cachedID = multiblock.inventoryID;
                if (oldCachedID != this.cachedID) {
                    this.markForSave();
                }
                if (this.isMaster()) {
                    if (multiblock.tick(this.level)) {
                        needsPacket = true;
                    }
                    this.getManager().handleDirtyMultiblock(multiblock);
                }
            }
        } else {
            if (!this.playersUsing.isEmpty()) {
                this.playersUsing.forEach(Player::closeContainer);
            }
            if (this.prevStructure) {
                this.structureChanged(multiblock);
                this.prevStructure = false;
                needsPacket = true;
            }
            this.isMaster = false;
        }
        return needsPacket |= this.onUpdateServer(multiblock);
    }

    protected boolean onUpdateServer(T multiblock) {
        return false;
    }

    @Override
    public void resetForFormed() {
        this.isMaster = false;
        this.prevStructure = false;
    }

    protected void structureChanged(T multiblock) {
        this.invalidateCapabilitiesFull();
        if (((MultiblockData)multiblock).isFormed() && !((MultiblockData)multiblock).hasMaster && this.canBeMaster()) {
            ((MultiblockData)multiblock).hasMaster = true;
            this.isMaster = true;
            ((MultiblockData)multiblock).forceUpdateComparatorLevel();
            ((MultiblockData)multiblock).notifyAllUpdateComparator(this.level);
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos pos = this.getBlockPos();
        for (Direction side : EnumUtils.DIRECTIONS) {
            mutable.setWithOffset((Vec3i)pos, side);
            if (((MultiblockData)multiblock).isFormed() && ((MultiblockData)multiblock).isKnownLocation((BlockPos)mutable)) continue;
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)this.level, (BlockPos)mutable);
            if (this.level.isEmptyBlock((BlockPos)mutable) || tile != null && tile.getClass() == this.getClass() || tile instanceof IStructuralMultiblock || tile instanceof IMultiblock) continue;
            WorldUtils.notifyNeighborOfChange(this.level, (BlockPos)mutable, pos);
        }
        if (!((MultiblockData)multiblock).isFormed()) {
            this.markDirtyComparator();
        }
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return false;
    }

    @Override
    public boolean canBeMaster() {
        return true;
    }

    @Override
    public ItemInteractionResult onActivate(Player player, InteractionHand hand, ItemStack stack) {
        if (player.isShiftKeyDown() || !this.getMultiblock().isFormed()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        InteractionResult result = this.openGui(player);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case InteractionResult.SUCCESS, InteractionResult.SUCCESS_NO_ITEM_USED -> ItemInteractionResult.SUCCESS;
            case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
            case InteractionResult.CONSUME_PARTIAL -> ItemInteractionResult.CONSUME_PARTIAL;
            case InteractionResult.PASS -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
        };
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (!this.isRemote()) {
            this.structure.invalidate(this.level);
        }
    }

    @Override
    public boolean shouldDumpRadiation() {
        return false;
    }

    @Override
    public void resetCache() {
        this.cachedID = null;
    }

    @Override
    @Nullable
    public UUID getCacheID() {
        return this.cachedID;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putBoolean("rendering", this.isMaster());
        MultiblockData multiblock = this.getMultiblock();
        updateTag.putBoolean("has_structure", multiblock.isFormed());
        if (multiblock.isFormed() && this.isMaster()) {
            multiblock.writeUpdateTag(updateTag, provider);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setBooleanIfPresent(tag, "rendering", value -> {
            this.isMaster = value;
        });
        MultiblockData multiblock = this.getMultiblock();
        NBTUtils.setBooleanIfPresent(tag, "has_structure", multiblock::setFormedForce);
        if (this.isMaster()) {
            if (multiblock.isFormed()) {
                multiblock.readUpdateTag(tag, provider);
                this.doMultiblockSparkle(multiblock);
            } else {
                this.isMaster = false;
            }
        }
        this.prevStructure = multiblock.isFormed();
    }

    private void doMultiblockSparkle(T multiblock) {
        LocalPlayer player;
        if (this.isRemote() && ((MultiblockData)multiblock).renderLocation != null && !this.prevStructure && this.unformedTicks >= 5L && (player = Minecraft.getInstance().player) != null && this.worldPosition.distSqr((Vec3i)player.blockPosition()) <= 1600.0) {
            if (MekanismConfig.client.enableMultiblockFormationParticles.get()) {
                new SparkleAnimation(this, ((MultiblockData)multiblock).renderLocation, ((MultiblockData)multiblock).length() - 1, ((MultiblockData)multiblock).width() - 1, ((MultiblockData)multiblock).height() - 1).run();
            } else {
                player.displayClientMessage((Component)MekanismLang.MULTIBLOCK_FORMED_CHAT.translateColored(EnumColor.INDIGO), true);
            }
        }
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (!this.getMultiblock().isFormed()) {
            NBTUtils.setUUIDIfPresent(nbt, "inventory_id", id -> {
                this.cachedID = id;
            });
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbtTags, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        if (this.cachedID != null) {
            nbtTags.putUUID("inventory_id", this.cachedID);
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        SyncMapper.INSTANCE.setup(container, this.getMultiblock().getClass(), this::getMultiblock);
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.ITEM) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return side -> this.getMultiblock().getInventorySlots(side);
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        MultiblockData multiblock;
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote() && (multiblock = this.getMultiblock()).isPositionInsideBounds(this.getStructure(), neighborPos) && (this.level.isEmptyBlock(neighborPos) || !multiblock.internalLocations.contains(neighborPos))) {
            this.getStructure().markForUpdate(this.level, true);
        }
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        FormationProtocol.FormationResult result;
        if (!(this.isRemote() || this.getMultiblock().isFormed() || (result = this.getStructure().runUpdate(this)).isFormed() || result.getResultText() == null)) {
            player.sendSystemMessage(result.getResultText());
            return InteractionResult.sidedSuccess((boolean)this.isRemote());
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        return InteractionResult.PASS;
    }

    public boolean exposesMultiblockToComputer() {
        return true;
    }

    @Override
    public boolean isComputerCapabilityPersistent() {
        return !this.exposesMultiblockToComputer() && super.isComputerCapabilityPersistent();
    }

    @Override
    public void getComputerMethods(BoundMethodHolder holder) {
        MultiblockData multiblock;
        super.getComputerMethods(holder);
        if (this.exposesMultiblockToComputer() && (multiblock = this.getMultiblock()).isFormed()) {
            FactoryRegistry.bindTo(holder, multiblock);
        }
    }

    @ComputerMethod(restriction=MethodRestriction.MULTIBLOCK)
    boolean isFormed() {
        return this.getMultiblock().isFormed();
    }
}

