/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.List;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.functions.LongObjectToLongFunction;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.recipes.vanilla_input.SingleFluidRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.energy.FixedUsageEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityElectrolyticSeparator
extends TileEntityRecipeMachine<ElectrolysisRecipe>
implements IHasGasMode,
ISingleRecipeLookupHandler.FluidRecipeLookupHandler<ElectrolysisRecipe> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_LEFT_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_RIGHT_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, NOT_ENOUGH_SPACE_LEFT_OUTPUT_ERROR, NOT_ENOUGH_SPACE_RIGHT_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final long MAX_GAS = 2400L;
    public static final int MAX_FLUID = 24000;
    private static final int BASE_DUMP_RATE = 8;
    private static final LongObjectToLongFunction<TileEntityElectrolyticSeparator> BASE_ENERGY_CALCULATOR = (base, tile) -> base * tile.getRecipeEnergyMultiplier();
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public BasicFluidTank fluidTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getLeftOutput", "getLeftOutputCapacity", "getLeftOutputNeeded", "getLeftOutputFilledPercentage"}, docPlaceholder="left output tank")
    public IChemicalTank leftTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getRightOutput", "getRightOutputCapacity", "getRightOutputNeeded", "getRightOutputFilledPercentage"}, docPlaceholder="right output tank")
    public IChemicalTank rightTank;
    @SyntheticComputerMethod(getter="getLeftOutputDumpingMode")
    public TileEntityChemicalTank.GasMode dumpLeft = TileEntityChemicalTank.GasMode.IDLE;
    @SyntheticComputerMethod(getter="getRightOutputDumpingMode")
    public TileEntityChemicalTank.GasMode dumpRight = TileEntityChemicalTank.GasMode.IDLE;
    private long clientEnergyUsed = 1L;
    private long recipeEnergyMultiplier = 1L;
    private int baselineMaxOperations = 1;
    private long dumpRate = 8L;
    private final IOutputHandler<@NotNull ElectrolysisRecipe.ElectrolysisRecipeOutput> outputHandler;
    private final IInputHandler<@NotNull FluidStack> inputHandler;
    private FixedUsageEnergyContainer<TileEntityElectrolyticSeparator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input item slot")
    FluidInventorySlot fluidSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getLeftOutputItem"}, docPlaceholder="left output item slot")
    ChemicalInventorySlot leftOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getRightOutputItem"}, docPlaceholder="right output item slot")
    ChemicalInventorySlot rightOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityElectrolyticSeparator(BlockPos pos, BlockState state) {
        super(MekanismBlocks.ELECTROLYTIC_SEPARATOR, pos, state, TRACKED_ERROR_TYPES);
        ConfigInfo gasConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, true, this.fluidSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT_1, new InventorySlotInfo(true, true, this.leftOutputSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT_2, new InventorySlotInfo(true, true, this.rightOutputSlot));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, this.fluidSlot, this.leftOutputSlot, this.rightOutputSlot));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, this.energySlot));
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL)) != null) {
            gasConfig.addSlotInfo(DataType.OUTPUT_1, new ChemicalSlotInfo(false, true, this.leftTank));
            gasConfig.addSlotInfo(DataType.OUTPUT_2, new ChemicalSlotInfo(false, true, this.rightTank));
        }
        this.configComponent.setupInputConfig(TransmissionType.FLUID, this.fluidTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.CHEMICAL).setCanTankEject(tank -> {
            if (tank == this.leftTank) {
                return this.dumpLeft != TileEntityChemicalTank.GasMode.DUMPING;
            }
            if (tank == this.rightTank) {
                return this.dumpRight != TileEntityChemicalTank.GasMode.DUMPING;
            }
            return true;
        });
        this.inputHandler = InputHelper.getInputHandler(this.fluidTank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler(this.leftTank, NOT_ENOUGH_SPACE_LEFT_OUTPUT_ERROR, this.rightTank, NOT_ENOUGH_SPACE_RIGHT_OUTPUT_ERROR);
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this);
        this.fluidTank = BasicFluidTank.input(24000, this::containsRecipe, recipeCacheListener);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig(this);
        this.leftTank = BasicChemicalTank.output(2400L, recipeCacheUnpauseListener);
        builder.addTank(this.leftTank);
        this.rightTank = BasicChemicalTank.output(2400L, recipeCacheUnpauseListener);
        builder.addTank(this.rightTank);
        return builder.build();
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this);
        this.energyContainer = FixedUsageEnergyContainer.input(this, BASE_ENERGY_CALCULATOR, recipeCacheUnpauseListener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this);
        this.fluidSlot = FluidInventorySlot.fill(this.fluidTank, listener, 26, 35);
        builder.addSlot(this.fluidSlot);
        this.leftOutputSlot = ChemicalInventorySlot.drain(this.leftTank, listener, 59, 52);
        builder.addSlot(this.leftOutputSlot);
        this.rightOutputSlot = ChemicalInventorySlot.drain(this.rightTank, listener, 101, 52);
        builder.addSlot(this.rightOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityElectrolyticSeparator)this).getLevel(), listener, 143, 35);
        builder.addSlot(this.energySlot);
        this.fluidSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.rightOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return builder.build();
    }

    @Override
    public void onCachedRecipeChanged(@Nullable CachedRecipe<ElectrolysisRecipe> cachedRecipe, int cacheIndex) {
        super.onCachedRecipeChanged(cachedRecipe, cacheIndex);
        this.recipeEnergyMultiplier = cachedRecipe == null ? 1L : cachedRecipe.getRecipe().getEnergyMultiplier();
        this.energyContainer.updateEnergyPerTick();
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidSlot.fillTank();
        this.leftOutputSlot.drainTank();
        this.rightOutputSlot.drainTank();
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
        this.handleTank(this.leftTank, this.dumpLeft);
        this.handleTank(this.rightTank, this.dumpRight);
        return sendUpdatePacket;
    }

    private void handleTank(IChemicalTank tank, TileEntityChemicalTank.GasMode mode) {
        if (!tank.isEmpty()) {
            long stored;
            long target;
            if (mode == TileEntityChemicalTank.GasMode.DUMPING) {
                tank.shrinkStack(this.dumpRate, Action.EXECUTE);
            } else if (mode == TileEntityChemicalTank.GasMode.DUMPING_EXCESS && (target = this.getDumpingExcessTarget(tank)) < (stored = tank.getStored())) {
                tank.shrinkStack(Math.min(stored - target, MekanismConfig.general.chemicalAutoEjectRate.get()), Action.EXECUTE);
            }
        }
    }

    private long getDumpingExcessTarget(IChemicalTank tank) {
        return MathUtils.clampToLong((double)tank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get());
    }

    private boolean atDumpingExcessTarget(IChemicalTank tank) {
        return tank.getStored() >= this.getDumpingExcessTarget(tank);
    }

    @Override
    public boolean canFunction() {
        return super.canFunction() && (this.dumpLeft != TileEntityChemicalTank.GasMode.DUMPING_EXCESS || this.dumpRight != TileEntityChemicalTank.GasMode.DUMPING_EXCESS || !this.atDumpingExcessTarget(this.leftTank) || !this.atDumpingExcessTarget(this.rightTank));
    }

    public long getRecipeEnergyMultiplier() {
        return this.recipeEnergyMultiplier;
    }

    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public long getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @Override
    @NotNull
    public IMekanismRecipeTypeProvider<SingleFluidRecipeInput, ElectrolysisRecipe, InputRecipeCache.SingleFluid<ElectrolysisRecipe>> getRecipeType() {
        return MekanismRecipeType.SEPARATING;
    }

    @Override
    public IRecipeViewerRecipeType<ElectrolysisRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.SEPARATING;
    }

    @Override
    @Nullable
    public ElectrolysisRecipe getRecipe(int cacheIndex) {
        return (ElectrolysisRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @Override
    @NotNull
    public CachedRecipe<ElectrolysisRecipe> createNewCachedRecipe(@NotNull ElectrolysisRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.separating(recipe, this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)x$0)).setCanHolderFunction(this::canFunction).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setBaselineMaxOperations(() -> this.baselineMaxOperations).setOnFinish(this::markForSave);
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            double speed = Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
            this.baselineMaxOperations = (int)speed;
            this.dumpRate = (long)(8.0 * speed);
        }
    }

    public FixedUsageEnergyContainer<TileEntityElectrolyticSeparator> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumpLeft = (TileEntityChemicalTank.GasMode)this.dumpLeft.getNext();
            this.markForSave();
        } else if (tank == 1) {
            this.dumpRight = (TileEntityChemicalTank.GasMode)this.dumpRight.getNext();
            this.markForSave();
        }
    }

    @Override
    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        NBTUtils.writeEnum(dataMap, "dump_left", this.dumpLeft);
        NBTUtils.writeEnum(dataMap, "dump_right", this.dumpRight);
    }

    @Override
    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        NBTUtils.setEnumIfPresent(dataMap, "dump_left", TileEntityChemicalTank.GasMode.BY_ID, mode -> {
            this.dumpLeft = mode;
        });
        NBTUtils.setEnumIfPresent(dataMap, "dump_right", TileEntityChemicalTank.GasMode.BY_ID, mode -> {
            this.dumpRight = mode;
        });
    }

    @Override
    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MekanismDataComponents.DUMP_MODE, (Object)this.dumpLeft);
        builder.set(MekanismDataComponents.SECONDARY_DUMP_MODE, (Object)this.dumpRight);
    }

    @Override
    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.dumpLeft = (TileEntityChemicalTank.GasMode)input.getOrDefault(MekanismDataComponents.DUMP_MODE, (Object)this.dumpLeft);
        this.dumpRight = (TileEntityChemicalTank.GasMode)input.getOrDefault(MekanismDataComponents.SECONDARY_DUMP_MODE, (Object)this.dumpRight);
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    @Override
    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableEnum.create(TileEntityChemicalTank.GasMode.BY_ID, TileEntityChemicalTank.GasMode.IDLE, () -> this.dumpLeft, value -> {
            this.dumpLeft = value;
        }));
        container.track(SyncableEnum.create(TileEntityChemicalTank.GasMode.BY_ID, TileEntityChemicalTank.GasMode.IDLE, () -> this.dumpRight, value -> {
            this.dumpRight = value;
        }));
        container.track(SyncableLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setLeftOutputDumpingMode(TileEntityChemicalTank.GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumpLeft != mode) {
            this.dumpLeft = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementLeftOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(0);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementLeftOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumpLeft = (TileEntityChemicalTank.GasMode)this.dumpLeft.getPrevious();
        this.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setRightOutputDumpingMode(TileEntityChemicalTank.GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumpRight != mode) {
            this.dumpRight = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementRightOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(1);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementRightOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumpRight = (TileEntityChemicalTank.GasMode)this.dumpRight.getPrevious();
        this.markForSave();
    }
}

